/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import arrow.core.Either;
import arrow.core.EitherKt;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmem.WebCommonDTOs.generated.PullResponseByReqIdReqProtos;
import com.bmc.ctmem.WebCommonDTOs.generated.SendERPRequestReqProtos;
import com.squareup.okhttp.MediaType;
import com.squareup.okhttp.OkHttpClient;
import com.squareup.okhttp.Request;
import com.squareup.okhttp.RequestBody;
import io.swagger.client.model.Variables;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Base64;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.collections.MapsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Charsets;
import kotlin.text.StringsKt;
import kotlinx.serialization.json.Json;
import kotlinx.serialization.json.JsonElement;
import kotlinx.serialization.json.JsonElementKt;
import kotlinx.serialization.json.JsonObject;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONObject;
import org.json.XML;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0010\u0012\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u001f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u001e\u0010\u000f\u001a\u001a\u0012\u0004\u0012\u00020\u0011\u0012\u0010\u0012\u000e\u0012\u0004\u0012\u00020\u0013\u0012\u0004\u0012\u00020\u00130\u00120\u0010J\u001d\u0010\u0014\u001a\n \u0015*\u0004\u0018\u00010\u00130\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u001d\u0010\u0019\u001a\n \u0015*\u0004\u0018\u00010\u00130\u00132\u0006\u0010\u0016\u001a\u00020\u0017H\u0002\u00a2\u0006\u0002\u0010\u0018J\u0010\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u001c\u001a\u00020\u0003H\u0002J\b\u0010\u001d\u001a\u00020\u001bH\u0002J\u0018\u0010\u001e\u001a\u00020\u001b2\u0006\u0010\u001f\u001a\u00020\u00032\u0006\u0010 \u001a\u00020!H\u0002J\b\u0010\"\u001a\u00020#H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u000e\u0010\f\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000e\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006$"}, d2={"Lcom/bmc/ctmconvert/IdlClient;", "", "token", "", "arguments", "Lcom/bmc/ctmconvert/Arguments;", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "<init>", "(Ljava/lang/String;Lcom/bmc/ctmconvert/Arguments;Lcom/bmc/ctmconvert/CommonLogger;)V", "getLogger", "()Lcom/bmc/ctmconvert/CommonLogger;", "baseUrl", "user", "server", "getVariablesList", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "Lkotlin/Pair;", "Lio/swagger/client/model/Variables;", "jsonToGlobalVariables", "kotlin.jvm.PlatformType", "json", "Lorg/json/JSONArray;", "(Lorg/json/JSONArray;)Lio/swagger/client/model/Variables;", "jsonToPoolVariables", "pullResponseByReqId", "Lkotlinx/serialization/json/JsonObject;", "requestId", "erpRequestGetVariablesList", "executeRequest", "endPoint", "data", "", "sslSocketFactory", "Ljavax/net/ssl/SSLSocketFactory;", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nIdlClient.kt\nKotlin\n*S Kotlin\n*F\n+ 1 IdlClient.kt\ncom/bmc/ctmconvert/IdlClient\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,125:1\n1557#2:126\n1628#2,3:127\n774#2:130\n865#2,2:131\n1557#2:133\n1628#2,3:134\n1557#2:137\n1628#2,3:138\n774#2:141\n865#2,2:142\n1557#2:144\n1628#2,3:145\n*S KotlinDebug\n*F\n+ 1 IdlClient.kt\ncom/bmc/ctmconvert/IdlClient\n*L\n61#1:126\n61#1:127,3\n62#1:130\n62#1:131,2\n63#1:133\n63#1:134,3\n68#1:137\n68#1:138,3\n69#1:141\n69#1:142,2\n70#1:144\n70#1:145,3\n*E\n"})
public final class IdlClient {
    @NotNull
    private final String token;
    @NotNull
    private final CommonLogger logger;
    @NotNull
    private final String baseUrl;
    @NotNull
    private final String user;
    @NotNull
    private final String server;

    public IdlClient(@NotNull String token, @NotNull Arguments arguments, @NotNull CommonLogger logger) {
        CharSequence charSequence;
        Intrinsics.checkNotNullParameter((Object)token, (String)"token");
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        this.token = token;
        this.logger = logger;
        IdlClient idlClient = this;
        CharSequence charSequence2 = arguments.getIdlClientEndpoint();
        if (StringsKt.isBlank((CharSequence)charSequence2)) {
            IdlClient idlClient2 = idlClient;
            boolean bl = false;
            charSequence = StringsKt.replace$default((String)arguments.getControl-m-automation-api-endpoint(), (String)"/automation-api", (String)"/ControlM/rest/EmWebServices/", (boolean)false, (int)4, null);
            idlClient = idlClient2;
        } else {
            charSequence = charSequence2;
        }
        idlClient.baseUrl = (String)charSequence;
        this.user = arguments.getControl-m-enterprise-manager-username();
        this.server = arguments.getControl-m-server-name();
    }

    @NotNull
    public final CommonLogger getLogger() {
        return this.logger;
    }

    @NotNull
    public final Either<ApiFailure, Pair<Variables, Variables>> getVariablesList() {
        try {
            JsonObject erpResponseJson = this.erpRequestGetVariablesList();
            String erpResponseDataEncoded = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)erpResponseJson), (Object)"data"))).getContent();
            byte[] byArray = Base64.getDecoder().decode(erpResponseDataEncoded);
            Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"decode(...)");
            byte[] byArray2 = byArray;
            Charset charset = Charsets.ISO_8859_1;
            String erpData = new String(byArray2, charset);
            String string = erpData.substring(4, erpData.length() - 2);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            String requestId = string;
            JsonObject responseByReqId = this.pullResponseByReqId(requestId);
            String variablesXml = JsonElementKt.getJsonPrimitive((JsonElement)((JsonElement)MapsKt.getValue((Map)((Map)responseByReqId), (Object)"strData"))).getContent();
            JSONObject variablesListJson = XML.toJSONObject((String)variablesXml).getJSONObject("ECSCM").getJSONObject("BODY").getJSONObject("GetVariablesList");
            if (variablesListJson.getInt("TotalNumberOfVariables") == 0) {
                return EitherKt.right((Object)TuplesKt.to((Object)new Variables().variables(CollectionsKt.emptyList()), (Object)new Variables().variables(CollectionsKt.emptyList())));
            }
            JSONArray variablesJson = variablesListJson.getJSONArray("Variable");
            Intrinsics.checkNotNull((Object)variablesJson);
            return EitherKt.right((Object)TuplesKt.to((Object)this.jsonToGlobalVariables(variablesJson), (Object)this.jsonToPoolVariables(variablesJson)));
        }
        catch (Exception e) {
            this.logger.error("Failed to get Variables via IDL client " + this.baseUrl, (Throwable)e);
            return (Either)new Either.Left((Object)new ApiFailure.GetVariablesViaIdlFailure((Throwable)e));
        }
    }

    /*
     * WARNING - void declaration
     */
    private final Variables jsonToGlobalVariables(JSONArray json) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JSONObject it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = (Iterable)json;
        Variables variables = new Variables();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.json.JSONObject");
            collection.add((JSONObject)it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JSONObject)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it.get("PoolName").toString()).length() == 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JSONObject)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)("%%\\\\Global\\" + it.get("VariableName")), (Object)it.get("VariableValue").toString())));
        }
        return variables.variables((List)destination$iv$iv);
    }

    /*
     * WARNING - void declaration
     */
    private final Variables jsonToPoolVariables(JSONArray json) {
        Iterable $this$filterTo$iv$iv;
        Iterable $this$filter$iv;
        JSONObject it;
        Collection collection;
        void $this$mapTo$iv$iv;
        Iterable $this$map$iv;
        Iterable iterable = (Iterable)json;
        Variables variables = new Variables();
        boolean $i$f$map = false;
        void var4_5 = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        Iterator iterator = $this$mapTo$iv$iv.iterator();
        while (iterator.hasNext()) {
            Object item$iv$iv;
            Object t = item$iv$iv = iterator.next();
            collection = destination$iv$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it, (String)"null cannot be cast to non-null type org.json.JSONObject");
            collection.add((JSONObject)it);
        }
        $this$map$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (JSONObject)element$iv$iv;
            boolean bl = false;
            boolean bl2 = ((CharSequence)it.get("PoolName").toString()).length() > 0;
            if (!bl2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        $this$filter$iv = (List)destination$iv$iv;
        $i$f$map = false;
        $this$filterTo$iv$iv = $this$map$iv;
        destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            it = (JSONObject)item$iv$iv;
            collection = destination$iv$iv;
            boolean bl = false;
            collection.add(MapsKt.mapOf((Pair)TuplesKt.to((Object)("%%\\\\" + it.get("PoolName") + "\\" + it.get("VariableName")), (Object)it.get("VariableValue").toString())));
        }
        return variables.variables((List)destination$iv$iv);
    }

    private final JsonObject pullResponseByReqId(String requestId) {
        PullResponseByReqIdReqProtos.PullResponseByReqIdReq pullResponseByReqIdReq = PullResponseByReqIdReqProtos.PullResponseByReqIdReq.newBuilder().setUserName(this.user).setUserToken(this.token).setRequestId(requestId).build();
        byte[] byArray = pullResponseByReqIdReq.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return this.executeRequest("PullTextResponseByReqId", byArray);
    }

    private final JsonObject erpRequestGetVariablesList() {
        String message = "<?xml version=\"1.0\"?><ECSCM><HEADER><Version>2.0</Version><ACTION>GetVariablesList</ACTION><DESTINATION>CTM Server</DESTINATION><Name>" + this.server + "</Name></HEADER><BODY><GetVariablesList><VariablesFilter><IsGlobalVariable>Yes</IsGlobalVariable><IsPoolVariable>Yes</IsPoolVariable><VariableName>*</VariableName><VariableValue>*</VariableValue><PoolName>*</PoolName><MaxNumberOfVariables>2000</MaxNumberOfVariables></VariablesFilter></GetVariablesList></BODY></ECSCM>";
        SendERPRequestReqProtos.SendERPRequestReq sendERPRequestReq = SendERPRequestReqProtos.SendERPRequestReq.newBuilder().setUserToken(this.token).setUserName(this.user).setCTMName(this.server).setMsg(message).setCallbackId("1").build();
        byte[] byArray = sendERPRequestReq.toByteArray();
        Intrinsics.checkNotNullExpressionValue((Object)byArray, (String)"toByteArray(...)");
        return this.executeRequest("SendERPRequest", byArray);
    }

    private final JsonObject executeRequest(String endPoint, byte[] data) {
        String dataEncoded = Base64.getEncoder().encodeToString(data);
        String requestJson = "{\"data\":\"" + dataEncoded + "\"}";
        RequestBody requestBody = RequestBody.create((MediaType)MediaType.parse((String)"application/json"), (String)requestJson);
        Intrinsics.checkNotNullExpressionValue((Object)requestBody, (String)"create(...)");
        RequestBody body = requestBody;
        Request request = new Request.Builder().url(this.baseUrl + endPoint).addHeader("Cookie", "EM_TOKEN=" + this.token).post(body).build();
        Intrinsics.checkNotNullExpressionValue((Object)request, (String)"build(...)");
        Request request2 = request;
        String response = new OkHttpClient().setSslSocketFactory(this.sslSocketFactory()).setHostnameVerifier(IdlClient::executeRequest$lambda$7).newCall(request2).execute().body().string();
        Intrinsics.checkNotNull((Object)response);
        return JsonElementKt.getJsonObject((JsonElement)Json.Default.parseToJsonElement(response));
    }

    private final SSLSocketFactory sslSocketFactory() {
        TrustManager[] trustManagerArray = new TrustManager[]{new X509TrustManager(){

            public void checkClientTrusted(X509Certificate[] chain, String authType) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            }

            public void checkServerTrusted(X509Certificate[] chain, String authType) {
                Intrinsics.checkNotNullParameter((Object)chain, (String)"chain");
                Intrinsics.checkNotNullParameter((Object)authType, (String)"authType");
            }

            public X509Certificate[] getAcceptedIssuers() {
                return new X509Certificate[0];
            }
        }};
        TrustManager[] trustAllCerts2 = trustManagerArray;
        SSLContext sslContext = SSLContext.getInstance("SSL");
        sslContext.init(null, trustAllCerts2, new SecureRandom());
        SSLSocketFactory sSLSocketFactory = sslContext.getSocketFactory();
        Intrinsics.checkNotNullExpressionValue((Object)sSLSocketFactory, (String)"getSocketFactory(...)");
        return sSLSocketFactory;
    }

    private static final boolean executeRequest$lambda$7(String string, SSLSession sSLSession) {
        return true;
    }
}

