/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import arrow.core.Either;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.AAPIClientBuilder;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.ArgumentsParser;
import com.bmc.ctmconvert.ArgumentsValidation;
import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.CommonLoggerImpl;
import com.bmc.ctmconvert.CompositePrinter;
import com.bmc.ctmconvert.Configuration;
import com.bmc.ctmconvert.ConfigurationKt;
import com.bmc.ctmconvert.ConsolePrinter;
import com.bmc.ctmconvert.ConsoleSpinner;
import com.bmc.ctmconvert.DataExtractor;
import com.bmc.ctmconvert.DataZipper;
import com.bmc.ctmconvert.ExtractedData;
import com.bmc.ctmconvert.Factory;
import com.bmc.ctmconvert.Feature;
import com.bmc.ctmconvert.FileSystemPermissionHandler;
import com.bmc.ctmconvert.FlowPrinter;
import com.bmc.ctmconvert.FlowPrinterKt;
import com.bmc.ctmconvert.LoggerPrinter;
import com.bmc.ctmconvert.OutputManager;
import com.bmc.ctmconvert.Printer;
import com.bmc.ctmconvert.VersionValidator;
import com.bmc.ctmconvert.aapiclient.DeploymentPoller;
import com.bmc.ctmconvert.aapiclient.MigrationAAPIClientPrinterDecorator;
import com.bmc.ctmconvert.databaseCommon.EmDatabase;
import com.bmc.ctmconvert.databaseCommon.EmDatabaseImpl;
import com.bmc.ctmconvert.deploy.HelixDeployer;
import com.bmc.ctmconvert.deploy.phases.PhaseStepsFactory;
import com.bmc.ctmconvert.migration.MigrationEngine;
import com.bmc.ctmconvert.migration.steps.MigrationStep;
import com.bmc.ctmconvert.qualifiction.QualificationEngine;
import com.bmc.ctmconvert.qualifyUtils.TargetHelixVersion;
import com.bmc.ctmconvert.validation.HelixValidator;
import io.swagger.client.model.AgentDetails;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Path;
import java.util.Collection;
import java.util.List;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.exposed.sql.Database;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u00ea\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u0000 p2\u00020\u0001:\u0001pB%\u0012\b\b\u0002\u0010\u0002\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJ\u0010\u00100\u001a\u0002012\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010@\u001a\u00020A2\u0006\u0010B\u001a\u00020CH\u0016J(\u0010D\u001a\u00020E2\u0006\u0010B\u001a\u00020C2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020I2\u0006\u00102\u001a\u000203H\u0016J\u0010\u0010H\u001a\u00020J2\u0006\u0010K\u001a\u00020LH\u0016JR\u0010Q\u001a\u00020R2(\u0010S\u001a$\u0012\u0004\u0012\u00020U\u0012\n\u0012\b\u0012\u0004\u0012\u00020W0V0Tj\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020W0V`X2\u0006\u0010Y\u001a\u00020Z2\u0006\u0010H\u001a\u00020I2\u0006\u0010[\u001a\u00020\\2\u0006\u0010]\u001a\u00020\\H\u0016J\b\u0010j\u001a\u00020kH\u0002R\u0014\u0010\u0002\u001a\u00020\u0003X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0004\u001a\u00020\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\rR\u0014\u0010\u000e\u001a\u00020\u000fX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0010\u0010\u0011R\u001b\u0010\u0012\u001a\u00020\u00138VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u0016\u0010\u0017\u001a\u0004\b\u0014\u0010\u0015R\u001b\u0010\u0018\u001a\u00020\u00198VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b\u001c\u0010\u0017\u001a\u0004\b\u001a\u0010\u001bR\u001b\u0010\u001d\u001a\u00020\u001e8VX\u0096\u0084\u0002\u00a2\u0006\f\n\u0004\b!\u0010\u0017\u001a\u0004\b\u001f\u0010 R\u0014\u0010\"\u001a\u00020#X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b$\u0010%R\u0014\u0010&\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b(\u0010)R\u0014\u0010*\u001a\u00020'X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b+\u0010)R\u0014\u0010,\u001a\u00020-X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b.\u0010/R\u0014\u00104\u001a\u000205X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b6\u00107R\u0014\u00108\u001a\u000209X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b:\u0010;R\u0014\u0010<\u001a\u00020=X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b>\u0010?R\u0014\u0010M\u001a\u00020NX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bO\u0010PR\u0014\u0010^\u001a\u00020_8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b`\u0010aR\u0014\u0010b\u001a\u00020_8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bc\u0010aR\u0014\u0010d\u001a\u00020_8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\be\u0010aR\u0014\u0010f\u001a\u00020_8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bg\u0010aR\u0014\u0010h\u001a\u00020_8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\bi\u0010aR\u0014\u0010l\u001a\u00020mX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\bn\u0010o\u00a8\u0006q"}, d2={"Lcom/bmc/ctmconvert/FactoryImpl;", "Lcom/bmc/ctmconvert/Factory;", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "configuration", "Lcom/bmc/ctmconvert/Configuration;", "consolePrinter", "Lcom/bmc/ctmconvert/Printer;", "<init>", "(Lcom/bmc/ctmconvert/CommonLogger;Lcom/bmc/ctmconvert/Configuration;Lcom/bmc/ctmconvert/Printer;)V", "getLogger", "()Lcom/bmc/ctmconvert/CommonLogger;", "getConfiguration", "()Lcom/bmc/ctmconvert/Configuration;", "printer", "Lcom/bmc/ctmconvert/CompositePrinter;", "getPrinter", "()Lcom/bmc/ctmconvert/CompositePrinter;", "targetSaasVersion", "Lcom/bmc/ctmconvert/qualifyUtils/TargetHelixVersion;", "getTargetSaasVersion", "()Lcom/bmc/ctmconvert/qualifyUtils/TargetHelixVersion;", "targetSaasVersion$delegate", "Lkotlin/Lazy;", "versionValidator", "Lcom/bmc/ctmconvert/VersionValidator;", "getVersionValidator", "()Lcom/bmc/ctmconvert/VersionValidator;", "versionValidator$delegate", "argumentsParser", "Lcom/bmc/ctmconvert/ArgumentsParser;", "getArgumentsParser", "()Lcom/bmc/ctmconvert/ArgumentsParser;", "argumentsParser$delegate", "argumentsValidation", "Lcom/bmc/ctmconvert/ArgumentsValidation;", "getArgumentsValidation", "()Lcom/bmc/ctmconvert/ArgumentsValidation;", "onPremAapiClientBuilder", "Lcom/bmc/ctmconvert/AAPIClientBuilder;", "getOnPremAapiClientBuilder", "()Lcom/bmc/ctmconvert/AAPIClientBuilder;", "helixAapiClientBuilder", "getHelixAapiClientBuilder", "dataExtractor", "Lcom/bmc/ctmconvert/DataExtractor;", "getDataExtractor", "()Lcom/bmc/ctmconvert/DataExtractor;", "migrationEngine", "Lcom/bmc/ctmconvert/migration/MigrationEngine;", "feature", "Lcom/bmc/ctmconvert/Feature;", "fileSystem", "Ljava/nio/file/FileSystem;", "getFileSystem", "()Ljava/nio/file/FileSystem;", "outputManager", "Lcom/bmc/ctmconvert/OutputManager;", "getOutputManager", "()Lcom/bmc/ctmconvert/OutputManager;", "spinner", "Lcom/bmc/ctmconvert/ConsoleSpinner;", "getSpinner", "()Lcom/bmc/ctmconvert/ConsoleSpinner;", "flowPrinter", "Lcom/bmc/ctmconvert/FlowPrinter;", "arguments", "Lcom/bmc/ctmconvert/Arguments;", "qualificationEngine", "Lcom/bmc/ctmconvert/qualifiction/QualificationEngine;", "data", "Lcom/bmc/ctmconvert/ExtractedData;", "emDatabase", "Lcom/bmc/ctmconvert/databaseCommon/EmDatabase;", "Lcom/bmc/ctmconvert/databaseCommon/EmDatabaseImpl;", "dbConnection", "Lorg/jetbrains/exposed/sql/Database;", "dataZipper", "Lcom/bmc/ctmconvert/DataZipper;", "getDataZipper", "()Lcom/bmc/ctmconvert/DataZipper;", "helixValidator", "Lcom/bmc/ctmconvert/validation/HelixValidator;", "agents", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "", "Lio/swagger/client/model/AgentDetails;", "Lcom/bmc/ctmconvert/ApiResult;", "helixClient", "Lcom/bmc/ctmconvert/AAPIClient;", "onPremCtmName", "", "helixCtmServerName", "phase1Factory", "Lcom/bmc/ctmconvert/deploy/phases/PhaseStepsFactory;", "getPhase1Factory", "()Lcom/bmc/ctmconvert/deploy/phases/PhaseStepsFactory;", "phase2Factory", "getPhase2Factory", "deployCtmServerFactory", "getDeployCtmServerFactory", "deployCtmServerFactoryV22100", "getDeployCtmServerFactoryV22100", "deployOnlyFactory", "getDeployOnlyFactory", "createHelixDeployer", "Lcom/bmc/ctmconvert/deploy/HelixDeployer;", "fileSystemPermissionsHandler", "Lcom/bmc/ctmconvert/FileSystemPermissionHandler;", "getFileSystemPermissionsHandler", "()Lcom/bmc/ctmconvert/FileSystemPermissionHandler;", "Companion", "migrateToSaaS"})
public final class FactoryImpl
implements Factory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final CommonLogger logger;
    @NotNull
    private final Configuration configuration;
    @NotNull
    private final CompositePrinter printer;
    @NotNull
    private final Lazy targetSaasVersion$delegate;
    @NotNull
    private final Lazy versionValidator$delegate;
    @NotNull
    private final Lazy argumentsParser$delegate;
    @NotNull
    private final ArgumentsValidation argumentsValidation;
    @NotNull
    private final AAPIClientBuilder onPremAapiClientBuilder;
    @NotNull
    private final AAPIClientBuilder helixAapiClientBuilder;
    @NotNull
    private final DataExtractor dataExtractor;
    @NotNull
    private final FileSystem fileSystem;
    @NotNull
    private final OutputManager outputManager;
    @NotNull
    private final ConsoleSpinner spinner;
    @NotNull
    private final DataZipper dataZipper;
    @NotNull
    private final FileSystemPermissionHandler fileSystemPermissionsHandler;

    public FactoryImpl(@NotNull CommonLogger logger, @NotNull Configuration configuration, @NotNull Printer consolePrinter) {
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        Intrinsics.checkNotNullParameter((Object)configuration, (String)"configuration");
        Intrinsics.checkNotNullParameter((Object)consolePrinter, (String)"consolePrinter");
        this.logger = logger;
        this.configuration = configuration;
        Object[] objectArray = new Printer[]{consolePrinter, new LoggerPrinter(this.getLogger())};
        this.printer = new CompositePrinter((Printer[])objectArray);
        this.targetSaasVersion$delegate = LazyKt.lazy(() -> FactoryImpl.targetSaasVersion_delegate$lambda$0(this));
        this.versionValidator$delegate = LazyKt.lazy(() -> FactoryImpl.versionValidator_delegate$lambda$1(this));
        this.argumentsParser$delegate = LazyKt.lazy(() -> FactoryImpl.argumentsParser_delegate$lambda$2(this));
        this.argumentsValidation = new ArgumentsValidation(this);
        this.onPremAapiClientBuilder = new AAPIClientBuilder(this.getConfiguration().getAutomationApiClientReadTimeOut-UwyO8pc(), this.getLogger(), (Printer)this.getPrinter(), null, 8, null);
        this.helixAapiClientBuilder = new AAPIClientBuilder(this.getConfiguration().getAutomationApiClientReadTimeOut-UwyO8pc(), this.getLogger(), (Printer)this.getPrinter(), (arg_0, arg_1) -> FactoryImpl.helixAapiClientBuilder$lambda$3(this, arg_0, arg_1), null);
        this.dataExtractor = new DataExtractor(this.getLogger());
        FileSystem fileSystem = FileSystems.getDefault();
        Intrinsics.checkNotNullExpressionValue((Object)fileSystem, (String)"getDefault(...)");
        this.fileSystem = fileSystem;
        this.outputManager = new OutputManager(this.getFileSystem(), (Printer)this.getPrinter(), this.createHelixDeployer(), this.getLogger(), this.getTargetSaasVersion());
        objectArray = new String[]{"\\", "|", "/", "-"};
        this.spinner = new ConsoleSpinner(null, 0L, CollectionsKt.listOf((Object[])objectArray), 3, null);
        this.dataZipper = new DataZipper(this.getLogger(), null, 2, null);
        this.fileSystemPermissionsHandler = new FileSystemPermissionHandler();
    }

    public /* synthetic */ FactoryImpl(CommonLogger commonLogger, Configuration configuration, Printer printer, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 1) != 0) {
            commonLogger = (CommonLogger)CommonLoggerImpl.INSTANCE;
        }
        if ((n & 2) != 0) {
            configuration = ConfigurationKt.readConfiguration(commonLogger);
        }
        if ((n & 4) != 0) {
            printer = (Printer)ConsolePrinter.INSTANCE;
        }
        this(commonLogger, configuration, printer);
    }

    @Override
    @NotNull
    public CommonLogger getLogger() {
        return this.logger;
    }

    @Override
    @NotNull
    public Configuration getConfiguration() {
        return this.configuration;
    }

    @NotNull
    public CompositePrinter getPrinter() {
        return this.printer;
    }

    @Override
    @NotNull
    public TargetHelixVersion getTargetSaasVersion() {
        Lazy lazy = this.targetSaasVersion$delegate;
        return (TargetHelixVersion)lazy.getValue();
    }

    @Override
    @NotNull
    public VersionValidator getVersionValidator() {
        Lazy lazy = this.versionValidator$delegate;
        return (VersionValidator)lazy.getValue();
    }

    @Override
    @NotNull
    public ArgumentsParser getArgumentsParser() {
        Lazy lazy = this.argumentsParser$delegate;
        return (ArgumentsParser)lazy.getValue();
    }

    @Override
    @NotNull
    public ArgumentsValidation getArgumentsValidation() {
        return this.argumentsValidation;
    }

    @Override
    @NotNull
    public AAPIClientBuilder getOnPremAapiClientBuilder() {
        return this.onPremAapiClientBuilder;
    }

    @Override
    @NotNull
    public AAPIClientBuilder getHelixAapiClientBuilder() {
        return this.helixAapiClientBuilder;
    }

    @Override
    @NotNull
    public DataExtractor getDataExtractor() {
        return this.dataExtractor;
    }

    @Override
    @NotNull
    public MigrationEngine migrationEngine(@NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return new MigrationEngine(MigrationStep.Companion.migrationSteps(feature));
    }

    @Override
    @NotNull
    public FileSystem getFileSystem() {
        return this.fileSystem;
    }

    @Override
    @NotNull
    public OutputManager getOutputManager() {
        return this.outputManager;
    }

    @Override
    @NotNull
    public ConsoleSpinner getSpinner() {
        return this.spinner;
    }

    @Override
    @NotNull
    public FlowPrinter flowPrinter(@NotNull Arguments arguments) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        return FlowPrinterKt.createFlowPrinter(arguments, this);
    }

    @Override
    @NotNull
    public QualificationEngine qualificationEngine(@NotNull Arguments arguments, @NotNull ExtractedData data, @NotNull EmDatabase emDatabase, @NotNull Feature feature) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)data, (String)"data");
        Intrinsics.checkNotNullParameter((Object)emDatabase, (String)"emDatabase");
        Intrinsics.checkNotNullParameter((Object)feature, (String)"feature");
        return new QualificationEngine(this.getConfiguration().getSaasParametersConfiguration(), this.getConfiguration().getLargeFoldersJobsCountThreshold(), emDatabase, arguments.getControl-m-server-name(), arguments, data, feature, (Printer)this.getPrinter(), this.getLogger(), this.getFileSystem());
    }

    @NotNull
    public EmDatabaseImpl emDatabase(@NotNull Database dbConnection) {
        Intrinsics.checkNotNullParameter((Object)dbConnection, (String)"dbConnection");
        return new EmDatabaseImpl(dbConnection, this.getConfiguration().getDatabaseTransactionTimeOut-UwyO8pc(), null, 4, null);
    }

    @Override
    @NotNull
    public DataZipper getDataZipper() {
        return this.dataZipper;
    }

    @Override
    @NotNull
    public HelixValidator helixValidator(@NotNull Either<? extends ApiFailure, ? extends List<? extends AgentDetails>> agents, @NotNull AAPIClient helixClient, @NotNull EmDatabase emDatabase, @NotNull String onPremCtmName, @NotNull String helixCtmServerName) {
        Intrinsics.checkNotNullParameter(agents, (String)"agents");
        Intrinsics.checkNotNullParameter((Object)helixClient, (String)"helixClient");
        Intrinsics.checkNotNullParameter((Object)emDatabase, (String)"emDatabase");
        Intrinsics.checkNotNullParameter((Object)onPremCtmName, (String)"onPremCtmName");
        Intrinsics.checkNotNullParameter((Object)helixCtmServerName, (String)"helixCtmServerName");
        return new HelixValidator(agents, this.getDataExtractor(), helixClient, emDatabase, onPremCtmName, helixCtmServerName);
    }

    @Override
    @NotNull
    public PhaseStepsFactory getPhase1Factory() {
        Path path = this.getFileSystem().getPath("inputParameters", new String[0]).resolve("phase1.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new PhaseStepsFactory(path, Companion.phase1DefaultDeploySteps());
    }

    @Override
    @NotNull
    public PhaseStepsFactory getPhase2Factory() {
        Path path = this.getFileSystem().getPath("inputParameters", new String[0]).resolve("phase2.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new PhaseStepsFactory(path, Companion.phase2DefaultDeploySteps());
    }

    @Override
    @NotNull
    public PhaseStepsFactory getDeployCtmServerFactory() {
        Path path = this.getFileSystem().getPath("inputParameters", new String[0]).resolve("deployctms.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new PhaseStepsFactory(path, Companion.deployCtmServerDeploySteps(false));
    }

    @Override
    @NotNull
    public PhaseStepsFactory getDeployCtmServerFactoryV22100() {
        Path path = this.getFileSystem().getPath("inputParameters", new String[0]).resolve("deployctms.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new PhaseStepsFactory(path, Companion.deployCtmServerDeploySteps(true));
    }

    @Override
    @NotNull
    public PhaseStepsFactory getDeployOnlyFactory() {
        Path path = this.getFileSystem().getPath("inputParameters", new String[0]).resolve("deploy_order.txt");
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"resolve(...)");
        return new PhaseStepsFactory(path, CollectionsKt.plus((Collection)Companion.phase1DefaultDeploySteps(), (Iterable)Companion.phase2DefaultDeploySteps()));
    }

    private final HelixDeployer createHelixDeployer() {
        return new HelixDeployer((Printer)this.getPrinter(), new DeploymentPoller(0L, 0, 3, null), this.getPhase1Factory(), this.getPhase2Factory(), this.getDeployOnlyFactory(), this.getDeployCtmServerFactory(), this.getDeployCtmServerFactoryV22100());
    }

    @Override
    @NotNull
    public FileSystemPermissionHandler getFileSystemPermissionsHandler() {
        return this.fileSystemPermissionsHandler;
    }

    private static final TargetHelixVersion targetSaasVersion_delegate$lambda$0(FactoryImpl this$0) {
        return this$0.getConfiguration().getTargetSaasVersion();
    }

    private static final VersionValidator versionValidator_delegate$lambda$1(FactoryImpl this$0) {
        return new VersionValidator(this$0.getConfiguration().getVersion(), (Printer)this$0.getPrinter(), this$0.getLogger(), null, 8, null);
    }

    private static final ArgumentsParser argumentsParser_delegate$lambda$2(FactoryImpl this$0) {
        return new ArgumentsParser(this$0.getConfiguration().getVersion());
    }

    private static final AAPIClient helixAapiClientBuilder$lambda$3(FactoryImpl this$0, AAPIClient client, Printer p) {
        Intrinsics.checkNotNullParameter((Object)client, (String)"client");
        Intrinsics.checkNotNullParameter((Object)p, (String)"p");
        return (AAPIClient)new MigrationAAPIClientPrinterDecorator(client, p, this$0.getLogger());
    }

    public FactoryImpl() {
        this(null, null, null, 7, null);
    }

    @Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u001e\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\f\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\f\u0010\u0007\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005J\u0014\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00060\u00052\u0006\u0010\t\u001a\u00020\n\u00a8\u0006\u000b"}, d2={"Lcom/bmc/ctmconvert/FactoryImpl$Companion;", "", "<init>", "()V", "phase1DefaultDeploySteps", "", "", "phase2DefaultDeploySteps", "deployCtmServerDeploySteps", "deployForV22100", "", "migrateToSaaS"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> phase1DefaultDeploySteps() {
            Object[] objectArray = new String[]{"EmSettings", "AIJobTypes", "CentralizedConnectionProfiles", "LocalConnectionProfiles", "SiteStandards", "SiteStandardPolicies", "RunAsUsers", "Roles", "WorkloadPolicies"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final List<String> phase2DefaultDeploySteps() {
            Object[] objectArray = new String[]{"RegularCalendars", "PeriodicCalendars", "RuleBasedCalendars", "NotificationDestinations", "HostGroups", "QuantitativeResources", "SharedVariables", "ServerSettings", "FolderDefinitions"};
            return CollectionsKt.listOf((Object[])objectArray);
        }

        @NotNull
        public final List<String> deployCtmServerDeploySteps(boolean deployForV22100) {
            Object[] objectArray = new String[]{"HostGroups", "RunAsUsers", "NotificationDestinations", "QuantitativeResources", "SharedVariables", "ServerSettings"};
            List steps = CollectionsKt.listOf((Object[])objectArray);
            return deployForV22100 ? steps : CollectionsKt.plus((Collection)CollectionsKt.plus((Collection)CollectionsKt.listOf((Object)"LocalConnectionProfiles"), (Iterable)steps), (Object)"FolderDefinitions");
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

