/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import com.bmc.ctmconvert.CommonLogger;
import com.bmc.ctmconvert.deploy.DeployResults;
import com.bmc.ctmconvert.deploy.DeployedEntity;
import com.bmc.ctmconvert.excelUtils.BaseExcelReporter;
import com.bmc.ctmconvert.excelUtils.BaseExcelReporterKt;
import com.bmc.ctmconvert.excelUtils.ExcelFile;
import com.bmc.ctmconvert.migration.ManualAction;
import com.bmc.ctmconvert.migration.MigratedEntity;
import com.bmc.ctmconvert.migration.MigrationAction;
import com.bmc.ctmconvert.migration.MigrationResults;
import com.bmc.ctmconvert.migration.steps.StepResult;
import com.bmc.ctmconvert.qualifiction.DiscoveredEntities;
import com.bmc.ctmconvert.qualifiction.QualificationReportResults;
import com.bmc.ctmconvert.qualifyUtils.QualificationSummary;
import com.bmc.ctmconvert.qualifyUtils.TestStatus;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.collections.SetsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.xssf.usermodel.XSSFSheet;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u0080\u0001\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0005\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010$\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\"\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u001e\n\u0002\u0018\u0002\n\u0002\b\r\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B!\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0007\u00a2\u0006\u0004\b\b\u0010\tJF\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\b\u0010\u0010\u001a\u0004\u0018\u00010\u00112\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u00132\u0018\u0010\u0015\u001a\u0014\u0012\u0004\u0012\u00020\u0014\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0016J\u000e\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00140\u0013H\u0016J\"\u0010\u0018\u001a\u00020\r2\u0006\u0010\u0019\u001a\u00020\u001a2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0013J\"\u0010\u001b\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0012\u0010\u0012\u001a\u000e\u0012\n\u0012\b\u0012\u0004\u0012\u00020\u00140\u00130\u0013J\u0018\u0010\u001c\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0016\u0010\u001d\u001a\b\u0012\u0004\u0012\u00020\u00140\u001e2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010\u001f\u001a\u00020 2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u0010!\u001a\u00020\u00142\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010\"\u001a\u00020\r2\u0006\u0010#\u001a\u00020$2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u0010%\u001a\u00020\r2\u0006\u0010#\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u001e\u0010'\u001a\u00020\r2\u0006\u0010(\u001a\u00020&2\f\u0010)\u001a\b\u0012\u0004\u0012\u00020+0*H\u0002J&\u0010,\u001a\u00020\r2\u0006\u0010-\u001a\u00020\u00142\u0006\u0010#\u001a\u00020&2\f\u0010.\u001a\b\u0012\u0004\u0012\u00020\u00140\u001eH\u0002J\u0018\u0010/\u001a\u00020\r2\u0006\u0010#\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0018\u00100\u001a\u00020\r2\u0006\u0010(\u001a\u00020&2\u0006\u0010\u0019\u001a\u00020\u001aH\u0002J \u00101\u001a\u00020\r2\u0006\u0010#\u001a\u00020&2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0015\u00102\u001a\n 3*\u0004\u0018\u00010$0$H\u0002\u00a2\u0006\u0002\u00104J\u0015\u00105\u001a\n 3*\u0004\u0018\u00010$0$H\u0002\u00a2\u0006\u0002\u00104J\u0010\u00106\u001a\u00020\r2\u0006\u0010#\u001a\u00020&H\u0002J\u0018\u00107\u001a\u00020\u00142\u0006\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u0011H\u0002J\u0010\u00108\u001a\u0002092\u0006\u0010\u000e\u001a\u00020\u000fH\u0002J\u0018\u0010:\u001a\u00020\r2\u0006\u0010;\u001a\u00020&2\u0006\u0010<\u001a\u00020=H\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u0006\u001a\u00020\u0007X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000b\u00a8\u0006>"}, d2={"Lcom/bmc/ctmconvert/ExcelReporter;", "Lcom/bmc/ctmconvert/excelUtils/BaseExcelReporter;", "filePath", "Ljava/nio/file/Path;", "logger", "Lcom/bmc/ctmconvert/CommonLogger;", "maxSheetRows", "", "<init>", "(Ljava/nio/file/Path;Lcom/bmc/ctmconvert/CommonLogger;I)V", "getMaxSheetRows", "()I", "initMigrationOrQualificationExcelFile", "", "qualificationResults", "Lcom/bmc/ctmconvert/qualifiction/QualificationReportResults;", "migrationResults", "Lcom/bmc/ctmconvert/migration/MigrationResults;", "parameters", "", "", "libMemSymPathAndUsages", "", "jobsNotQualifiedSheetColumns", "initDeploymentExcelFile", "deployResults", "Lcom/bmc/ctmconvert/deploy/DeployResults;", "initAgentsScopingExcelFile", "writeMigrationSummarySheet", "getFailureMessages", "", "isMigrationAborted", "", "getSectionHeader", "writeManualActions", "migrationSummarySheet", "Lorg/apache/poi/xssf/usermodel/XSSFSheet;", "writeMigratedEntitiesSection", "Lorg/apache/poi/ss/usermodel/Sheet;", "writeDeployedEntitiesSection", "deploySummarySheet", "deployedEntities", "", "Lcom/bmc/ctmconvert/deploy/DeployedEntity;", "writeDeployErrorsSection", "headerRow", "errors", "writeAutomaticallyAdjustedSection", "writeDeploySummaryMetadata", "writeMigrationSummaryMetadata", "createMigrationSummarySheet", "kotlin.jvm.PlatformType", "()Lorg/apache/poi/xssf/usermodel/XSSFSheet;", "createDeploymentSummarySheet", "handleMigrationSummarySheetCosmetics", "calculateMigrationStatus", "calculateQualificationStatus", "Lcom/bmc/ctmconvert/qualifyUtils/TestStatus;", "addQualificationDiscoveredEntitiesSection", "qualificationSummarySheet", "discoveredEntities", "Lcom/bmc/ctmconvert/qualifiction/DiscoveredEntities;", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nExcelReporter.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ExcelReporter.kt\ncom/bmc/ctmconvert/ExcelReporter\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,242:1\n1611#2,9:243\n1863#2:252\n1864#2:254\n1620#2:255\n1755#2,3:256\n1557#2:259\n1628#2,3:260\n1368#2:263\n1454#2,5:264\n1368#2:269\n1454#2,5:270\n1557#2:275\n1628#2,3:276\n1368#2:279\n1454#2,5:280\n1557#2:285\n1628#2,3:286\n774#2:289\n865#2,2:290\n1971#2,14:292\n1#3:253\n*S KotlinDebug\n*F\n+ 1 ExcelReporter.kt\ncom/bmc/ctmconvert/ExcelReporter\n*L\n92#1:243,9\n92#1:252\n92#1:254\n92#1:255\n98#1:256,3\n108#1:259\n108#1:260,3\n118#1:263\n118#1:264,5\n128#1:269\n128#1:270,5\n137#1:275\n137#1:276,3\n147#1:279\n147#1:280,5\n212#1:285\n212#1:286,3\n213#1:289\n213#1:290,2\n214#1:292,14\n92#1:253\n*E\n"})
public final class ExcelReporter
extends BaseExcelReporter {
    @NotNull
    private final Path filePath;
    private final int maxSheetRows;

    public ExcelReporter(@NotNull Path filePath, @NotNull CommonLogger logger, int maxSheetRows) {
        Intrinsics.checkNotNullParameter((Object)filePath, (String)"filePath");
        Intrinsics.checkNotNullParameter((Object)logger, (String)"logger");
        super(logger, maxSheetRows);
        this.filePath = filePath;
        this.maxSheetRows = maxSheetRows;
    }

    public /* synthetic */ ExcelReporter(Path path, CommonLogger commonLogger, int n, int n2, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n2 & 4) != 0) {
            n = 1000000;
        }
        this(path, commonLogger, n);
    }

    public int getMaxSheetRows() {
        return this.maxSheetRows;
    }

    public final void initMigrationOrQualificationExcelFile(@NotNull QualificationReportResults qualificationResults, @Nullable MigrationResults migrationResults, @NotNull List<? extends List<String>> parameters, @NotNull Map<String, ? extends List<String>> libMemSymPathAndUsages) {
        Intrinsics.checkNotNullParameter((Object)qualificationResults, (String)"qualificationResults");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Intrinsics.checkNotNullParameter(libMemSymPathAndUsages, (String)"libMemSymPathAndUsages");
        Collection<QualificationSummary> collection = qualificationResults.getSummary();
        MigrationResults migrationResults2 = migrationResults;
        List list = migrationResults2 != null ? migrationResults2.getSummary() : null;
        if (list == null) {
            list = CollectionsKt.emptyList();
        }
        Sheet sheet = this.writeQualificationSummarySheet(CollectionsKt.plus(collection, (Iterable)list), "Migrate to Control-M SaaS Qualification Result");
        this.addQualificationDiscoveredEntitiesSection(sheet, qualificationResults.getDiscoveredEntities());
        this.createSummaryColorFormattingRule(sheet);
        this.writeQualificationQuestionnaire("QualificationQuestionnaire.txt");
        this.writeJobsNotQualifiedSheet(qualificationResults.getJobsNotQualified());
        this.writeSheets(qualificationResults.getSheets());
        MigrationResults migrationResults3 = migrationResults;
        if (migrationResults3 != null) {
            MigrationResults it = migrationResults3;
            boolean bl = false;
            this.writeSheets(it.getSheets());
            this.writeMigrationSummarySheet(qualificationResults, it);
        }
        this.writeLibmemsymFilesSheet(libMemSymPathAndUsages);
        this.writeParametersSheet(parameters);
        this.writeExcelFile(this.filePath);
    }

    @NotNull
    public List<String> jobsNotQualifiedSheetColumns() {
        Object[] objectArray = new String[]{"Parent Folder", "Job Name", "What is the issue"};
        return CollectionsKt.listOf((Object[])objectArray);
    }

    public final void initDeploymentExcelFile(@NotNull DeployResults deployResults2, @NotNull List<? extends List<String>> parameters) {
        Intrinsics.checkNotNullParameter((Object)deployResults2, (String)"deployResults");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        XSSFSheet deploymentSummarySheet = this.createDeploymentSummarySheet();
        Intrinsics.checkNotNull((Object)deploymentSummarySheet);
        this.writeDeploySummaryMetadata((Sheet)deploymentSummarySheet, deployResults2);
        this.writeSheets(deployResults2.getSheets());
        this.writeParametersSheet(parameters);
        this.writeExcelFile(this.filePath);
    }

    public final void initAgentsScopingExcelFile(@NotNull QualificationReportResults qualificationResults, @NotNull List<? extends List<String>> parameters) {
        Intrinsics.checkNotNullParameter((Object)qualificationResults, (String)"qualificationResults");
        Intrinsics.checkNotNullParameter(parameters, (String)"parameters");
        Sheet sheet = this.writeQualificationSummarySheet(qualificationResults.getSummary(), "Agents Qualification Result");
        this.createSummaryColorFormattingRule(sheet);
        this.writeSheets(qualificationResults.getSheets());
        this.writeParametersSheet(parameters);
        this.writeExcelFile(this.filePath);
    }

    private final void writeMigrationSummarySheet(QualificationReportResults qualificationResults, MigrationResults migrationResults) {
        XSSFSheet migrationSummarySheet = this.createMigrationSummarySheet();
        Intrinsics.checkNotNull((Object)migrationSummarySheet);
        this.writeMigrationSummaryMetadata((Sheet)migrationSummarySheet, migrationResults, qualificationResults);
        this.writeMigratedEntitiesSection((Sheet)migrationSummarySheet, migrationResults);
        this.writeAutomaticallyAdjustedSection((Sheet)migrationSummarySheet, migrationResults);
        this.writeDeployedEntitiesSection((Sheet)migrationSummarySheet, migrationResults.getDeployedEntities());
        this.writeDeployErrorsSection(this.getSectionHeader(migrationResults), (Sheet)migrationSummarySheet, this.getFailureMessages(migrationResults));
        this.writeManualActions(migrationSummarySheet, migrationResults);
        this.handleMigrationSummarySheetCosmetics((Sheet)migrationSummarySheet);
    }

    /*
     * WARNING - void declaration
     */
    private final Set<String> getFailureMessages(MigrationResults migrationResults) {
        List failureMessages = CollectionsKt.emptyList();
        if (this.isMigrationAborted(migrationResults)) {
            void $this$mapNotNullTo$iv$iv;
            Iterable $this$mapNotNull$iv = migrationResults.getStepResults();
            boolean $i$f$mapNotNull = false;
            Iterable iterable = $this$mapNotNull$iv;
            Collection destination$iv$iv = new ArrayList();
            boolean $i$f$mapNotNullTo = false;
            void $this$forEach$iv$iv$iv = $this$mapNotNullTo$iv$iv;
            boolean $i$f$forEach = false;
            Iterator iterator = $this$forEach$iv$iv$iv.iterator();
            while (iterator.hasNext()) {
                String it$iv$iv;
                Object element$iv$iv$iv;
                Object element$iv$iv = element$iv$iv$iv = iterator.next();
                boolean bl = false;
                StepResult it = (StepResult)element$iv$iv;
                boolean bl2 = false;
                if (it.getFailureMessage() == null) continue;
                boolean bl3 = false;
                destination$iv$iv.add(it$iv$iv);
            }
            failureMessages = (List)destination$iv$iv;
        }
        return SetsKt.plus((Set)CollectionsKt.toSet((Iterable)failureMessages), (Iterable)migrationResults.getErrors());
    }

    private final boolean isMigrationAborted(MigrationResults migrationResults) {
        boolean bl;
        block3: {
            Iterable $this$any$iv = migrationResults.getStepResults();
            boolean $i$f$any = false;
            if ($this$any$iv instanceof Collection && ((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    StepResult it = (StepResult)element$iv;
                    boolean bl2 = false;
                    CharSequence charSequence = it.getFailureMessage();
                    if (!(!(charSequence == null || charSequence.length() == 0))) continue;
                    bl = true;
                    break block3;
                }
                bl = false;
            }
        }
        return bl;
    }

    private final String getSectionHeader(MigrationResults migrationResults) {
        if (this.isMigrationAborted(migrationResults)) {
            return "Deploy to Control-M SaaS Tenant aborted with below messages:";
        }
        return "Deploy to Control-M SaaS Tenant failed with below messages:";
    }

    /*
     * WARNING - void declaration
     */
    private final void writeManualActions(XSSFSheet migrationSummarySheet, MigrationResults migrationResults) {
        if (!((Collection)migrationResults.getManualActions()).isEmpty()) {
            Collection<List> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{"Required manual actions not performed:"};
            ExcelFile.addHeaderRow$default((ExcelFile)((ExcelFile)this), (Sheet)((Sheet)migrationSummarySheet), (String[])object, (int)0, (int)2, null);
            object = migrationResults.getManualActions();
            Sheet sheet = (Sheet)migrationSummarySheet;
            ExcelReporter excelReporter = this;
            boolean $i$f$map = false;
            void var5_7 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                ManualAction manualAction = (ManualAction)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CollectionsKt.listOf((Object)it.getMessage()));
            }
            collection = (List)destination$iv$iv;
            excelReporter.addRows(sheet, (List)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeMigratedEntitiesSection(Sheet migrationSummarySheet, MigrationResults migrationResults) {
        void $this$flatMapTo$iv$iv;
        Object[] objectArray = new String[]{"Entities that were migrated automatically to Control-M SaaS Tenant:", "Number of entities:"};
        ExcelFile.addHeaderRow$default((ExcelFile)((ExcelFile)this), (Sheet)migrationSummarySheet, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (int)2, null);
        Iterable $this$flatMap$iv = migrationResults.getMigratedEntities();
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MigratedEntity it = (MigratedEntity)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new String[]{it.getName(), String.valueOf(it.getCount())};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List migratedEntities = (List)destination$iv$iv;
        Object[] objectArray3 = new String[]{"", ""};
        BaseExcelReporter.addRows$default((BaseExcelReporter)this, (Sheet)migrationSummarySheet, (List)CollectionsKt.plus((Collection)migratedEntities, (Iterable)CollectionsKt.listOf((Object[])objectArray3)), (int)0, (int)2, null);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeDeployedEntitiesSection(Sheet deploySummarySheet, Collection<DeployedEntity> deployedEntities) {
        void $this$flatMapTo$iv$iv;
        Object[] objectArray = new String[]{"Entities that were deployed to Control-M SaaS Tenant:", "Number of entities:", "Comments"};
        ExcelFile.addHeaderRow$default((ExcelFile)((ExcelFile)this), (Sheet)deploySummarySheet, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (int)2, null);
        Iterable $this$flatMap$iv = deployedEntities;
        boolean $i$f$flatMap = false;
        Iterable iterable = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            DeployedEntity it = (DeployedEntity)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new String[]{it.getName(), it.getDeployedCount() + " / " + it.getTotalCount(), CollectionsKt.joinToString$default((Iterable)it.getMessages(), (CharSequence)" ", null, null, (int)0, null, null, (int)62, null)};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List migratedEntities = (List)destination$iv$iv;
        Object[] objectArray3 = new String[]{"", ""};
        this.addRows(deploySummarySheet, CollectionsKt.plus((Collection)migratedEntities, (Iterable)CollectionsKt.listOf((Object[])objectArray3)), 3);
    }

    /*
     * WARNING - void declaration
     */
    private final void writeDeployErrorsSection(String headerRow, Sheet migrationSummarySheet, Set<String> errors) {
        if (!((Collection)errors).isEmpty()) {
            Collection<List> collection;
            void $this$mapTo$iv$iv;
            void $this$map$iv;
            Object object = new String[]{headerRow};
            ExcelFile.addHeaderRow$default((ExcelFile)((ExcelFile)this), (Sheet)migrationSummarySheet, (String[])object, (int)0, (int)2, null);
            object = errors;
            Sheet sheet = migrationSummarySheet;
            ExcelReporter excelReporter = this;
            boolean $i$f$map = false;
            void var6_8 = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                String string = (String)item$iv$iv;
                collection = destination$iv$iv;
                boolean bl = false;
                collection.add(CollectionsKt.listOf((Object)it));
            }
            collection = (List)destination$iv$iv;
            excelReporter.addRows(sheet, (List)collection);
        }
    }

    /*
     * WARNING - void declaration
     */
    private final void writeAutomaticallyAdjustedSection(Sheet migrationSummarySheet, MigrationResults migrationResults) {
        void $this$flatMapTo$iv$iv;
        void $this$flatMap$iv;
        Object[] objectArray = new String[]{"Entities that were Automatically Adjusted during the migration to Control-M SaaS:", "Number of entities:"};
        ExcelFile.addHeaderRow$default((ExcelFile)((ExcelFile)this), (Sheet)migrationSummarySheet, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (int)2, null);
        objectArray = migrationResults.getMigrations();
        Sheet sheet = migrationSummarySheet;
        BaseExcelReporter baseExcelReporter = this;
        boolean $i$f$flatMap = false;
        void var5_7 = $this$flatMap$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$flatMapTo = false;
        for (Object element$iv$iv : $this$flatMapTo$iv$iv) {
            MigrationAction it = (MigrationAction)element$iv$iv;
            boolean bl = false;
            Object[] objectArray2 = new String[]{it.getName(), String.valueOf(it.getCount())};
            Iterable list$iv$iv = CollectionsKt.listOf((Object[])objectArray2);
            CollectionsKt.addAll((Collection)destination$iv$iv, (Iterable)list$iv$iv);
        }
        List list = (List)destination$iv$iv;
        objectArray = new String[]{"", ""};
        BaseExcelReporter.addRows$default((BaseExcelReporter)baseExcelReporter, (Sheet)sheet, (List)CollectionsKt.plus((Collection)list, (Iterable)CollectionsKt.listOf((Object[])objectArray)), (int)0, (int)2, null);
    }

    private final void writeDeploySummaryMetadata(Sheet deploySummarySheet, DeployResults deployResults2) {
        Object[] objectArray = new String[]{"Deploying Control-M Server Definitions '" + deployResults2.getOnPremCtmServer() + "' to Control-M SaaS Tenant Summary", "Value"};
        List headers = CollectionsKt.listOf((Object[])objectArray);
        this.createHeader(deploySummarySheet, headers);
        objectArray = new String[]{"control-m-saas-automation-api-endpoint:", deployResults2.getSaasAapiEndpoint(), "Deploy result:", deployResults2.getDeployStatus().name(), "", ""};
        BaseExcelReporter.addRows$default((BaseExcelReporter)this, (Sheet)deploySummarySheet, (String[])objectArray, (int)0, (int)2, null);
        this.writeDeployedEntitiesSection(deploySummarySheet, deployResults2.getDeployedEntities());
        this.writeDeployErrorsSection("Deploy to Control-M SaaS Tenant failed with below messages:", deploySummarySheet, deployResults2.getErrors());
        Cell cell = BaseExcelReporterKt.findCellWithText((Sheet)deploySummarySheet, (String)deployResults2.getSaasAapiEndpoint());
        if (cell != null) {
            cell.setCellStyle((CellStyle)this.getBlueCellStyle());
        }
        this.createSummaryColorFormattingRule(deploySummarySheet);
    }

    private final void writeMigrationSummaryMetadata(Sheet migrationSummarySheet, MigrationResults migrationResults, QualificationReportResults qualificationResults) {
        block0: {
            Object[] objectArray = new String[]{"Migration from Control-M Server '" + migrationResults.getCtmServer() + "' to Control-M SaaS Tenant Summary", "Value"};
            List headers = CollectionsKt.listOf((Object[])objectArray);
            this.createHeader(migrationSummarySheet, headers);
            String migrationStatus = this.calculateMigrationStatus(qualificationResults, migrationResults);
            String[] stringArray = new String[]{"control-m-saas-automation-api-endpoint:", migrationResults.getSaasAapiEndpoint(), "Migration result:", migrationStatus, "", ""};
            BaseExcelReporter.addRows$default((BaseExcelReporter)this, (Sheet)migrationSummarySheet, (String[])stringArray, (int)0, (int)2, null);
            Cell cell = BaseExcelReporterKt.findCellWithText((Sheet)migrationSummarySheet, (String)migrationResults.getSaasAapiEndpoint());
            if (cell == null) break block0;
            cell.setCellStyle((CellStyle)this.getBlueCellStyle());
        }
    }

    private final XSSFSheet createMigrationSummarySheet() {
        return this.getWorkbook().createSheet("Migration Summary");
    }

    private final XSSFSheet createDeploymentSummarySheet() {
        return this.getWorkbook().createSheet("Deployment Summary");
    }

    private final void handleMigrationSummarySheetCosmetics(Sheet migrationSummarySheet) {
        this.getWorkbook().setSheetOrder(migrationSummarySheet.getSheetName(), 0);
        this.getWorkbook().setSelectedTab(0);
        this.getWorkbook().setActiveSheet(0);
        this.createMigrationResultColorFormattingRule(migrationSummarySheet);
    }

    private final String calculateMigrationStatus(QualificationReportResults qualificationResults, MigrationResults migrationResults) {
        TestStatus qualificationStatus = this.calculateQualificationStatus(qualificationResults);
        return migrationResults.getSuccessful() ? qualificationStatus.name() : migrationResults.getMigrationStatus().name();
    }

    /*
     * WARNING - void declaration
     */
    private final TestStatus calculateQualificationStatus(QualificationReportResults qualificationResults) {
        TestStatus testStatus;
        Object v0;
        void $this$filterTo$iv$iv;
        TestStatus it;
        Iterable $this$mapTo$iv$iv;
        Iterable $this$map$iv = qualificationResults.getSummary();
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            QualificationSummary qualificationSummary = (QualificationSummary)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(it.getTestStatus());
        }
        Iterable $this$filter$iv = (List)destination$iv$iv;
        boolean $i$f$filter = false;
        $this$mapTo$iv$iv = $this$filter$iv;
        destination$iv$iv = new ArrayList();
        boolean $i$f$filterTo = false;
        for (Object element$iv$iv : $this$filterTo$iv$iv) {
            it = (TestStatus)element$iv$iv;
            boolean bl = false;
            Object[] objectArray = new TestStatus[]{TestStatus.Pass, TestStatus.Incompatibility found, TestStatus.Error};
            if (!CollectionsKt.listOf((Object[])objectArray).contains(it)) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        Iterable $this$maxByOrNull$iv = (List)destination$iv$iv;
        boolean $i$f$maxByOrNull = false;
        Iterator iterator$iv = $this$maxByOrNull$iv.iterator();
        if (!iterator$iv.hasNext()) {
            v0 = null;
        } else {
            Object maxElem$iv = iterator$iv.next();
            if (!iterator$iv.hasNext()) {
                v0 = maxElem$iv;
            } else {
                int n;
                TestStatus it2 = (TestStatus)maxElem$iv;
                boolean bl = false;
                switch (WhenMappings.$EnumSwitchMapping$0[it2.ordinal()]) {
                    case 1: {
                        n = 1;
                        break;
                    }
                    case 2: {
                        n = 2;
                        break;
                    }
                    case 3: {
                        n = 3;
                        break;
                    }
                    default: {
                        n = 1;
                    }
                }
                int maxValue$iv = n;
                do {
                    int n2;
                    Object e$iv = iterator$iv.next();
                    TestStatus it3 = (TestStatus)e$iv;
                    $i$a$-maxByOrNull-ExcelReporter$calculateQualificationStatus$3 = false;
                    switch (WhenMappings.$EnumSwitchMapping$0[it3.ordinal()]) {
                        case 1: {
                            n2 = 1;
                            break;
                        }
                        case 2: {
                            n2 = 2;
                            break;
                        }
                        case 3: {
                            n2 = 3;
                            break;
                        }
                        default: {
                            n2 = 1;
                        }
                    }
                    int v$iv = n2;
                    if (maxValue$iv >= v$iv) continue;
                    maxElem$iv = e$iv;
                    maxValue$iv = v$iv;
                } while (iterator$iv.hasNext());
                v0 = maxElem$iv;
            }
        }
        if ((testStatus = (TestStatus)v0) == null) {
            testStatus = TestStatus.Pass;
        }
        return testStatus;
    }

    private final void addQualificationDiscoveredEntitiesSection(Sheet qualificationSummarySheet, DiscoveredEntities discoveredEntities) {
        Object[] objectArray = new String[]{"", ""};
        BaseExcelReporter.addRows$default((BaseExcelReporter)this, (Sheet)qualificationSummarySheet, (String[])objectArray, (int)0, (int)2, null);
        objectArray = new String[]{"Control-M Folders and Jobs:", "Number of entities"};
        ExcelFile.addHeaderRow$default((ExcelFile)((ExcelFile)this), (Sheet)qualificationSummarySheet, (Collection)CollectionsKt.listOf((Object[])objectArray), (int)0, (int)2, null);
        objectArray = new String[]{"Control-M Folders:", discoveredEntities.getNumberOfFolders()};
        this.addRows(qualificationSummarySheet, (String[])objectArray, 2);
        objectArray = new String[]{"Control-M Cyclic Folders:", discoveredEntities.getNumberOfCyclicFolders()};
        this.addRows(qualificationSummarySheet, (String[])objectArray, 2);
        objectArray = new String[]{"Control-M Jobs:", discoveredEntities.getNumberOfJobs()};
        this.addRows(qualificationSummarySheet, (String[])objectArray, 2);
        objectArray = new String[]{"Control-M Cyclic Jobs:", discoveredEntities.getNumberOfCyclicJobs()};
        this.addRows(qualificationSummarySheet, (String[])objectArray, 2);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[TestStatus.values().length];
            try {
                nArray[TestStatus.Pass.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.Incompatibility found.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[TestStatus.Error.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

