/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert;

import arrow.core.Either;
import com.bmc.ctmconvert.AAPIClient;
import com.bmc.ctmconvert.AAPIClientBuilder;
import com.bmc.ctmconvert.AAPIClientKt;
import com.bmc.ctmconvert.Action;
import com.bmc.ctmconvert.ApiFailure;
import com.bmc.ctmconvert.Arguments;
import com.bmc.ctmconvert.ArgumentsValidationKt;
import com.bmc.ctmconvert.ArgumentsValidationResult;
import com.bmc.ctmconvert.CtmQualificationMode;
import com.bmc.ctmconvert.DataExtractorKt;
import com.bmc.ctmconvert.DeployCtmServerMode;
import com.bmc.ctmconvert.DeployOnlyMode;
import com.bmc.ctmconvert.DeployPhase1Mode;
import com.bmc.ctmconvert.DeployPhase2Mode;
import com.bmc.ctmconvert.ExtractMode;
import com.bmc.ctmconvert.Factory;
import com.bmc.ctmconvert.HttpProxy;
import com.bmc.ctmconvert.IdlClient;
import com.bmc.ctmconvert.InValidArguments;
import com.bmc.ctmconvert.IndexedLine;
import com.bmc.ctmconvert.LibMemSymConfFileReader;
import com.bmc.ctmconvert.LibMemSymData;
import com.bmc.ctmconvert.MigrateMode;
import com.bmc.ctmconvert.Printer;
import com.bmc.ctmconvert.QualificationMode;
import com.bmc.ctmconvert.ValidatedArguments;
import com.bmc.ctmconvert.databaseCommon.DatabaseConnection;
import com.bmc.ctmconvert.databaseCommon.DatabaseConnectionKt;
import com.bmc.ctmconvert.databaseCommon.EmDatabaseParameters;
import com.bmc.ctmconvert.databaseCommon.UserReport;
import com.bmc.ctmconvert.qualifyUtils.Version;
import io.swagger.client.ApiClient;
import io.swagger.client.model.CtmDetails;
import io.swagger.client.model.LoginResult;
import java.nio.file.FileSystem;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.Pair;
import kotlin.Triple;
import kotlin.TuplesKt;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.exposed.sql.Database;

@Metadata(mv={2, 0, 0}, k=1, xi=48, d1={"\u0000\u009e\u0001\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000b\n\u0002\b\u0005\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0004\b\u0004\u0010\u0005J \u0010\t\u001a\u00020\n2\b\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u0010J\u001e\u0010\u0011\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0012\u001a\u00020\u0013J!\u0010\u0014\u001a\n \u0016*\u0004\u0018\u00010\u00150\u0015*\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002\u00a2\u0006\u0002\u0010\u0017J\u0018\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0018\u0010\u001b\u001a\u00020\u00192\u0006\u0010\u001c\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0016\u0010\u001d\u001a\u00020\u00192\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0018\u0010!\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u00152\u0006\u0010\u001a\u001a\u00020\u0007H\u0002J\u001e\u0010#\u001a\u00020\u00192\u0006\u0010\u000f\u001a\u00020\u00102\f\u0010\u001e\u001a\b\u0012\u0004\u0012\u00020 0\u001fH\u0002J\u0010\u0010$\u001a\u00020\u00192\u0006\u0010\"\u001a\u00020\u0015H\u0002J\u0018\u0010%\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0010\u0010'\u001a\u00020\n2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0018\u0010(\u001a\u00020\n2\u0006\u0010&\u001a\u00020\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0012\u0010)\u001a\u0004\u0018\u00010*2\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001a\u0010+\u001a\u0004\u0018\u00010\u00072\u0006\u0010,\u001a\u00020\u00072\u0006\u0010\u000f\u001a\u00020\u0010H\u0002J\u0012\u0010-\u001a\u0004\u0018\u00010\u00132\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u001c\u0010.\u001a\u00020/2\u0006\u0010\r\u001a\u00020\u000e2\n\u00100\u001a\u000601j\u0002`2H\u0002J(\u00103\u001a\u001a\u0012\u0006\u0012\u0004\u0018\u00010*\u0012\u0006\u0012\u0004\u0018\u00010\u0007\u0012\u0006\u0012\u0004\u0018\u00010\u0007042\u0006\u0010\r\u001a\u00020\u000eH\u0002J\u0014\u00105\u001a\u00020/*\u0002062\u0006\u00107\u001a\u00020\u0019H\u0002J\u001c\u00108\u001a\u0004\u0018\u00010*2\u0006\u00109\u001a\u00020\u00072\b\u0010:\u001a\u0004\u0018\u00010*H\u0002J\u0010\u0010;\u001a\u00020\u00072\u0006\u0010<\u001a\u00020\u0007H\u0002J.\u0010=\u001a\u000e\u0012\u0004\u0012\u00020*\u0012\u0004\u0012\u00020\u00190>2\u0006\u0010?\u001a\u00020\u00072\u0006\u0010@\u001a\u00020\u00072\b\u0010A\u001a\u0004\u0018\u00010BH\u0002J4\u0010C\u001a\u001c\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020F\u0018\u00010Dj\n\u0012\u0004\u0012\u00020F\u0018\u0001`G2\b\u0010H\u001a\u0004\u0018\u00010*2\u0006\u0010\r\u001a\u00020\u000eH\u0002J(\u0010I\u001a\u0004\u0018\u00010\u00072\u001c\u0010J\u001a\u0018\u0012\u0004\u0012\u00020E\u0012\u0004\u0012\u00020F0Dj\b\u0012\u0004\u0012\u00020F`GH\u0002R\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000\u00a8\u0006K"}, d2={"Lcom/bmc/ctmconvert/ArgumentsValidation;", "", "factory", "Lcom/bmc/ctmconvert/Factory;", "<init>", "(Lcom/bmc/ctmconvert/Factory;)V", "aapiString", "", "automationApiString", "validateArguments", "Lcom/bmc/ctmconvert/ArgumentsValidationResult;", "dbConnection", "Lcom/bmc/ctmconvert/databaseCommon/DatabaseConnection;", "arguments", "Lcom/bmc/ctmconvert/Arguments;", "fileSystem", "Ljava/nio/file/FileSystem;", "validateArgumentsForAgentsScoping", "emDatabase", "Lorg/jetbrains/exposed/sql/Database;", "toPath", "Ljava/nio/file/Path;", "kotlin.jvm.PlatformType", "(Ljava/lang/String;Ljava/nio/file/FileSystem;)Ljava/nio/file/Path;", "isValidLibMemSym", "", "libmemsymControlMFilePath", "isNotValidTimeZoneMapping", "pathValue", "isNotValidPoolNames", "libMemSymData", "", "Lcom/bmc/ctmconvert/LibMemSymData;", "isNotExistsLibMemSymControlFile", "libMemSymMappingPath", "isValidLibMemSymLocalPaths", "doesContainInvalidLines", "qualificationValidation", "db", "deployValidation", "migrationValidation", "validateHelixEndpointForMigrationMode", "Lcom/bmc/ctmconvert/AAPIClient;", "validateOutputFolder", "path", "validateDatabaseArguments", "printMessageInvalidDatabaseParameters", "", "e", "Ljava/lang/Exception;", "Lkotlin/Exception;", "validateOnPremApiClient", "Lkotlin/Triple;", "disableAAPIPrinterForModes", "Lcom/bmc/ctmconvert/AAPIClientBuilder;", "isPrintErrorsToConsoleEnabled", "validateOnPremServer", "serverName", "apiClientOnPrem", "updateHelixUrlToBeValid", "endPoint", "validateHelixConnection", "Lkotlin/Pair;", "helixEndpoint", "helixToken", "httpProxy", "Lcom/bmc/ctmconvert/HttpProxy;", "loginToOnPremAPI", "Larrow/core/Either;", "Lcom/bmc/ctmconvert/ApiFailure;", "Lio/swagger/client/model/LoginResult;", "Lcom/bmc/ctmconvert/ApiResult;", "aapiClient", "initVersion", "loginResult", "migrateToSaaS"})
@SourceDebugExtension(value={"SMAP\nArgumentsValidation.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ArgumentsValidation.kt\ncom/bmc/ctmconvert/ArgumentsValidation\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 Either.kt\narrow/core/Either\n+ 4 Either.kt\narrow/core/EitherKt\n*L\n1#1,383:1\n827#2:384\n855#2,2:385\n774#2:387\n865#2,2:388\n1557#2:393\n1628#2,3:394\n295#2,2:403\n858#3:390\n804#3,4:399\n858#3:405\n1223#4,2:391\n1225#4,2:397\n1223#4,4:406\n*S KotlinDebug\n*F\n+ 1 ArgumentsValidation.kt\ncom/bmc/ctmconvert/ArgumentsValidation\n*L\n86#1:384\n86#1:385,2\n117#1:387\n117#1:388,2\n222#1:393\n222#1:394,3\n270#1:403,2\n222#1:390\n246#1:399,4\n325#1:405\n222#1:391,2\n222#1:397,2\n325#1:406,4\n*E\n"})
public final class ArgumentsValidation {
    @NotNull
    private final Factory factory;
    @NotNull
    private final String aapiString;
    @NotNull
    private final String automationApiString;

    public ArgumentsValidation(@NotNull Factory factory) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        this.factory = factory;
        this.aapiString = "-aapi";
        this.automationApiString = "/automation-api";
    }

    @NotNull
    public final ArgumentsValidationResult validateArguments(@Nullable DatabaseConnection dbConnection, @NotNull Arguments arguments, @NotNull FileSystem fileSystem) {
        DatabaseConnection databaseConnection;
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        String validateOutputFolder = this.validateOutputFolder(arguments.getOutput-folder-path(), fileSystem);
        String string = arguments.getSaasAapiEndpoint();
        if (string != null) {
            String it = string;
            boolean bl = false;
            arguments.setSaasAapiEndpoint(this.updateHelixUrlToBeValid(it));
        }
        if (((databaseConnection = dbConnection) == null || (databaseConnection = databaseConnection.connect()) == null) && (databaseConnection = this.validateDatabaseArguments(arguments)) == null) {
            return InValidArguments.INSTANCE;
        }
        DatabaseConnection db = databaseConnection;
        if (validateOutputFolder == null) {
            return InValidArguments.INSTANCE;
        }
        return (ArgumentsValidationResult)arguments.getAction().builder().whenMode(DeployCtmServerMode.INSTANCE.or(DeployOnlyMode.INSTANCE).or(DeployPhase1Mode.INSTANCE).or(DeployPhase2Mode.INSTANCE), () -> ArgumentsValidation.validateArguments$lambda$1(this, arguments)).whenMode(MigrateMode.INSTANCE, () -> ArgumentsValidation.validateArguments$lambda$2(this, arguments, fileSystem, (Database)db)).whenMode(ExtractMode.INSTANCE, () -> ArgumentsValidation.validateArguments$lambda$3(this, arguments, fileSystem, (Database)db)).whenMode(QualificationMode.INSTANCE.or(CtmQualificationMode.INSTANCE), () -> ArgumentsValidation.validateArguments$lambda$4(this, (Database)db, arguments)).buildResultOrElse(() -> ArgumentsValidation.validateArguments$lambda$5(this, (Database)db, arguments));
    }

    @NotNull
    public final ArgumentsValidationResult validateArgumentsForAgentsScoping(@NotNull Arguments arguments, @NotNull FileSystem fileSystem, @NotNull Database emDatabase) {
        Intrinsics.checkNotNullParameter((Object)arguments, (String)"arguments");
        Intrinsics.checkNotNullParameter((Object)fileSystem, (String)"fileSystem");
        Intrinsics.checkNotNullParameter((Object)emDatabase, (String)"emDatabase");
        if (this.validateOutputFolder(arguments.getOutput-folder-path(), fileSystem) == null) {
            return InValidArguments.INSTANCE;
        }
        return this.qualificationValidation(emDatabase, arguments);
    }

    private final Path toPath(String $this$toPath, FileSystem fileSystem) {
        return fileSystem.getPath($this$toPath, new String[0]);
    }

    private final boolean isValidLibMemSym(String libmemsymControlMFilePath, FileSystem fileSystem) {
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)libmemsymControlMFilePath)).toString()).length() == 0) {
            return true;
        }
        Path libMemSymMappingPath = this.toPath(libmemsymControlMFilePath, fileSystem);
        Intrinsics.checkNotNull((Object)libMemSymMappingPath);
        if (this.isNotExistsLibMemSymControlFile(libMemSymMappingPath, libmemsymControlMFilePath)) {
            return false;
        }
        if (this.doesContainInvalidLines(libMemSymMappingPath)) {
            return false;
        }
        List<LibMemSymData> libMemSymData = new LibMemSymConfFileReader(libMemSymMappingPath).getLibMemSymEntries();
        if (this.isNotValidPoolNames(libMemSymData)) {
            return false;
        }
        return this.isValidLibMemSymLocalPaths(fileSystem, libMemSymData);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private final boolean isNotValidTimeZoneMapping(String pathValue, FileSystem fileSystem) {
        if (((CharSequence)((Object)StringsKt.trim((CharSequence)pathValue)).toString()).length() <= 0) return false;
        boolean bl = true;
        if (!bl) return false;
        Path path = fileSystem.getPath(pathValue, new String[0]);
        Intrinsics.checkNotNullExpressionValue((Object)path, (String)"getPath(...)");
        if (Files.isReadable(path)) return false;
        boolean bl2 = true;
        boolean isNotValid = bl2;
        if (!isNotValid) return isNotValid;
        this.factory.getPrinter().print(StringsKt.trimMargin$default((String)("Time Zone Mapping file path '" + pathValue + "' could not be found.\n                    |Please make sure that the path provided in the parameter \"--time-zone-mapping-file\" is correct.\n                "), null, (int)1, null));
        return isNotValid;
    }

    /*
     * WARNING - void declaration
     */
    private final boolean isNotValidPoolNames(List<LibMemSymData> libMemSymData) {
        void $this$filterNotTo$iv$iv;
        Regex regex = new Regex("[a-zA-Z0-9_-]+");
        Iterable $this$filterNot$iv = libMemSymData;
        boolean $i$f$filterNot = false;
        Iterable iterable = $this$filterNot$iv;
        Collection destination$iv$iv = new ArrayList();
        boolean $i$f$filterNotTo = false;
        for (Object element$iv$iv : $this$filterNotTo$iv$iv) {
            boolean bl;
            LibMemSymData it = (LibMemSymData)element$iv$iv;
            boolean bl2 = false;
            if (it.getPoolName().length() > 40) {
                this.factory.getPrinter().print("Error: The pool name '" + it.getPoolName() + "' (for LIBMEMSYM '" + it.getRemoteFilePath() + "') is invalid because it exceeds 40 characters limit.");
                bl = false;
            } else if (!regex.matches((CharSequence)it.getPoolName())) {
                this.factory.getPrinter().print(StringsKt.trimMargin$default((String)("Error: The pool name '" + it.getPoolName() + "' (for LIBMEMSYM '" + it.getRemoteFilePath() + "') is invalid because it contains special characters. The only valid characters are \"A to Z\" (a to z), \"0 to 9\", \"-\" and \"_\".\n                "), null, (int)1, null));
                bl = false;
            } else {
                bl = true;
            }
            if (bl) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        List notValidLibMemSym = (List)destination$iv$iv;
        return !((Collection)notValidLibMemSym).isEmpty();
    }

    private final boolean isNotExistsLibMemSymControlFile(Path libMemSymMappingPath, String libmemsymControlMFilePath) {
        LinkOption[] linkOptionArray = new LinkOption[]{};
        if (Files.notExists(libMemSymMappingPath, Arrays.copyOf(linkOptionArray, linkOptionArray.length))) {
            this.factory.getPrinter().print(StringsKt.trimMargin$default((String)("LIBMEMSYM Control file path '" + libmemsymControlMFilePath + "' could not be found.\n                    |Please make sure that the path provided in the parameter \"--libmemsym-control-file\" is correct.\n                "), null, (int)1, null));
            return true;
        }
        return false;
    }

    /*
     * Unable to fully structure code
     */
    private final boolean isValidLibMemSymLocalPaths(FileSystem fileSystem, List<LibMemSymData> libMemSymData) {
        $this$filter$iv = libMemSymData;
        $i$f$filter = false;
        var6_5 = $this$filter$iv;
        destination$iv$iv = new ArrayList<E>();
        $i$f$filterTo = false;
        for (T element$iv$iv : $this$filterTo$iv$iv) {
            entry = (LibMemSymData)element$iv$iv;
            $i$a$-filter-ArgumentsValidation$isValidLibMemSymLocalPaths$localPathNotExists$1 = false;
            Intrinsics.checkNotNullExpressionValue((Object)this.toPath(entry.getLocalFilePath(), fileSystem), (String)"toPath(...)");
            var14_15 = new LinkOption[]{};
            notExist = var13_12 = Files.notExists(var13_13, Arrays.copyOf(var14_15, var14_15.length));
            $i$a$-also-ArgumentsValidation$isValidLibMemSymLocalPaths$localPathNotExists$1$1 = false;
            if (notExist) {
                this.factory.getPrinter().print("Error: The path of the LIBMEMSYM local copy '" + entry.getLocalFilePath() + "' could not be found.");
            }
            if (var13_12) ** GOTO lbl-1000
            v0 = this.factory.getFileSystemPermissionsHandler();
            v1 = this.toPath(entry.getLocalFilePath(), fileSystem);
            Intrinsics.checkNotNullExpressionValue((Object)v1, (String)"toPath(...)");
            doesNotHaveReadPermissions = var13_12 = v0.cannotRead(v1);
            $i$a$-also-ArgumentsValidation$isValidLibMemSymLocalPaths$localPathNotExists$1$2 = false;
            if (doesNotHaveReadPermissions) {
                this.factory.getPrinter().print("Error: The path of the LIBMEMSYM local copy '" + entry.getLocalFilePath() + "' has no read permission.");
            }
            if (var13_12) lbl-1000:
            // 2 sources

            {
                v2 = true;
            } else {
                v2 = false;
            }
            if (!v2) continue;
            destination$iv$iv.add(element$iv$iv);
        }
        localPathNotExists = (List)destination$iv$iv;
        return localPathNotExists.isEmpty();
    }

    private final boolean doesContainInvalidLines(Path libMemSymMappingPath) {
        List<IndexedLine> invalidLibMemSymControlFileLines = LibMemSymConfFileReader.Companion.invalidLibMemSymControlFileLines(libMemSymMappingPath);
        if (!((Collection)invalidLibMemSymControlFileLines).isEmpty()) {
            String invalidLinesMsg = CollectionsKt.joinToString$default((Iterable)invalidLibMemSymControlFileLines, (CharSequence)"\r\n", null, null, (int)0, null, arg_0 -> ArgumentsValidation.doesContainInvalidLines$lambda$10(libMemSymMappingPath, arg_0), (int)30, null);
            this.factory.getPrinter().print(StringsKt.trimMargin$default((String)(invalidLinesMsg + "\n                            |Please see the documentation for \"Creating a LIBMEMSYM Control File\"."), null, (int)1, null));
            this.factory.getLogger().info("Invalid LIBMEMSYM Control file lines: " + invalidLibMemSymControlFileLines);
            return true;
        }
        return false;
    }

    private final ArgumentsValidationResult qualificationValidation(Database db, Arguments arguments) {
        Triple<AAPIClient, String, String> triple = this.validateOnPremApiClient(arguments);
        AAPIClient onPremiseApiClient = (AAPIClient)triple.component1();
        String token = (String)triple.component2();
        String version = (String)triple.component3();
        if (onPremiseApiClient == null || token == null || version == null) {
            return InValidArguments.INSTANCE;
        }
        IdlClient idlClient = new IdlClient(token, arguments, this.factory.getLogger());
        return ValidatedArguments.Companion.buildValidQualificationArguments(db, onPremiseApiClient, idlClient, version);
    }

    private final ArgumentsValidationResult deployValidation(Arguments arguments) {
        Object object = new Action[]{Action.Migrate, Action.M, Action.DeployOnly, Action.D, Action.D1, Action.DeployPhase1, Action.DeployPhase2, Action.D2};
        CollectionsKt.listOf((Object[])object).contains((Object)arguments.getAction());
        object = arguments.getSaasAapiEndpoint();
        if (object == null || object.length() == 0 || (object = (CharSequence)arguments.getSaasAapiToken()) == null || object.length() == 0) {
            this.factory.getPrinter().print("Deploy requires valid Control-M SaaS endpoint and Control-M SaaS API Token. Provide a value for this parameters and try again.");
            return InValidArguments.INSTANCE;
        }
        String string = arguments.getSaasAapiEndpoint();
        Intrinsics.checkNotNull((Object)string);
        Pair<AAPIClient, Boolean> helixApiClient = this.validateHelixConnection(string, arguments.getSaasAapiToken(), arguments.getSaasAapiProxy());
        if (!((Boolean)helixApiClient.getSecond()).booleanValue()) {
            return InValidArguments.INSTANCE;
        }
        return ValidatedArguments.Companion.buildValidDeployArguments((AAPIClient)helixApiClient.getFirst());
    }

    private final ArgumentsValidationResult migrationValidation(Database db, Arguments arguments) {
        Triple<AAPIClient, String, String> triple = this.validateOnPremApiClient(arguments);
        AAPIClient onPremiseApiClient = (AAPIClient)triple.component1();
        String token = (String)triple.component2();
        String version = (String)triple.component3();
        return onPremiseApiClient != null && token != null && version != null ? (ArgumentsValidationResult)ValidatedArguments.Companion.buildValidMigrationArguments(db, onPremiseApiClient, new IdlClient(token, arguments, this.factory.getLogger()), this.validateHelixEndpointForMigrationMode(arguments), version) : (ArgumentsValidationResult)InValidArguments.INSTANCE;
    }

    private final AAPIClient validateHelixEndpointForMigrationMode(Arguments arguments) {
        CharSequence charSequence = arguments.getSaasAapiEndpoint();
        if (charSequence == null || charSequence.length() == 0 || (charSequence = (CharSequence)arguments.getSaasAapiToken()) == null || charSequence.length() == 0) {
            return null;
        }
        String string = arguments.getSaasAapiEndpoint();
        Intrinsics.checkNotNull((Object)string);
        return (AAPIClient)this.validateHelixConnection(string, arguments.getSaasAapiToken(), arguments.getSaasAapiProxy()).getFirst();
    }

    private final String validateOutputFolder(String path, FileSystem fileSystem) {
        String string;
        try {
            Path outputFolder = fileSystem.getPath(path, new String[0]);
            Intrinsics.checkNotNull((Object)outputFolder);
            FileAttribute[] fileAttributeArray = new FileAttribute[]{};
            Intrinsics.checkNotNullExpressionValue((Object)Files.createDirectories(outputFolder, Arrays.copyOf(fileAttributeArray, fileAttributeArray.length)), (String)"createDirectories(...)");
            string = path;
        }
        catch (Exception e) {
            this.factory.getPrinter().print("The output directory is not valid " + path);
            string = null;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    private final Database validateDatabaseArguments(Arguments arguments) {
        Database database;
        try {
            Database dbConnection = DatabaseConnectionKt.buildConnection((EmDatabaseParameters)arguments.getEmDatabaseParameters()).connect();
            Either this_$iv = this.factory.emDatabase(dbConnection).getUserReports();
            boolean $i$f$map = false;
            Either $this$flatMap$iv$iv = this_$iv;
            boolean $i$f$flatMap = false;
            Either either = $this$flatMap$iv$iv;
            if (either instanceof Either.Right) {
                void $this$mapTo$iv$iv;
                Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
                boolean bl = false;
                List reports = (List)it$iv;
                boolean bl2 = false;
                Iterable $this$map$iv = reports;
                boolean $i$f$map2 = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    UserReport userReport = (UserReport)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl3 = false;
                    collection.add(it.getName());
                }
                List list = CollectionsKt.toList((Iterable)((List)destination$iv$iv));
                Either cfr_ignored_0 = (Either)new Either.Right((Object)list);
            } else if (!(either instanceof Either.Left)) {
                throw new NoWhenBranchMatchedException();
            }
        }
        catch (Exception e) {
            this.printMessageInvalidDatabaseParameters(arguments, e);
            database = null;
        }
        return database;
    }

    private final void printMessageInvalidDatabaseParameters(Arguments arguments, Exception e) {
        this.factory.getLogger().warning("Exception when testing Database connection", e);
        this.factory.getPrinter().print(StringsKt.trimMargin$default((String)("Please check the database parameters: " + arguments.getEmDatabaseParameters() + "\n            |The Migration Tool can't extract the data from the database.\n            |"), null, (int)1, null));
    }

    private final Triple<AAPIClient, String, String> validateOnPremApiClient(Arguments arguments) {
        Either<ApiFailure, LoginResult> loginResult;
        AAPIClient apiClientOnPrem;
        block7: {
            Object object;
            Printer printer;
            block9: {
                block8: {
                    String string;
                    this.disableAAPIPrinterForModes(this.factory.getOnPremAapiClientBuilder(), arguments.getAction().isPrintErrorsToConsoleEnabled());
                    apiClientOnPrem = AAPIClientBuilder.forServer$default((AAPIClientBuilder)this.factory.getOnPremAapiClientBuilder(), (String)arguments.getControl-m-automation-api-endpoint(), null, null, (int)6, null);
                    loginResult = this.loginToOnPremAPI(apiClientOnPrem, arguments);
                    if (loginResult != null && !loginResult.isLeft()) break block7;
                    printer = this.factory.getPrinter();
                    object = loginResult;
                    if (object == null) break block8;
                    Either<ApiFailure, LoginResult> this_$iv = object;
                    boolean $i$f$fold = false;
                    Either<ApiFailure, LoginResult> either = this_$iv;
                    if (either instanceof Either.Right) {
                        LoginResult loginResult2 = (LoginResult)((Either.Right)this_$iv).getValue();
                        Printer printer2 = printer;
                        boolean bl = false;
                        string = null;
                        printer = printer2;
                    } else if (either instanceof Either.Left) {
                        ApiFailure it = (ApiFailure)((Either.Left)this_$iv).getValue();
                        Printer printer3 = printer;
                        boolean bl = false;
                        string = it.getMessage();
                        printer = printer3;
                    } else {
                        throw new NoWhenBranchMatchedException();
                    }
                    object = string;
                    if (string != null) break block9;
                }
                object = "Error occurred when trying to login to Control-M Enterprise Manager";
            }
            printer.print(object);
            return new Triple(null, null, null);
        }
        LoginResult loginResult3 = (LoginResult)loginResult.orNull();
        String aapiVersion = loginResult3 != null ? loginResult3.getVersion() : null;
        LoginResult loginResult4 = (LoginResult)loginResult.orNull();
        String token = loginResult4 != null ? loginResult4.getToken() : null;
        AAPIClient aapiClient = AAPIClientBuilder.forAAPIVersion$default((AAPIClientBuilder)this.factory.getOnPremAapiClientBuilder(), (String)arguments.getControl-m-automation-api-endpoint(), (String)aapiVersion, (ApiClient)apiClientOnPrem.getApiClient(), null, (int)8, null);
        return new Triple((Object)this.validateOnPremServer(arguments.getControl-m-server-name(), aapiClient), (Object)token, (Object)this.initVersion(loginResult));
    }

    private final void disableAAPIPrinterForModes(AAPIClientBuilder $this$disableAAPIPrinterForModes, boolean isPrintErrorsToConsoleEnabled) {
        if (!isPrintErrorsToConsoleEnabled) {
            $this$disableAAPIPrinterForModes.disablePrintingToConsole();
        }
    }

    private final AAPIClient validateOnPremServer(String serverName, AAPIClient apiClientOnPrem) {
        AAPIClient aAPIClient;
        String error;
        CtmDetails server;
        Object object = apiClientOnPrem;
        if (object != null && (object = object.getServers()) != null && (object = AAPIClientKt.orDefault((Either)object)) != null) {
            Object v1;
            block5: {
                Iterable $this$firstOrNull$iv = (Iterable)object;
                boolean $i$f$firstOrNull = false;
                for (Object element$iv : $this$firstOrNull$iv) {
                    CtmDetails it = (CtmDetails)element$iv;
                    boolean bl = false;
                    if (!Intrinsics.areEqual((Object)it.getName(), (Object)serverName)) continue;
                    v1 = element$iv;
                    break block5;
                }
                v1 = null;
            }
            v2 = v1;
        } else {
            v2 = server = null;
        }
        String string = error = server == null ? "The Control-M Server '" + serverName + "' does not exist." : (Intrinsics.areEqual((Object)server.getOsType(), (Object)"z/OS") ? "Server '" + serverName + "' is z/OS, this tool is built for migrating distributed servers only." : "");
        if (((CharSequence)error).length() > 0) {
            this.factory.getPrinter().print(StringsKt.trimMargin$default((String)(error + "\n                |Please make sure to specify a correct distributed server name.\n                "), null, (int)1, null));
            aAPIClient = null;
        } else {
            aAPIClient = apiClientOnPrem;
        }
        return aAPIClient;
    }

    private final String updateHelixUrlToBeValid(String endPoint) {
        String beforeDotStr;
        Object updatedEndPoint = endPoint;
        if (!StringsKt.endsWith$default((String)endPoint, (String)this.automationApiString, (boolean)false, (int)2, null)) {
            updatedEndPoint = endPoint + this.automationApiString;
        }
        if (!StringsKt.endsWith$default((String)(beforeDotStr = StringsKt.substringBefore$default((String)endPoint, (String)".", null, (int)2, null)), (String)this.aapiString, (boolean)false, (int)2, null)) {
            String beforeDotStrUpdated = beforeDotStr + this.aapiString;
            updatedEndPoint = StringsKt.replace$default((String)updatedEndPoint, (String)beforeDotStr, (String)beforeDotStrUpdated, (boolean)false, (int)4, null);
        }
        return updatedEndPoint;
    }

    private final Pair<AAPIClient, Boolean> validateHelixConnection(String helixEndpoint, String helixToken, HttpProxy httpProxy) {
        AAPIClient apiSaasClient = ArgumentsValidationKt.access$withProxy(AAPIClientBuilder.forServer$default((AAPIClientBuilder)this.factory.getHelixAapiClientBuilder(), (String)helixEndpoint, (String)helixToken, null, (int)4, null), httpProxy, this.factory.getLogger());
        Either serversSaas = apiSaasClient.getServers();
        if (serversSaas.isLeft()) {
            this.factory.getPrinter().print(StringsKt.trimMargin$default((String)("Error connecting to Control-M SaaS Automation API endpoint " + helixEndpoint + ".\n                            |Please make sure Control-M SaaS Automation API endpoint and Control-M SaaS API token are valid.\n                            |"), null, (int)1, null));
            return TuplesKt.to((Object)apiSaasClient, (Object)false);
        }
        this.factory.getLogger().info("SAAS Servers: " + AAPIClientKt.orDefault((Either)serversSaas));
        return TuplesKt.to((Object)apiSaasClient, (Object)true);
    }

    private final Either<ApiFailure, LoginResult> loginToOnPremAPI(AAPIClient aapiClient, Arguments arguments) {
        AAPIClient aAPIClient = aapiClient;
        return aAPIClient != null ? aAPIClient.login(arguments.getControl-m-enterprise-manager-username(), arguments.getControl-m-enterprise-manager-password()) : null;
    }

    private final String initVersion(Either<? extends ApiFailure, ? extends LoginResult> loginResult) {
        Either either;
        Either this_$iv = loginResult;
        boolean $i$f$map = false;
        Either $this$flatMap$iv$iv = this_$iv;
        boolean $i$f$flatMap = false;
        Either either2 = $this$flatMap$iv$iv;
        if (either2 instanceof Either.Right) {
            Object it$iv = ((Either.Right)$this$flatMap$iv$iv).getValue();
            boolean bl = false;
            LoginResult it = (LoginResult)it$iv;
            boolean bl2 = false;
            if (new Version(it.getVersion()).compareTo(DataExtractorKt.getMinimumSupportedAAPIVersion()) < 0) {
                this.factory.getPrinter().print("Automation API version used is " + it.getVersion() + "\nTo ensure the best results, please ensure you are using the latest Automation API version on this environment");
            }
            String string = it.getVersion();
            either = (Either)new Either.Right((Object)string);
        } else if (either2 instanceof Either.Left) {
            either = $this$flatMap$iv$iv;
        } else {
            throw new NoWhenBranchMatchedException();
        }
        return (String)either.orNull();
    }

    private static final ArgumentsValidationResult validateArguments$lambda$1(ArgumentsValidation this$0, Arguments $arguments) {
        return this$0.deployValidation($arguments);
    }

    private static final ArgumentsValidationResult validateArguments$lambda$2(ArgumentsValidation this$0, Arguments $arguments, FileSystem $fileSystem, Database $db) {
        return !this$0.isValidLibMemSym($arguments.getLibmemsymControlMFilePath(), $fileSystem) || this$0.isNotValidTimeZoneMapping($arguments.getTimeZoneMappingPath(), $fileSystem) ? (ArgumentsValidationResult)InValidArguments.INSTANCE : this$0.migrationValidation($db, $arguments);
    }

    private static final ArgumentsValidationResult validateArguments$lambda$3(ArgumentsValidation this$0, Arguments $arguments, FileSystem $fileSystem, Database $db) {
        return !this$0.isValidLibMemSym($arguments.getLibmemsymControlMFilePath(), $fileSystem) ? (ArgumentsValidationResult)InValidArguments.INSTANCE : this$0.qualificationValidation($db, $arguments);
    }

    private static final ArgumentsValidationResult validateArguments$lambda$4(ArgumentsValidation this$0, Database $db, Arguments $arguments) {
        return this$0.qualificationValidation($db, $arguments);
    }

    private static final ArgumentsValidationResult validateArguments$lambda$5(ArgumentsValidation this$0, Database $db, Arguments $arguments) {
        return this$0.qualificationValidation($db, $arguments);
    }

    private static final CharSequence doesContainInvalidLines$lambda$10(Path $libMemSymMappingPath, IndexedLine it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return "LIBMEMSYM control file '" + ((Object)$libMemSymMappingPath.toAbsolutePath()).toString() + "' contains invalid syntax at line " + (it.getZeroBasedIndex() + 1) + ".";
    }
}

