/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.databaseCommon;

import com.bmc.ctmconvert.databaseCommon.DatabaseConnection;
import com.bmc.ctmconvert.databaseCommon.DatabaseType;
import com.bmc.ctmconvert.databaseCommon.EmDatabaseParameters;
import javax.sql.DataSource;
import kotlin.Metadata;
import kotlin.NoWhenBranchMatchedException;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 0, 0}, k=2, xi=48, d1={"\u0000\u0018\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u001a>\u0010\u0000\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u0004\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\b\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a\u000e\u0010\n\u001a\u00020\u00012\u0006\u0010\u000b\u001a\u00020\f\u001a\u0006\u0010\r\u001a\u00020\u0001\u001a6\u0010\u000e\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u001a6\u0010\u0010\u001a\u00020\u00012\u0006\u0010\u0002\u001a\u00020\u00032\u0006\u0010\u000f\u001a\u00020\u00032\u0006\u0010\u0005\u001a\u00020\u00032\u0006\u0010\u0006\u001a\u00020\u00032\u0006\u0010\u0007\u001a\u00020\u00032\u0006\u0010\t\u001a\u00020\u0003\u00a8\u0006\u0011"}, d2={"buildOracleConnection", "Lcom/bmc/ctmconvert/databaseCommon/DatabaseConnection;", "hostName", "", "serviceName", "user", "password", "port", "protocol", "connectionString", "buildConnection", "emDatabaseParameters", "Lcom/bmc/ctmconvert/databaseCommon/EmDatabaseParameters;", "buildH2Connection", "buildMssqlConnection", "databaseName", "buildPostgresConnection", "Common"})
@SourceDebugExtension(value={"SMAP\nDatabaseConnection.kt\nKotlin\n*S Kotlin\n*F\n+ 1 DatabaseConnection.kt\ncom/bmc/ctmconvert/databaseCommon/DatabaseConnectionKt\n+ 2 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,137:1\n1#2:138\n*E\n"})
public final class DatabaseConnectionKt {
    @NotNull
    public static final DatabaseConnection buildOracleConnection(@NotNull String hostName, @NotNull String serviceName, @NotNull String user, @NotNull String password, @NotNull String port, @NotNull String protocol, @NotNull String connectionString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)serviceName, (String)"serviceName");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)protocol, (String)"protocol");
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        CharSequence charSequence = connectionString;
        if (charSequence.length() == 0) {
            boolean bl = false;
            Object protocolString = ((CharSequence)protocol).length() > 0 ? protocol + ":" : "";
            object = "jdbc:oracle:thin:@" + (String)protocolString + "//" + hostName + ":" + port + "/" + serviceName;
        } else {
            object = charSequence;
        }
        String fullConnectionString = (String)object;
        return new DatabaseConnection(fullConnectionString, user, password, "oracle.jdbc.OracleDriver", null, 16, null);
    }

    @NotNull
    public static final DatabaseConnection buildConnection(@NotNull EmDatabaseParameters emDatabaseParameters) {
        Intrinsics.checkNotNullParameter((Object)emDatabaseParameters, (String)"emDatabaseParameters");
        return switch (WhenMappings.$EnumSwitchMapping$0[emDatabaseParameters.getType().ordinal()]) {
            case 1 -> DatabaseConnectionKt.buildMssqlConnection(emDatabaseParameters.getHostname(), emDatabaseParameters.getDatabase(), emDatabaseParameters.getUsername(), emDatabaseParameters.getPassword(), emDatabaseParameters.getPort(), emDatabaseParameters.getConnectionString());
            case 2 -> DatabaseConnectionKt.buildPostgresConnection(emDatabaseParameters.getHostname(), emDatabaseParameters.getDatabase(), emDatabaseParameters.getUsername(), emDatabaseParameters.getPassword(), emDatabaseParameters.getPort(), emDatabaseParameters.getConnectionString());
            case 3 -> DatabaseConnectionKt.buildOracleConnection(emDatabaseParameters.getHostname(), emDatabaseParameters.getDatabase(), emDatabaseParameters.getUsername(), emDatabaseParameters.getPassword(), emDatabaseParameters.getPort(), emDatabaseParameters.getProtocol(), emDatabaseParameters.getConnectionString());
            case 4 -> DatabaseConnectionKt.buildH2Connection();
            default -> throw new NoWhenBranchMatchedException();
        };
    }

    @NotNull
    public static final DatabaseConnection buildH2Connection() {
        return new DatabaseConnection("jdbc:h2:mem:test;DB_CLOSE_DELAY=-1;", "", "", "org.h2.Driver", null, 16, null);
    }

    @NotNull
    public static final DatabaseConnection buildMssqlConnection(@NotNull String hostName, @NotNull String databaseName, @NotNull String user, @NotNull String password, @NotNull String port, @NotNull String connectionString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        CharSequence charSequence = connectionString;
        if (charSequence.length() == 0) {
            boolean bl = false;
            object = "jdbc:sqlserver://" + hostName + ":" + port + ";databaseName=" + databaseName;
        } else {
            object = charSequence;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 16;
        DataSource dataSource = null;
        String string = "com.microsoft.sqlserver.jdbc.SQLServerDriver";
        String string2 = password;
        String string3 = user;
        String string4 = (String)object;
        return new DatabaseConnection(string4, string3, string2, string, dataSource, n, defaultConstructorMarker);
    }

    @NotNull
    public static final DatabaseConnection buildPostgresConnection(@NotNull String hostName, @NotNull String databaseName, @NotNull String user, @NotNull String password, @NotNull String port, @NotNull String connectionString) {
        Object object;
        Intrinsics.checkNotNullParameter((Object)hostName, (String)"hostName");
        Intrinsics.checkNotNullParameter((Object)databaseName, (String)"databaseName");
        Intrinsics.checkNotNullParameter((Object)user, (String)"user");
        Intrinsics.checkNotNullParameter((Object)password, (String)"password");
        Intrinsics.checkNotNullParameter((Object)port, (String)"port");
        Intrinsics.checkNotNullParameter((Object)connectionString, (String)"connectionString");
        CharSequence charSequence = connectionString;
        if (charSequence.length() == 0) {
            boolean bl = false;
            object = "jdbc:postgresql://" + hostName + ":" + port + "/" + databaseName;
        } else {
            object = charSequence;
        }
        DefaultConstructorMarker defaultConstructorMarker = null;
        int n = 16;
        DataSource dataSource = null;
        String string = "org.postgresql.Driver";
        String string2 = password;
        String string3 = user;
        String string4 = (String)object;
        return new DatabaseConnection(string4, string3, string2, string, dataSource, n, defaultConstructorMarker);
    }

    @Metadata(mv={2, 0, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[DatabaseType.values().length];
            try {
                nArray[DatabaseType.MSSQL.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.PostgreSQL.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.Oracle.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[DatabaseType.H2.ordinal()] = 4;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

