/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.reader;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.flowupdater.reader.XmlHandler;
import java.util.List;
import java.util.Optional;

public class XmlDraftWalker {
    private XmlHandler handler;

    public XmlDraftWalker(XmlHandler handler) {
        this.handler = handler;
    }

    public void walk(XmlElement draftroot) {
        List topLevelFolders = draftroot.getDirectchildsElementbyName(new String[]{"SMART_FOLDER", "FOLDER", "SMART_TABLE", "TABLE"});
        for (XmlElement folder : topLevelFolders) {
            this.walkFolder(folder, Optional.empty());
        }
    }

    private void walkFolder(XmlElement folder, Optional<XmlElement> parentfolder) {
        if (!parentfolder.isPresent()) {
            this.handler.handleTopLevelFolder(folder);
        } else {
            this.handler.handleSubFolder(folder, parentfolder.get());
        }
        List childs = folder.getAllDirectchildsElement();
        for (XmlElement child : childs) {
            if (child.getTagName().equals("SUB_FOLDER") || child.getTagName().equals("SUB_TABLE")) {
                this.walkFolder(child, Optional.of(folder));
                continue;
            }
            if (!child.getTagName().equals("JOB")) continue;
            this.handler.handleJob(child, folder);
        }
    }
}

