/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.reader;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.dataObject.entities.InMemoryDataObject;
import com.bmc.ctmconvert.flowupdater.reader.EntitiesHandler;
import com.bmc.ctmconvert.interfaces.ConversionReader;
import java.io.IOException;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import org.xml.sax.SAXException;

public class FlowUpdaterDataReader
implements ConversionReader {
    private DataObject dataObject;
    private InputStream dataDirStream;

    public FlowUpdaterDataReader(InputStream dataDirStream) {
        this.dataDirStream = dataDirStream;
        this.dataObject = new InMemoryDataObject();
    }

    public DataObject getDataObject() {
        return this.dataObject;
    }

    public DataObject read() {
        this.loadCtmXmlToDo();
        return this.getDataObject();
    }

    private void loadCtmXmlToDo() {
        EntitiesHandler handler = new EntitiesHandler(this.dataObject);
        XmlElement draftroot = this.getDraftRoot();
        String headerTagName = draftroot.getTagName();
        Map headerAttributes = draftroot.getAttributes();
        handler.storeHeader(headerTagName, headerAttributes);
        List topLevelFolders = draftroot.getDirectchildsElementbyName(new String[]{"SMART_FOLDER", "FOLDER"});
        if (topLevelFolders.isEmpty()) {
            topLevelFolders = draftroot.getDirectchildsElementbyName("SMART_TABLE");
        }
        for (XmlElement folder : topLevelFolders) {
            handler.storeFolder(folder, null);
        }
    }

    private XmlElement getDraftRoot() {
        XmlElement draftroot = null;
        XmlLoader loader = new XmlLoader();
        try {
            loader.loadFile(this.dataDirStream);
        }
        catch (IOException | SAXException e) {
            NotValidFileException exception = new NotValidFileException(e);
            throw exception;
        }
        draftroot = loader.getXmlElement();
        return draftroot;
    }

    public class NotValidFileException
    extends RuntimeException {
        private static final long serialVersionUID = -6585573854678570033L;

        public NotValidFileException(Exception e) {
            super("Could not parse File - please verify the file is Control-M exported data" + e.getMessage());
        }
    }
}

