/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.inject;

import com.bmc.ctmconvert.dataObject.Data;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.IAttribute;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterJobMeetCriteria;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

public class JobMeetsAttributeCriteria
implements FlowUpdaterJobMeetCriteria {
    public String criteriaField;
    public String criteriaValue;
    private attributeContainsPredicate predicate;
    private Map<String, String> mapGuiFieldToXmlAttribute = new HashMap<String, String>();

    public String toString() {
        return "FlowUpdaterJobMeetCriteria [criteriaField=" + this.criteriaField + ", criteriaValue=" + this.criteriaValue + "]";
    }

    public JobMeetsAttributeCriteria(String criteriaField, String criteriaValue) {
        this.criteriaField = criteriaField;
        this.criteriaValue = criteriaValue;
        this.fillMapFieldToAttribute();
    }

    private void fillMapFieldToAttribute() {
        this.mapGuiFieldToXmlAttribute.put("Description", "DESCRIPTION");
        this.mapGuiFieldToXmlAttribute.put("Application", "APPLICATION");
        this.mapGuiFieldToXmlAttribute.put("Sub Application", "GROUP");
        this.mapGuiFieldToXmlAttribute.put("Run As", "OWNER");
        this.mapGuiFieldToXmlAttribute.put("Host/Host Group", "NODEID");
        this.mapGuiFieldToXmlAttribute.put("Parent Folder", "PARENT_FOLDER");
        this.mapGuiFieldToXmlAttribute.put("Job Name", "JOBNAME");
        this.mapGuiFieldToXmlAttribute.put("Created By", "AUTHOR");
    }

    @Override
    public boolean isJobMeetCriteria(DataEntity data) {
        if (!data.getDataType().equals("JOB")) {
            return false;
        }
        switch (this.criteriaField) {
            case "Command": {
                return this.isCommandJob((Data)data);
            }
            case "File Name": {
                return this.isScriptJob((Data)data);
            }
            case "Embedded Script": {
                return this.isEmbeddedScriptJob((Data)data);
            }
            case "File Path": {
                return this.isScriptJob((Data)data);
            }
        }
        String AttributeName = this.mapGuiFieldToXmlAttribute.get(this.criteriaField);
        return this.containAtrribute((Data)data, AttributeName);
    }

    private boolean isEmbeddedScriptJob(Data data) {
        if (data.getAttributes().hasAttribute("USE_INSTREAM_JCL", "Y")) {
            return this.containAtrribute(data, "INSTREAM_JCL");
        }
        return false;
    }

    private boolean isScriptJob(Data data) {
        if (this.isTaskType(data, "Job")) {
            return this.containAtrribute(data, "MEMNAME");
        }
        return false;
    }

    private boolean isCommandJob(Data data) {
        if (this.isTaskType(data, "Command")) {
            String cmdline = "CMDLINE";
            boolean containAtrribute = this.containAtrribute(data, cmdline);
            return containAtrribute;
        }
        return false;
    }

    private boolean containAtrribute(Data data, String field) {
        this.predicate = new attributeContainsPredicate(field);
        return data.getAttributes().hasAttribute((Predicate)this.predicate);
    }

    @Override
    public String getReplaceCriteria() {
        return this.criteriaField;
    }

    @Override
    public String getSearchCriteria() {
        return this.criteriaValue;
    }

    private boolean isTaskType(Data data, String taskType) {
        return data.getAttributes().hasAttribute("TASKTYPE", taskType);
    }

    private final class attributeContainsPredicate
    implements Predicate<IAttribute> {
        private String field;

        public attributeContainsPredicate(String field) {
            this.field = field;
        }

        @Override
        public boolean test(IAttribute attribute) {
            boolean isFieldEquals = attribute.getName().equals(this.field);
            boolean isAttributeContains = attribute.getValue().contains(JobMeetsAttributeCriteria.this.criteriaValue);
            return isFieldEquals && isAttributeContains;
        }
    }
}

