/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.inject;

import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class FlowUpdaterMakeCondNameUnique {
    private List<String> condElementsList = new ArrayList<String>();
    private Random randomGenerator = new Random();
    private String uniqueId;
    private Integer injectNumber;
    private String randomUniqueSufix;

    public FlowUpdaterMakeCondNameUnique() {
        this.setElements();
        this.setRandomUniqueSufix();
        this.injectNumber = 0;
    }

    public void act(List<BaseXmlEntity> wsInjectedList) {
        this.incrementInjectNumber();
        for (BaseXmlEntity wsInjectedJob : wsInjectedList) {
            for (String elementTag : this.condElementsList) {
                List jobElements = wsInjectedJob.getSubElements(elementTag);
                for (XmlElement condElement : jobElements) {
                    String origName = condElement.getAttribute("NAME");
                    String uniqueName = origName + this.getUniqueId();
                    wsInjectedJob.changeSubElementName(elementTag, origName, uniqueName);
                }
            }
            List onElements = wsInjectedJob.getSubElements("ON");
            for (XmlElement onElement : onElements) {
                DocumentBuilder builder;
                List doElements = onElement.getAllDirectchildsElement();
                if (doElements.stream().filter(ele -> ele.getTagName().equals("DOCOND")).count() <= 0L) continue;
                DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
                try {
                    builder = dbf.newDocumentBuilder();
                }
                catch (ParserConfigurationException e) {
                    throw new RuntimeException(e);
                }
                Document doc = builder.newDocument();
                Element modifiedOnElement = doc.createElement("ON");
                Set attrSet = onElement.getAttributes().entrySet();
                for (Map.Entry attr : attrSet) {
                    String attrValue = (String)attr.getValue();
                    String attrName = (String)attr.getKey();
                    modifiedOnElement.setAttribute(attrName, attrValue);
                }
                for (XmlElement doElement : doElements) {
                    String doTagName = doElement.getTagName();
                    Element modifiedDoElement = doc.createElement(doTagName);
                    attrSet = doElement.getAttributes().entrySet();
                    for (Map.Entry attr : attrSet) {
                        Object attrValue = (String)attr.getValue();
                        String attrName = (String)attr.getKey();
                        if (doTagName.equals("DOCOND") && attrName.equals("NAME")) {
                            attrValue = (String)attrValue + this.getUniqueId();
                        }
                        modifiedDoElement.setAttribute(attrName, (String)attrValue);
                    }
                    modifiedOnElement.appendChild(modifiedDoElement);
                }
                wsInjectedJob.removeElement(onElement);
                wsInjectedJob.addElement(new XmlElement(modifiedOnElement));
            }
        }
    }

    private void incrementInjectNumber() {
        Integer n = this.injectNumber;
        this.injectNumber = this.injectNumber + 1;
    }

    private void setRandomUniqueSufix() {
        String allChars = "0123456789ABCDEFGHIJKLMNOPQRSTUZWXYZ";
        Object suffix = "";
        for (int i = 0; i < 5; ++i) {
            int randomInt = this.randomGenerator.nextInt(allChars.length());
            suffix = (String)suffix + allChars.substring(randomInt, randomInt + 1);
        }
        this.randomUniqueSufix = suffix;
    }

    private String getUniqueId() {
        String injectNumberString = String.format("%05d", this.injectNumber);
        this.uniqueId = "_" + this.randomUniqueSufix + injectNumberString;
        return this.uniqueId;
    }

    private void setElements() {
        this.condElementsList.add("INCOND");
        this.condElementsList.add("OUTCOND");
    }
}

