/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.inject;

import com.bmc.ctmconvert.flowupdater.inject.XmlAction;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import java.util.Optional;

public class FlowUpdaterCopyTaskTypeCriteria
implements XmlAction {
    @Override
    public void act(BaseXmlEntity replacedJob, BaseXmlEntity workSpaceEntity) {
        Optional<String> convertedJobData = this.getOriginalJobDataForDescription(replacedJob);
        Optional originalDescription = replacedJob.getAttribute("DESCRIPTION");
        if (convertedJobData.isPresent()) {
            String desciription = originalDescription.map(desc -> desc + "\n").orElse("") + convertedJobData.get();
            workSpaceEntity.addAttribute("DESCRIPTION", desciription);
        }
    }

    Optional<String> getOriginalJobDataForDescription(BaseXmlEntity replacedJob) {
        Optional<String> returnValue = Optional.empty();
        String commandLineListValues = (String)replacedJob.getAttributes().get("CMDLINE");
        String fileName = (String)replacedJob.getAttributes().get("MEMNAME");
        String embeddedScriptList = (String)replacedJob.getAttributes().get("INSTREAM_JCL");
        String scriptFilePathList = (String)replacedJob.getAttributes().get("MEMLIB");
        if (commandLineListValues != null && !commandLineListValues.isEmpty()) {
            String commandLineValue = commandLineListValues;
            returnValue = Optional.of(this.genrateDescriptionData(commandLineValue, "Command Line"));
        } else if (embeddedScriptList != null && !embeddedScriptList.isEmpty()) {
            String embeddeFileNameValue = embeddedScriptList;
            returnValue = Optional.of(this.genrateDescriptionData(embeddeFileNameValue, "Embedded Script"));
        } else if (scriptFilePathList != null && !scriptFilePathList.isEmpty()) {
            String scriptFileNameValue = fileName;
            String scriptFilepath = scriptFilePathList;
            returnValue = Optional.of(this.genrateDescriptionData(scriptFileNameValue + " " + scriptFilepath, "Script"));
        }
        return returnValue;
    }

    private String genrateDescriptionData(String dataValue, String originalJobDataType) {
        String header = "==Conversion Start";
        String tail = "==Conversion End";
        String originalJob = "Original job";
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append(header + "\n");
        stringBuilder.append(" ");
        stringBuilder.append(originalJob);
        stringBuilder.append(" " + originalJobDataType + " : \n");
        stringBuilder.append(dataValue);
        stringBuilder.append(" ");
        stringBuilder.append("\n" + tail);
        return stringBuilder.toString();
    }
}

