/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.dataimport;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.ImportEntry;
import com.bmc.ctmconvert.flowupdater.dataimport.FlowUpdaterItemImporter;
import com.bmc.ctmconvert.progress.Progressable;
import java.io.File;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;

public class FlowUpdaterDirectoryFileImporter
extends FlowUpdaterItemImporter {
    private ImportEntry entry;
    private String destinationFileName;
    protected File sourceDir;
    protected File targetDir;

    public FlowUpdaterDirectoryFileImporter(File file, File targetDir, ImportEntry entry) {
        this.sourceDir = file;
        this.targetDir = targetDir;
        this.entry = entry;
        this.destinationFileName = this.entry.getDestinationFileName();
    }

    @Override
    public void noProgressBarRun() {
        this.setStatus(Progressable.ProgressStatus.RUNNING);
        this.copyOneFile();
        if (this.getStatus() != Progressable.ProgressStatus.ENDED_FAILURE) {
            this.setStatus(Progressable.ProgressStatus.ENDED_SUCCESS);
        }
    }

    private void copyOneFile() {
        File newDestinationFile = new File(String.valueOf(this.targetDir) + "\\" + this.destinationFileName);
        try {
            File userFile = this.sourceDir;
            Files.copy(userFile.toPath(), newDestinationFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            ConversionLogger.getLogger().throwing(((Object)((Object)this)).getClass().getName(), "setFileName", e);
            this.setStatus(Progressable.ProgressStatus.ENDED_FAILURE);
        }
        ConversionLogger.getLogger().info(String.format("Copy file '%s' ended", this.sourceDir.getName()));
    }
}

