/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.convertor;

import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataEntityId;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.flowupdater.inject.CopyCommonAttributesFromJobToSubFolder;
import com.bmc.ctmconvert.flowupdater.inject.CopyCommonElementsFromJobToSubFolder;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterCopyCond;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterCopyTaskTypeCriteria;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterOnCopier;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterSubFolderInjector;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterVariableCopier;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterWarnQuantCritical;
import com.bmc.ctmconvert.flowupdater.inject.RuleManagerHolder;
import com.bmc.ctmconvert.flowupdater.inject.SubFolderCreator;
import com.bmc.ctmconvert.flowupdater.inject.XmlAction;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.workspace.IWorkspace;
import com.bmc.ctmconvert.workspace.IWorkspaceEntity;
import com.bmc.ctmconvert.workspace.Workspace;
import com.bmc.ctmconvert.workspace.WorkspaceId;
import com.bmc.ctmconvert.workspace.entities.BaseXmlEntity;
import com.bmc.ctmconvert.workspace.entities.FolderXmlEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class HandleMatchedJobsToSubfolder {
    public DataObject injectionDataObject;
    private Workspace workspace;
    private HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap;

    public HandleMatchedJobsToSubfolder(Workspace workspac, DataObject injectionDataObject, HashMap<DataEntityId, WorkspaceId> dataEntityToWorkspaceEntityMap2) {
        this.workspace = workspac;
        this.injectionDataObject = injectionDataObject;
        this.dataEntityToWorkspaceEntityMap = dataEntityToWorkspaceEntityMap2;
    }

    public void handle(List<DataEntity> matchedJobs) {
        Map<BaseXmlEntity, FolderXmlEntity> OriginalToSubFolderesMap = this.createSubFolderes(matchedJobs);
        FlowUpdaterSubFolderInjector flowInjector = new FlowUpdaterSubFolderInjector(OriginalToSubFolderesMap, this.workspace, this.injectionDataObject);
        List<XmlAction> actions = this.getSubFolderInjectionActions();
        flowInjector.act(actions);
    }

    private Map<BaseXmlEntity, FolderXmlEntity> createSubFolderes(List<DataEntity> matchedJobs) {
        SubFolderCreator subFolderCreator = this.getSubFolderCreator();
        for (DataEntity matchJob : matchedJobs) {
            WorkspaceId jobWsId = this.dataEntityToWorkspaceEntityMap.get(matchJob.getId());
            IWorkspaceEntity jobWsEntity = this.workspace.getEntityByID(jobWsId);
            FolderXmlEntity subFolder = subFolderCreator.generateSubFolder(jobWsEntity);
            this.dataEntityToWorkspaceEntityMap.put(matchJob.getId(), subFolder.getId());
            FlowUpdaterCopyCond flowUpdaterCopyCond = new FlowUpdaterCopyCond(matchJob, (BaseXmlEntity)subFolder);
            flowUpdaterCopyCond.copy();
        }
        Map<BaseXmlEntity, FolderXmlEntity> ret = subFolderCreator.getOriginalJobToSubFoldersMap();
        return ret;
    }

    public List<XmlAction> getSubFolderInjectionActions() {
        ArrayList<XmlAction> actions = new ArrayList<XmlAction>();
        FlowUpdaterVariableCopier flowUpdaterVariableCopier = new FlowUpdaterVariableCopier();
        FlowUpdaterWarnQuantCritical flowUpdaterWarnQuantCritical = new FlowUpdaterWarnQuantCritical();
        FlowUpdaterOnCopier flowUpdaterOnCopier = new FlowUpdaterOnCopier();
        CopyCommonElementsFromJobToSubFolder copyElements = new CopyCommonElementsFromJobToSubFolder();
        FlowUpdaterCopyTaskTypeCriteria flowUpdaterCopyTaskTypeCriteria = new FlowUpdaterCopyTaskTypeCriteria();
        CopyCommonAttributesFromJobToSubFolder copyCommonAttributes = new CopyCommonAttributesFromJobToSubFolder();
        actions.add(flowUpdaterVariableCopier);
        actions.add(flowUpdaterWarnQuantCritical);
        actions.add(flowUpdaterOnCopier);
        actions.add(copyElements);
        actions.add(copyCommonAttributes);
        RulesDataSet currentRules = RuleManagerHolder.get().getCurrentRules();
        Boolean isAppendToDescription = currentRules.getBooleanRule("Flow Updater Rules", new String[]{"AppendDataToDescription"});
        if (isAppendToDescription.booleanValue()) {
            actions.add(flowUpdaterCopyTaskTypeCriteria);
        }
        return actions;
    }

    private SubFolderCreator getSubFolderCreator() {
        return new SubFolderCreator((IWorkspace)this.workspace);
    }
}

