/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.break_flow;

import com.bmc.ctmconvert.flowupdater.break_flow.Dependencies;
import com.bmc.ctmconvert.workspace.OrderableEntity;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class GroupsFinder {
    private Dependencies dependencies;
    private Set<OrderableEntity> visited;
    private Groups groups;
    private List<OrderableEntity> jobs;

    public GroupsFinder(List<OrderableEntity> jobs, Dependencies dependencies) {
        this.jobs = jobs;
        this.dependencies = dependencies;
        this.visited = new HashSet<OrderableEntity>();
        this.groups = new Groups();
        this.createGroups();
    }

    private void createGroups() {
        List<OrderableEntity> heads = this.getHeads();
        for (OrderableEntity head : heads) {
            if (this.isVisited(head)) continue;
            this.createGroup(head);
            this.dfsUtil(head, head);
        }
    }

    private void dfsUtil(OrderableEntity topHead, OrderableEntity node) {
        if (this.isVisited(node)) {
            this.groups.mergeGroupsByChild(node, topHead);
            return;
        }
        this.visited.add(node);
        if (this.isLeaf(node)) {
            this.groups.addToGroupByHead(topHead, node);
            return;
        }
        List<OrderableEntity> childs = this.getChilds(node);
        for (OrderableEntity child : childs) {
            this.dfsUtil(topHead, child);
        }
        this.groups.addToGroupByHead(topHead, node);
    }

    private List<OrderableEntity> getHeads() {
        ArrayList<OrderableEntity> ret = new ArrayList<OrderableEntity>();
        for (OrderableEntity job : this.jobs) {
            if (!this.dependencies.isHead(job)) continue;
            ret.add(job);
        }
        return ret;
    }

    private boolean isVisited(OrderableEntity head) {
        return this.visited.contains(head);
    }

    private void createGroup(OrderableEntity head) {
        this.groups.addGroup(head);
    }

    private List<OrderableEntity> getChilds(OrderableEntity node) {
        return this.dependencies.getEntityDependencies(node);
    }

    private boolean isLeaf(OrderableEntity child) {
        List<OrderableEntity> childs = this.getChilds(child);
        boolean isLeaf = childs.isEmpty();
        return isLeaf;
    }

    public List<Group> getGroups() {
        return this.groups.getGroups();
    }

    public class Groups {
        private Map<OrderableEntity, Group> jobsToGroups = new HashMap<OrderableEntity, Group>();
        private Set<Group> groups = new HashSet<Group>();

        public void addGroup(OrderableEntity head) {
            Group newGroup = new Group(GroupsFinder.this, head);
            this.jobsToGroups.put(head, newGroup);
            this.groups.add(newGroup);
        }

        public void addToGroupByHead(OrderableEntity head, OrderableEntity child) {
            Group group = this.jobsToGroups.get(head);
            group.add(child);
            this.jobsToGroups.put(child, group);
        }

        public void mergeGroupsByChild(OrderableEntity child, OrderableEntity head) {
            Group headGroup;
            Group childGroup = this.jobsToGroups.get(child);
            if (childGroup == (headGroup = this.jobsToGroups.get(head))) {
                return;
            }
            List<OrderableEntity> nodes = headGroup.getNodes();
            for (OrderableEntity node : nodes) {
                childGroup.add(node);
                this.jobsToGroups.put(node, childGroup);
            }
            headGroup.clear();
            this.groups.remove(headGroup);
        }

        public String toString() {
            return "Groups [groups=" + String.valueOf(this.groups) + "]";
        }

        public List<Group> getGroups() {
            ArrayList<Group> ret = new ArrayList<Group>(this.groups);
            return ret;
        }
    }

    public class Group {
        private Set<OrderableEntity> jobs = new HashSet<OrderableEntity>();

        public Group(GroupsFinder this$0, OrderableEntity head) {
            this.jobs.add(head);
        }

        public void clear() {
            this.jobs.clear();
        }

        public List<OrderableEntity> getNodes() {
            ArrayList<OrderableEntity> ret = new ArrayList<OrderableEntity>();
            ret.addAll(this.jobs);
            return ret;
        }

        public void add(OrderableEntity job) {
            this.jobs.add(job);
        }

        public String toString() {
            return "Group [jobs=" + String.valueOf(this.jobs) + "]";
        }
    }
}

