/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.assessmentreport;

import com.bmc.ctmconvert.AppData;
import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.flowupdater.assessmentreport.FlowUpdaterAssesmentReportTreeGenerator;
import com.bmc.ctmconvert.flowupdater.assessmentreport.FlowUpdaterAssessmenReplier;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterJobMeetCriteria;
import com.bmc.ctmconvert.services.VendorDataManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.stream.Stream;
import javax.swing.tree.DefaultMutableTreeNode;

public class FlowUpdaterAssessmenrReport
extends AbstractAssessmentReport {
    private FlowUpdaterAssessmenReplier assessmenReplier;
    private DataObject dataObject;
    private DataObject injectionDataObject;
    private FlowUpdaterJobMeetCriteria flowUpdaterJobMeetCriteria;

    public FlowUpdaterAssessmenrReport(String pathName, String descriptionXMLFileName, String optionalFile, FlowUpdaterJobMeetCriteria flowUpdaterJobMeetCriteria) {
        super(pathName, descriptionXMLFileName, optionalFile);
        AppData appData = (AppData)VendorDataManager.instance().getVendorData();
        this.flowUpdaterJobMeetCriteria = flowUpdaterJobMeetCriteria;
        this.dataObject = VendorDataManager.instance().getDataObject();
        this.injectionDataObject = appData.getInjectionDataObject().get();
        this.assessmenReplier = new FlowUpdaterAssessmenReplier(this.dataObject, this.injectionDataObject, flowUpdaterJobMeetCriteria);
        this.m_descriptionTypeLookNodesHandler = (v, n, i) -> 2;
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        Stream<DataEntity> jobsMeetCriteria = this.assessmenReplier.getJobsMeetCriteria();
        this.assessmenReplier.initDescriptionMap();
        jobsMeetCriteria = this.assessmenReplier.getJobsMeetCriteria();
        DefaultMutableTreeNode jobMeetCriteriaTree = this.generateNodeTree(jobsMeetCriteria);
        return jobMeetCriteriaTree;
    }

    private DefaultMutableTreeNode generateNodeTree(Stream<DataEntity> jobsMeetCriteria) {
        String datasourceName = Params.instance().getDatasourceName();
        FlowUpdaterAssesmentReportTreeGenerator treeGenerator = new FlowUpdaterAssesmentReportTreeGenerator(datasourceName);
        return treeGenerator.generateNodeTree(jobsMeetCriteria);
    }

    protected String getJobInfo(String messageID) {
        return null;
    }

    protected String getJobInfo(DefaultMutableTreeNode node) {
        StringBuilder sb = new StringBuilder();
        if (node != null) {
            if (node.isRoot()) {
                long totalNodesNumber = this.assessmenReplier.getNumberOfFoldersInInput();
                long totalJobsNumber = this.assessmenReplier.getTotalJobsNumber();
                long totalNodesNumberFromInjectedData = this.assessmenReplier.getTotalNodesNumberFromInjectedData();
                long totalJobsNumberFromInjectedData = this.assessmenReplier.getTotalJobsNumberFromInjectedData();
                long totalNodesNumberAfterConversion = this.assessmenReplier.getTotalFoldersNumberAfterConversion();
                long totalJobsNumberAfterConversion = this.assessmenReplier.getTotalJobsNumberAfterConversion();
                long totalJobsMeetCriteria = this.assessmenReplier.getJobsMeetCriteriaCount();
                sb.append("Summary:");
                sb.append("\n");
                sb.append("-----------------");
                sb.append("\n");
                sb.append("\n");
                sb.append("Control-M input data contains :");
                sb.append("\n");
                sb.append(String.format("%-28s\t: %d%s", " Total Number of folders", totalNodesNumber, "\n"));
                sb.append(String.format("%-28s\t: %d%s", " Total Number of jobs", totalJobsNumber, "\n"));
                sb.append("\n");
                sb.append("Search criteria specified :");
                sb.append("\n");
                sb.append(String.format("%-28s\t: %s", " Control-M field", this.flowUpdaterJobMeetCriteria.getReplaceCriteria() + "\n"));
                sb.append(String.format("%-28s\t: %s", " Value contains", this.flowUpdaterJobMeetCriteria.getSearchCriteria() + "\n"));
                sb.append("\n");
                sb.append("Control-M data to insert contains :");
                sb.append("\n");
                sb.append(String.format("%-28s\t: %d%s", " Total Number of folders", totalNodesNumberFromInjectedData, "\n"));
                sb.append(String.format("%-28s\t: %d%s", " Total Number of jobs", totalJobsNumberFromInjectedData, "\n"));
                sb.append("\n");
                sb.append("Search results :");
                sb.append("\n");
                sb.append(String.format("%-28s\t: %d%s", " Number of jobs meet the Search criteria", totalJobsMeetCriteria, "\n"));
                sb.append("\n");
                sb.append("After conversion the output Control-M data will contain :");
                sb.append("\n");
                sb.append(String.format("%-28s\t: %d%s", " Total Number of folders", totalNodesNumberAfterConversion, "\n"));
                sb.append(String.format("%-28s\t: %d%s", " Total Number of jobs", totalJobsNumberAfterConversion, "\n"));
            } else if (node.isLeaf()) {
                String nodeName = (String)node.getUserObject();
                sb.append(this.assessmenReplier.getNodeDescription(nodeName));
            }
        }
        return sb.toString();
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        return null;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        return new HashMap<String, String>();
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return "";
    }

    protected void updateDescriptionAreaOfParentNode(String nodeName, DefaultMutableTreeNode node) {
    }
}

