/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.flowupdater.assessmentreport;

import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.dataObject.Data;
import com.bmc.ctmconvert.dataObject.DataEntity;
import com.bmc.ctmconvert.dataObject.DataObject;
import com.bmc.ctmconvert.flowupdater.convertor.ConverionInjectionMode;
import com.bmc.ctmconvert.flowupdater.data.XmlData;
import com.bmc.ctmconvert.flowupdater.inject.FlowUpdaterJobMeetCriteria;
import java.util.HashMap;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.stream.Stream;

public class FlowUpdaterAssessmenReplier {
    private DataObject dataObject;
    private DataObject injectionDataObject;
    private FlowUpdaterJobMeetCriteria flowUpdaterJobMeetCriteria;
    private HashMap<String, String> nodeId2Description = new HashMap();

    public FlowUpdaterAssessmenReplier(DataObject dataObject, DataObject injectionDataObject, FlowUpdaterJobMeetCriteria flowUpdaterJobMeetCriteria) {
        this.dataObject = dataObject;
        this.injectionDataObject = injectionDataObject;
        this.flowUpdaterJobMeetCriteria = flowUpdaterJobMeetCriteria;
    }

    public long getNumberOfFoldersInInput() {
        return this.dataObject.stream().filter(de -> de.getData().getDataType().equals("FOLDER")).count();
    }

    public long getTotalNodesNumberFromInjectedData() {
        return this.injectionDataObject.stream().filter(de -> de.getData().getDataType().equals("FOLDER")).count();
    }

    public long getTotalFoldersNumberAfterConversion() {
        long foldersInInput = this.getNumberOfFoldersInInput();
        long jobsMeetCriteria = this.getJobsMeetCriteriaCount();
        ConverionInjectionMode converionInjectionMode = new ConverionInjectionMode(this.injectionDataObject);
        return foldersInInput + jobsMeetCriteria * converionInjectionMode.numberOfFoldersAddedToOutput();
    }

    public long getTotalJobsNumber() {
        return this.dataObject.stream().filter(de -> de.getData().getDataType().equals("JOB")).count();
    }

    public long getTotalJobsNumberFromInjectedData() {
        return this.injectionDataObject.stream().filter(de -> de.getData().getDataType().equals("JOB")).count();
    }

    public long getTotalJobsNumberAfterConversion() {
        long currentNumberOfJobs = this.getTotalJobsNumber();
        long jobsMeetCriteria = this.getJobsMeetCriteriaCount();
        long numberOfJobdInInjectedFlow = this.injectionDataObject.stream().filter(de -> de.getData().getDataType().equals("JOB")).count();
        return currentNumberOfJobs + jobsMeetCriteria * (numberOfJobdInInjectedFlow - 1L);
    }

    public long getJobsMeetCriteriaCount() {
        return this.dataObject.stream().filter(de -> this.flowUpdaterJobMeetCriteria.isJobMeetCriteria((DataEntity)de)).count();
    }

    public Stream<DataEntity> getJobsMeetCriteria() {
        return this.dataObject.stream().filter(de -> this.flowUpdaterJobMeetCriteria.isJobMeetCriteria((DataEntity)de));
    }

    public void initDescriptionMap() {
        Consumer<DataEntity> addJobToMap = job -> {
            Optional optionalJobname = job.getAttributes().findFirst("JOB_NAME");
            String jobname = optionalJobname.isPresent() ? (String)optionalJobname.get() : "";
            String fullXml = "";
            Data data = job.getData();
            if (data instanceof XmlData) {
                XmlData jobData = (XmlData)data;
                XmlElement element = jobData.getJobXmlElement();
                fullXml = GlobalFunctions.formatXml((String)element.toString());
            }
            this.nodeId2Description.put(jobname, fullXml);
        };
        this.getJobsMeetCriteria().forEach(addJobToMap);
    }

    public String getNodeDescription(String name) {
        return this.nodeId2Description.get(name);
    }
}

