/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron.bmcdiscovery;

import com.bmc.ctmconvert.bmcdiscovery.OSDiscoveryFilesWriter;
import java.io.IOException;
import java.nio.file.FileSystem;
import java.nio.file.FileSystems;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.Map;

public class CronDiscoveryFilesWriter
extends OSDiscoveryFilesWriter {
    public CronDiscoveryFilesWriter(String destDirectory) {
        super(FileSystems.getDefault(), destDirectory);
    }

    public CronDiscoveryFilesWriter(FileSystem fileSystem, String destDirectory) {
        super(fileSystem, destDirectory);
    }

    public void writeOSfiles(Map cronDefinitions) throws IOException {
        Map cronMap = cronDefinitions;
        for (Map.Entry hostEntry : cronMap.entrySet()) {
            String hostName = ((String)hostEntry.getKey()).trim();
            for (Map.Entry userEntry : ((Map)hostEntry.getValue()).entrySet()) {
                String userName = ((String)userEntry.getKey()).trim();
                String cronDef = (String)userEntry.getValue();
                if (cronDef.trim().equals("")) continue;
                String fileName = String.format("%s%%%s.txt", userName, hostName);
                String fileFullPathAsString = String.format("%s/%s", this.destDirectory, fileName);
                Path fileFullPath = this.fileSystem.getPath(fileFullPathAsString, new String[0]);
                Files.createFile(fileFullPath, new FileAttribute[0]);
                Files.write(fileFullPath, cronDef.getBytes(), new OpenOption[0]);
            }
        }
    }
}

