/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron.bmcdiscovery;

import com.bmc.ctmconvert.bmcdiscovery.DiscoveryIntegrationException;
import com.bmc.ctmconvert.bmcdiscovery.OSDiscoveryDefinitionsParser;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.json.JSONArray;
import org.json.JSONObject;

public class CronDiscoveryDefinitionsParser
implements OSDiscoveryDefinitionsParser {
    private boolean atLeastOneCronTabFound = false;
    private Pattern userPattern = Pattern.compile("(User):(.*) SEPARATOR");
    private Map<String, Map<String, String>> cronDefinitionsMap = new HashMap<String, Map<String, String>>();

    public void parse(JSONArray resultsArray) {
        JSONObject resultsContainerJson = resultsArray.getJSONObject(0);
        JSONArray results = resultsContainerJson.getJSONArray("results");
        results.forEach(result -> {
            JSONObject resultJson = (JSONObject)result;
            String hostName = resultJson.getString("#DiscoveryResult:DiscoveryAccessResult:DiscoveryAccess:DiscoveryAccess.#Associate:Inference:InferredElement:Host.name");
            LinkedHashMap user2cronDef = new LinkedHashMap();
            this.cronDefinitionsMap.put(hostName, user2cronDef);
            String resultContent = resultJson.getString("result");
            String[] resultLines = resultContent.split("\r?\n");
            StringBuilder cronDef = new StringBuilder();
            for (String line : resultLines) {
                if (line.contains("SEPARATOR")) {
                    Matcher matcher = this.userPattern.matcher(line);
                    if (!matcher.find()) continue;
                    String userName = matcher.group(2).trim();
                    this.cronDefinitionsMap.get(hostName).put(userName, cronDef.toString());
                    cronDef.setLength(0);
                    continue;
                }
                cronDef.append(line + "\r\n");
                this.atLeastOneCronTabFound = true;
            }
        });
    }

    public Map getParsedDefinitions() throws DiscoveryIntegrationException {
        if (this.cronDefinitionsMap.size() == 0) {
            throw new DiscoveryIntegrationException("No Cron job definitions were found by BMC Discovery.");
        }
        if (!this.atLeastOneCronTabFound) {
            throw new DiscoveryIntegrationException("Failed to parse the Cron data that was retrieved from BMC Discovery Server. Please contact BMC Support for further assistance.");
        }
        return new HashMap<String, Map<String, String>>(this.cronDefinitionsMap);
    }
}

