/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.cron.CronDefs;
import com.bmc.ctmconvert.cron.CronGlobals;
import com.bmc.ctmconvert.cron.CronRbcGenerator;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.services.settings.SettingsStringKeys;
import com.bmc.ctmconvert.services.settings.SettingsTable;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Scanner;

public class CronJob
implements SchedEntity {
    private ArrayList<String> messages = new ArrayList();
    private SchedEntity.TYPE entityType;
    private IAttrHolder entityData;
    private Properties properties = new Properties();
    private boolean validEntity = true;
    private ArrayList<SchedEntity> children;
    private SchedEntity parent;
    private boolean isScheduled;
    private LinkedHashMap<String, String> autoedits;
    private ArrayList<String> optionalAttributes;
    private String targetMailAddress = null;
    private ArrayList<Properties> onStmts;
    private RulesDataSet rules;
    private CronDefs cronDefs;

    public CronJob(SchedEntity.TYPE entityType, IAttrHolder entityData, SchedEntity parent, CronDefs cronDefs) {
        this.entityType = entityType;
        this.entityData = entityData;
        this.parent = parent;
        this.cronDefs = cronDefs;
        this.isScheduled = true;
        HashMap<String, String> competitorValues = new HashMap<String, String>();
        this.rules = this.cronDefs.getRules();
        competitorValues.put("Machine", entityData.getAttr("MachineName"));
        competitorValues.put("User_Name", entityData.getAttr("UserName"));
        competitorValues.put("Command Line", entityData.getAttr("Command"));
        competitorValues.put("Full_Cron_Entry", entityData.getAttr("FullCronEntry"));
        switch (entityType) {
            case SMART_TABLE: 
            case TABLE: {
                String tableName = FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", entityData.getAttr("MachineName"));
                this.properties.setProperty("TABLE_NAME", tableName);
                this.properties.setProperty("JOBNAME", tableName);
                break;
            }
            case SUB_TABLE: {
                this.properties.setProperty("JOBNAME", FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", entityData.getAttr("UserName")));
                this.generateAutoedits();
                this.resolveMailto();
                break;
            }
            case JOB: {
                this.properties.setProperty("JOBNAME", entityData.getAttr("ID"));
                this.properties.setProperty("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", entityData.getAttr("MachineName")));
                this.properties.setProperty("CYCLIC", "0");
                this.properties.setProperty("TAG_RELATIONSHIP", "OR");
                this.properties.setProperty("ACTIVE_FROM", "");
                this.properties.setProperty("ACTIVE_TILL", "");
                if (entityData.getAttr("FullCronEntry").trim().startsWith("@reboot")) {
                    this.isScheduled = false;
                    Reporter.addMessage(this.messages, (String)"WRN9001", (String)this.properties.getProperty("JOBNAME"), (String[])new String[]{entityData.getAttr("FullCronEntry")});
                }
                this.convertTimes();
                this.convertTaskType();
                this.addOnStatements();
                break;
            }
        }
        this.properties.setProperty("APPLICATION", FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", this.rules.getFieldEditor().generateCTMField("APPLICATION", competitorValues)));
        this.properties.setProperty("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", this.rules.getFieldEditor().generateCTMField("GROUP", competitorValues)));
        this.properties.setProperty("DESCRIPTION", FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", this.rules.getFieldEditor().generateCTMField("DESCRIPTION", competitorValues)));
        this.properties.setProperty("OWNER", FieldValidation.instance().validateAndReturnFixedValue("OWNER", this.rules.getFieldEditor().generateCTMField("OWNER", competitorValues)));
        this.properties.setProperty("AUTHOR", FieldValidation.instance().validateAndReturnFixedValue("AUTHOR", this.rules.getFieldEditor().generateCTMField("AUTHOR", competitorValues)));
    }

    private void addOnStatements() {
        String address = ((CronJob)this.parent).getMailAddress();
        if (address != null && !address.isEmpty()) {
            if (this.onStmts == null) {
                this.onStmts = new ArrayList();
            }
            Properties okStmtProperties = new Properties();
            String okText = String.format("Job %%%%JOBNAME - %%%%ORDERID %s", "ended successfully");
            String notokText = String.format("Job %%%%JOBNAME - %%%%ORDERID %s", "failed");
            okStmtProperties.setProperty("ACTION", "DOMAIL");
            okStmtProperties.setProperty("CODE", "OK");
            okStmtProperties.setProperty("STMT", "*");
            okStmtProperties.setProperty("MESSAGE", okText);
            okStmtProperties.setProperty("SUBJECT", okText);
            okStmtProperties.setProperty("URGENCY", "R");
            okStmtProperties.setProperty("ATTACH_SYSOUT", "No");
            okStmtProperties.setProperty("DEST", address);
            Properties notokStmtProperties = (Properties)okStmtProperties.clone();
            notokStmtProperties.setProperty("CODE", "NOTOK");
            notokStmtProperties.setProperty("MESSAGE", notokText);
            notokStmtProperties.setProperty("SUBJECT", notokText);
            this.onStmts.add(notokStmtProperties);
            this.onStmts.add(okStmtProperties);
        }
    }

    private void resolveMailto() {
        String fromConf = this.rules.getStringRule("Cron rules", new String[]{"DO_MAIL_GENERATION"});
        String tmpMailAddress = (String)this.autoedits.remove("%%MAILTO");
        if (!fromConf.equals("DO_MAIL_NEVER")) {
            this.targetMailAddress = tmpMailAddress;
            if (this.targetMailAddress == null && fromConf.equals("DO_MAIL_FOR_ALL")) {
                this.targetMailAddress = this.rules.getStringRule("Cron rules", new String[]{"DO_MAIL_DEFAULT_ADDRESS"});
                this.targetMailAddress = this.targetMailAddress.replace("{Machine}", this.entityData.getAttr("MachineName")).replace("{User Name}", this.entityData.getAttr("UserName"));
            }
        }
    }

    public void setMailAddress(String address) {
        this.targetMailAddress = address;
    }

    public String getMailAddress() {
        return this.targetMailAddress;
    }

    private void generateAutoedits() {
        String[] origTab;
        if (this.autoedits == null) {
            this.autoedits = new LinkedHashMap();
        }
        for (String cronTab : origTab = this.entityData.getAttr("FullCronEntry").split("[\\r\\n]+")) {
            if (!cronTab.matches("^\\s*[_A-Za-z0-9]+\\s*=.*")) continue;
            String[] lineArr = cronTab.split("=", 2);
            String varName = "%%" + lineArr[0].trim();
            String varValue = lineArr.length == 1 || lineArr[1] == null ? "" : lineArr[1].trim();
            this.autoedits.put(varName, varValue);
        }
    }

    private void convertTaskType() {
        boolean convertToCmdline = this.rules.getTaskTypeHandler().isToCommandType();
        String cmdline = this.entityData.getAttr("Command");
        cmdline = this.handleRedirection(cmdline);
        if (!convertToCmdline) {
            if (cmdline.contains(";") || cmdline.matches(".*[^\\\\]%.*")) {
                int i;
                String[] inputArr = cmdline.replaceAll("([^\\\\])%", "$1 %").split("\\s*[^\\\\]%\\s*");
                StringBuilder embeddedScript = new StringBuilder();
                String[] commandsArray = inputArr[0].split("\\s*;\\s*");
                for (i = 0; i < commandsArray.length; ++i) {
                    commandsArray[i] = commandsArray[i].replace("\\%", "%");
                    embeddedScript.append(commandsArray[i]);
                    if (inputArr.length > 1 && i == commandsArray.length - 1) continue;
                    embeddedScript.append("\n");
                }
                for (i = 1; inputArr.length > 1 && i < inputArr.length; ++i) {
                    inputArr[i] = inputArr[i].replace("\\%", "%");
                    if (i == 1) {
                        embeddedScript.append("<<EOF\n");
                    }
                    embeddedScript.append(inputArr[i]);
                    embeddedScript.append("\n");
                    if (i != inputArr.length - 1) continue;
                    embeddedScript.append("EOF\n");
                }
                this.properties.setProperty("TASKTYPE", "Job");
                this.properties.setProperty("MEMNAME", this.getJobName());
                this.properties.setProperty("USE_INSTREAM_JCL", "Y");
                this.setOptionalAttribute("INSTREAM_JCL", embeddedScript.toString());
            } else {
                convertToCmdline = true;
                for (String taskTypeFilter : this.rules.getTaskTypeHandler().getTaskTypeFilters()) {
                    convertToCmdline = convertToCmdline && !cmdline.contains(taskTypeFilter);
                }
                if (!convertToCmdline) {
                    ArrayList cmdArgs = GlobalFunctions.cmdline2ArgArr((String)cmdline, (boolean)true);
                    if (cmdArgs == null) {
                        convertToCmdline = true;
                    } else {
                        this.properties.setProperty("TASKTYPE", "Job");
                        this.properties.setProperty("MEMLIB", (String)cmdArgs.get(0));
                        this.properties.setProperty("MEMNAME", (String)cmdArgs.get(1));
                        for (int i = 2; i < cmdArgs.size(); ++i) {
                            if (this.autoedits == null) {
                                this.autoedits = new LinkedHashMap();
                            }
                            this.autoedits.put(String.format("%%%%PARM%d", i - 1), (String)cmdArgs.get(i));
                        }
                    }
                }
            }
        }
        if (convertToCmdline) {
            this.properties.setProperty("TASKTYPE", "Command");
            this.properties.setProperty("CMDLINE", cmdline);
            this.properties.setProperty("MEMNAME", this.getJobName());
        }
        if (this.rules.getTaskTypeHandler().isToDummy()) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                if (this.autoedits == null) {
                    this.autoedits = new LinkedHashMap();
                }
                if (convertToCmdline) {
                    this.autoedits.put("%%$BMCWAIORIGTYPE", "Command");
                } else {
                    this.autoedits.put("%%$BMCWAIORIGTYPE", "Job");
                }
            }
            this.properties.setProperty("TASKTYPE", "Dummy");
        }
    }

    private String handleRedirection(String cmdline) {
        String[] origCmdlineArr = ((String)cmdline).replaceAll("([^\\\\])%", "$1 %").split("\\s*([^\\\\])%\\s*", 2);
        if (((String)(cmdline = origCmdlineArr[0])).contains(">") && !((String)cmdline).contains(";") && ((String)(cmdline = ((String)cmdline).replaceAll("\\s*2\\s*>\\s*&1\\s*", ""))).contains(">")) {
            int redirDiff = ((String)cmdline).lastIndexOf(62) - ((String)cmdline).indexOf(62);
            if (redirDiff > 1) {
                Reporter.addMessage(this.messages, (String)"INF9002", (String)this.properties.getProperty("JOBNAME"), (String[])new String[]{cmdline});
            } else {
                String[] tmpArr = ((String)cmdline).split("\\s*>+\\s*", 2);
                String targetFile = tmpArr[1];
                if (!targetFile.equals("/dev/null")) {
                    if (redirDiff == 1) {
                        Reporter.addMessage(this.messages, (String)"INF9001", (String)this.properties.getProperty("JOBNAME"), (String[])new String[]{tmpArr[0], tmpArr[1]});
                    }
                    Properties tmpStatement = new Properties();
                    tmpStatement.setProperty("CODE", "COMPSTAT EQ ANY");
                    tmpStatement.setProperty("STMT", "*");
                    tmpStatement.setProperty("ACTION", "DOSYSOUT");
                    tmpStatement.setProperty("OPTION", "Copy");
                    tmpStatement.setProperty("PAR", targetFile);
                    if (this.onStmts == null) {
                        this.onStmts = new ArrayList();
                    }
                    this.onStmts.add(tmpStatement);
                }
                cmdline = tmpArr[0];
            }
        }
        if (origCmdlineArr.length > 1) {
            cmdline = (String)cmdline + " % " + origCmdlineArr[1];
        }
        return cmdline;
    }

    private void setOptionalAttribute(String name, String value) {
        if (this.optionalAttributes == null) {
            this.optionalAttributes = new ArrayList();
        }
        if (!this.optionalAttributes.contains(name)) {
            this.optionalAttributes.add(name);
        }
        this.properties.setProperty(name, value);
    }

    private void convertTimes() {
        String[] hours = CronGlobals.value2list(this.entityData.getAttr("Hour"), 0, 23).split(",");
        String[] minutes = CronGlobals.value2list(this.entityData.getAttr("Minute"), 0, 59).split(",");
        ArrayList<Integer> minsFromMidnight = new ArrayList<Integer>();
        for (String hour : hours) {
            for (String minute : minutes) {
                minsFromMidnight.add(Integer.parseInt(hour) * 60 + Integer.parseInt(minute));
            }
        }
        Collections.sort(minsFromMidnight);
        String timeFrom = String.format("%02d%02d", (Integer)minsFromMidnight.get(0) / 60, (Integer)minsFromMidnight.get(0) % 60);
        if (minsFromMidnight.size() > 1) {
            this.properties.setProperty("CYCLIC", "1");
            StringBuilder timesSequence = new StringBuilder(String.format("%02d%02d", (Integer)minsFromMidnight.get(0) / 60, (Integer)minsFromMidnight.get(0) % 60));
            Integer intervalCandidate = (Integer)minsFromMidnight.get(1) - (Integer)minsFromMidnight.get(0);
            String timeTo = null;
            for (int i = 1; i < minsFromMidnight.size(); ++i) {
                if ((Integer)minsFromMidnight.get(i) - (Integer)minsFromMidnight.get(i - 1) != intervalCandidate) {
                    intervalCandidate = -1;
                }
                timesSequence.append(',').append(String.format("%02d%02d", (Integer)minsFromMidnight.get(i) / 60, (Integer)minsFromMidnight.get(i) % 60));
                if (i != minsFromMidnight.size() - 1 || intervalCandidate <= 0 || ((Integer)minsFromMidnight.get(i) + intervalCandidate) % 1440 == (Integer)minsFromMidnight.get(0)) continue;
                timeTo = String.format("%02d%02d", (Integer)minsFromMidnight.get(i) / 60, (Integer)minsFromMidnight.get(i) % 60);
            }
            if (intervalCandidate > 0 && timesSequence.toString().split(",").length > 2) {
                this.properties.setProperty("CYCLIC_TYPE", "Interval");
                this.properties.setProperty("INTERVAL", String.format("%05dM", intervalCandidate));
                this.properties.setProperty("TIMEFROM", timeFrom);
                if (timeTo != null) {
                    this.properties.setProperty("TIMETO", timeTo);
                }
            } else {
                this.properties.setProperty("CYCLIC_TYPE", "SpecificTimes");
                this.properties.setProperty("CYCLIC_TIMES_SEQUENCE", timesSequence.toString());
            }
            this.properties.setProperty("CYCLIC_TOLERANCE", "1");
            this.properties.setProperty("IND_CYCLIC", "TARGET");
        } else {
            this.properties.setProperty("TIMEFROM", timeFrom);
        }
    }

    public SchedEntity.TYPE type() {
        return this.entityType;
    }

    public String originalProductID() {
        return null;
    }

    public List<SchedEntity> getChildren() {
        if (this.children != null) {
            return this.children;
        }
        this.children = new ArrayList();
        HashMap<String, String> filterDetails = new HashMap<String, String>();
        switch (this.entityType) {
            case SMART_TABLE: {
                String[] childsNames = this.entityData.getAttr("ChildList").split(",");
                for (int i = 0; i < childsNames.length; ++i) {
                    StringBuilder stringBuilder = new StringBuilder();
                    Scanner scanner = null;
                    try {
                        scanner = new Scanner(new File(Params.instance().getDatasourcePath() + String.format("%s%%%s.txt", childsNames[i], this.entityData.getAttr("MachineName"))));
                        while (scanner.hasNextLine()) {
                            stringBuilder.append(scanner.nextLine()).append("\r\n");
                        }
                        scanner.close();
                    }
                    catch (FileNotFoundException e) {
                        ExceptionHandler.writeToExceptionFile((Exception)e);
                        ProcessAlertsManager.instance().addMessage(e.getMessage());
                    }
                    filterDetails.put("User_Name", childsNames[i]);
                    if (!this.rules.getFilterHandler().isFilter(filterDetails)) continue;
                    AttrHolder cronSubTable = new AttrHolder(new String[]{childsNames[i], this.entityData.getAttr("MachineName"), childsNames[i], "", "", "", "", "", "", "", stringBuilder.toString()}, (Map)AttrHolder.buildHeadersMap((String)"ID,MachineName,UserName,ChildList,Minute,Hour,Day_Of_Month,Month,Day_Of_Week,Command,FullCronEntry"));
                    this.children.add(new CronJob(SchedEntity.TYPE.SUB_TABLE, (IAttrHolder)cronSubTable, this, this.cronDefs));
                }
                break;
            }
            case SUB_TABLE: {
                HashMap<String, String> fieldHash = new HashMap<String, String>();
                fieldHash.put("Machine", this.entityData.getAttr("MachineName"));
                fieldHash.put("User_Name", this.entityData.getAttr("UserName"));
                Scanner scanner = null;
                try {
                    scanner = new Scanner(new File(Params.instance().getDatasourcePath() + String.format("%s%%%s.txt", this.entityData.getAttr("UserName"), this.entityData.getAttr("MachineName"))));
                    String line = "";
                    int counter = 1;
                    while (scanner.hasNextLine()) {
                        String mangledLine;
                        String[] jobAttributes;
                        line = scanner.nextLine().trim();
                        if (line.isEmpty() || line.startsWith("#") || (jobAttributes = (mangledLine = this.replaceKeywords(line)).split("\\s+", 6)).length != 6) continue;
                        filterDetails.put("Command Line", jobAttributes[5]);
                        if (!this.rules.getFilterHandler().isFilter(filterDetails)) continue;
                        String formattedValue = this.rules.getStringRule("", new String[]{"Field Editor", "JOBNAME", "FORMAT_VALUE"});
                        String addCounter = formattedValue.contains("{COUNTER}") ? "" : "_" + counter++;
                        AttrHolder cronJob = new AttrHolder(new String[]{this.rules.getFieldEditor().generateCTMField("JOBNAME", fieldHash) + addCounter, this.entityData.getAttr("MachineName"), this.entityData.getAttr("UserName"), "", jobAttributes[0], jobAttributes[1], jobAttributes[2], jobAttributes[3], jobAttributes[4], jobAttributes[5], line}, (Map)AttrHolder.buildHeadersMap((String)"ID,MachineName,UserName,ChildList,Minute,Hour,Day_Of_Month,Month,Day_Of_Week,Command,FullCronEntry"));
                        this.children.add(new CronJob(SchedEntity.TYPE.JOB, (IAttrHolder)cronJob, this, this.cronDefs));
                    }
                    scanner.close();
                }
                catch (FileNotFoundException e) {
                    ExceptionHandler.writeToExceptionFile((Exception)e);
                    ProcessAlertsManager.instance().addMessage(e.getMessage());
                }
                break;
            }
        }
        return this.children;
    }

    private String replaceKeywords(String line) {
        String toRet = line.trim();
        if (toRet.startsWith("@")) {
            toRet = toRet.replaceFirst("^@hourly", "0 * * * * ");
            toRet = toRet.replaceFirst("^@daily", "0 0 * * * ");
            toRet = toRet.replaceFirst("^@midnight", "0 0 * * * ");
            toRet = toRet.replaceFirst("^@weekly", "0 0 * * 0 ");
            toRet = toRet.replaceFirst("^@monthly", "0 0 1 * * ");
            toRet = toRet.replaceFirst("^@yearly", "0 0 1 1 * ");
            toRet = toRet.replaceFirst("^@annually", "0 0 1 1 * ");
            toRet = toRet.replaceFirst("^@reboot", "0 0 1 1 * ");
        }
        return toRet;
    }

    public List<AssistingJob> getAssistingJobs() {
        ArrayList<AssistingJob> assistingJobs = new ArrayList<AssistingJob>();
        if (this.type() == SchedEntity.TYPE.SMART_TABLE && this.getChildren() != null) {
            for (SchedEntity child : this.getChildren()) {
                assistingJobs.addAll(((CronJob)child).getAssistingJobsForParent());
            }
        }
        return assistingJobs;
    }

    protected List<AssistingJob> getAssistingJobsForParent() {
        ArrayList<AssistingJob> assistingJobs = new ArrayList<AssistingJob>();
        if (this.getChildren() != null && !this.getChildren().isEmpty()) {
            for (SchedEntity child : this.getChildren()) {
                assistingJobs.addAll(((CronJob)child).getAssistingJobsForParent());
            }
        } else if (this.type() == SchedEntity.TYPE.JOB) {
            assistingJobs.add(this.getDisableJob());
        }
        return assistingJobs;
    }

    AssistingJob getDisableJob() {
        String origCrontabLine = this.entityData.getAttr("FullCronEntry");
        origCrontabLine = origCrontabLine.replaceAll("([^\\\\])([\\$\\\"\\\\])", "$1\\\\$2");
        AssistingJob toRet = new AssistingJob(SchedEntity.TYPE.JOB);
        ArrayList<Properties> emptyRbc = new ArrayList<Properties>();
        emptyRbc.add(CronRbcGenerator.instance().geEmptyRbc());
        toRet.setM_tags(emptyRbc);
        String application = SettingsTable.instance().getProperty(SettingsStringKeys.CRON_DISCOVERY_JOBS_APPLICATION);
        String group = SettingsTable.instance().getProperty(SettingsStringKeys.CRON_DISCOVERY_JOBS_SUB_APPLICATION);
        String table = SettingsTable.instance().getProperty(SettingsStringKeys.CRON_DISCOVERY_JOBS_FOLDER_NAME);
        toRet.setAttribute("APPLICATION", application);
        toRet.setAttribute("GROUP", group);
        toRet.setAttribute("OWNER", this.getAttr("OWNER"));
        toRet.setAttribute("AUTHOR", this.getAttr("AUTHOR"));
        toRet.setAttribute("NODEID", this.getAttr("NODEID"));
        toRet.setAttribute("TAG_RELATIONSHIP", "OR");
        toRet.setAttribute("DESCRIPTION", String.format("You can order manually this job in order to disable the cron job that was converted to %s in %s sub folder.%n The line <%s> will be commented out of crontab by this job", this.getJobName(), this.getParentName(), this.entityData.getAttr("FullCronEntry")));
        toRet.setAttribute("PARENT_TABLE", table);
        toRet.setAttribute("TABLE_NAME", table);
        toRet.setAutoedit("%%LINE_TO_REPLACE", origCrontabLine);
        toRet.setAttribute("USE_INSTREAM_JCL", "Y");
        toRet.setAttribute("MEMNAME", ".cmd");
        boolean bConvertToDummy = this.rules.getTaskTypeHandler().isToDummy();
        if (bConvertToDummy) {
            if (!Params.instance().getGUIVersion().equals("7")) {
                toRet.setAutoedit("%%$BMCWAIORIGTYPE", "Job");
            }
            toRet.setAttribute("TASKTYPE", "Dummy");
        } else {
            toRet.setAttribute("TASKTYPE", "Job");
        }
        toRet.setAttribute("JOBNAME", String.format("disable_%s_at_%s", this.properties.getProperty("JOBNAME"), this.properties.getProperty("NODEID")));
        toRet.setOptionalAttribute("INSTREAM_JCL", this.createScript().toString());
        toRet.addControlResource(this.createControlResource(this.getAttr("NODEID"), this.getAttr("OWNER")));
        return toRet;
    }

    private StringBuilder createScript() {
        StringBuilder script = new StringBuilder();
        script.append("#!/bin/sh\n");
        script.append("tmp_file=\"/tmp/disable_crontab_$$\"\n");
        script.append("old_size=`crontab -l | wc -c`\n");
        script.append("crontab -l | while read line\n");
        script.append("do\n");
        script.append("\tif [ \"X$line\" = \"X$LINE_TO_REPLACE\" ];then\n");
        script.append("\t\techo \\# Disabled by Control-M Conversion Tool \"$line\" >> $tmp_file\n");
        script.append("\telse\n");
        script.append("\t\techo \"$line\" >> $tmp_file\n");
        script.append("\tfi\n");
        script.append("done\n");
        script.append("\n#We need to compare sizes since the while read loop runs in a sub-shell\n");
        script.append("new_size=`cat $tmp_file | wc -c`\n");
        script.append("if [ $new_size -ne $old_size ];then\n");
        script.append("\tcrontab $tmp_file\n");
        script.append("\trc=$?\n");
        script.append("else\n");
        script.append("\techo Failed to locate cron entry to disable\n");
        script.append("\trc=1\n");
        script.append("fi\n");
        script.append("exit $rc\n");
        return script;
    }

    private Properties createControlResource(String nodeId, String owner) {
        Properties controlResource = new Properties();
        controlResource.put("NAME", nodeId + "-" + owner);
        controlResource.put("TYPE", "E");
        controlResource.put("ONFAIL", "R");
        return controlResource;
    }

    public String getAttr(String attrName) {
        return this.properties.getProperty(attrName);
    }

    public List<Properties> getInConds() {
        return null;
    }

    public List<Properties> getOutConds() {
        return null;
    }

    public List<Properties> getTags() {
        LinkedHashSet<Properties> calendars = new LinkedHashSet<Properties>();
        Properties myRbc = null;
        myRbc = this.isScheduled ? CronRbcGenerator.instance().getRbc(this.entityData.getAttr("Month"), this.entityData.getAttr("Day_Of_Month"), this.entityData.getAttr("Day_Of_Week").toUpperCase()) : CronRbcGenerator.instance().geEmptyRbc();
        if (myRbc != null) {
            calendars.add(myRbc);
        }
        if (this.getChildren() != null) {
            for (SchedEntity child : this.getChildren()) {
                calendars.addAll(child.getTags());
            }
        }
        return new ArrayList<Properties>(calendars);
    }

    public List<Properties> getQuantResources() {
        return null;
    }

    public List<Properties> getCtrlResources() {
        return null;
    }

    public List<Properties> getOnStmt() {
        return this.onStmts;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getShouts() {
        return null;
    }

    public String getJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getOriginalJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getParentName() {
        return this.parent != null ? this.parent.getTablePathForSons() : "";
    }

    public SchedEntity getParent() {
        return this.parent;
    }

    public String getTablePathForSons() {
        Object toRet = this.parent == null ? "" : this.parent.getTablePathForSons() + "/";
        toRet = (String)toRet + this.getJobName();
        return toRet;
    }

    public boolean isValid() {
        return this.validEntity;
    }

    public boolean hasWarnings() {
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean isDSJob() {
        return true;
    }

    public String getTableName() {
        return this.getJobName();
    }

    public boolean isCyclic() {
        String cyclic = this.properties.getProperty("CYCLIC");
        if (cyclic == null) {
            return false;
        }
        return cyclic.equals("1");
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.properties.getProperty("APPLICATION");
    }

    public String getGroup() {
        return this.properties.getProperty("GROUP");
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    public List<String> getOptionalAttributes() {
        return this.optionalAttributes;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }
}

