/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron;

import com.bmc.ctmconvert.common.AttrHolder;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.cron.CronJob;
import com.bmc.ctmconvert.cron.CronRbcGenerator;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.io.File;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CronDefs
implements SourceDefinitions {
    private ArrayList<String> messages = new ArrayList();
    private HashMap<String, String> cronTables;
    private AttrHolderList top_level_parents;
    private RulesDataSet rules = RuleManager.instance().getCurrentRules();

    public CronDefs() {
        Params.instance().setFirstDayOfTheWeek(this.rules.getStringRule("Cron rules", new String[]{"FIRST_DAY_OF_WEEK"}));
    }

    public AttrHolderList getTopLevelEntities() {
        if (this.top_level_parents == null) {
            this.top_level_parents = new AttrHolderList();
            HashMap<String, String> filterDetails = new HashMap<String, String>();
            for (String machine : this.cronTables.keySet()) {
                AttrHolder cronTable = new AttrHolder(new String[]{machine, machine, "", this.cronTables.get(machine), "", "", "", "", "", "", ""}, (Map)AttrHolder.buildHeadersMap((String)"ID,MachineName,UserName,ChildList,Minute,Hour,Day_Of_Month,Month,Day_Of_Week,Command,FullCronEntry"));
                filterDetails.put("Machine", machine);
                if (!this.rules.getFilterHandler().isFilter(filterDetails)) continue;
                this.top_level_parents.add((Object)cronTable);
            }
        }
        return this.top_level_parents;
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public void finalize_() {
        CronRbcGenerator.destroy();
    }

    public void init() throws ConvertorCancelClickException {
        File dataSourceDirectory = new File(Params.instance().getDatasourcePath());
        this.cronTables = new HashMap();
        Pattern cronFileNamePattern = Pattern.compile("(.*)%(.*)\\.txt");
        for (File cronFile : dataSourceDirectory.listFiles()) {
            Matcher matcher = cronFileNamePattern.matcher(cronFile.getName());
            if (!matcher.matches()) continue;
            String machine = matcher.group(2);
            String user = matcher.group(1);
            Object userList = this.cronTables.containsKey(machine) ? this.cronTables.get(machine) : "";
            userList = (String)userList + user + ",";
            this.cronTables.put(machine, (String)userList);
        }
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        return new CronJob(SchedEntity.TYPE.SMART_TABLE, attributes, null, this);
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return null;
    }

    public String getIdFieldName() {
        return "ID";
    }

    public String getEntNameFieldName() {
        return "ID";
    }

    public String getParentEntFieldName() {
        return null;
    }

    public boolean hasChildren(String entId) {
        return this.cronTables.containsKey(entId) && !this.cronTables.get(entId).isEmpty();
    }

    public void createDependencies(String root) {
    }

    public void applyFilter(String root) {
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public boolean isStandAloneGrouped() {
        return false;
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return entAttr.getAttr("Command").isEmpty();
    }

    public ArrayList<String> getGeneralMessages() {
        return this.messages;
    }

    public RulesDataSet getRules() {
        return this.rules;
    }
}

