/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.cron;

import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.cron.CronDataReader;
import com.bmc.ctmconvert.os.OsDataImportMethodGetter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import javax.swing.tree.DefaultMutableTreeNode;

public class CronAssessmentReportReplier {
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private Map<String, Integer> numberOfJobsMap;
    private Map<String, Map<String, String[]>> machine2UserJobs;
    private Map<String, Map<String, String[]>> machineUserVaribles;
    private final int USER_DESCRIPTION = 3;
    private final int JOB_DESCRIPTION = 4;

    public CronAssessmentReportReplier(AssessmentXMLDescriptionReader m_DescriptionXMLReader, CronDataReader cronDataReader) {
        this.m_DescriptionXMLReader = m_DescriptionXMLReader;
        cronDataReader.parseCronData();
        this.numberOfJobsMap = cronDataReader.getMachineToJobsMap();
        this.machine2UserJobs = cronDataReader.getMachine2userJobs();
        this.machineUserVaribles = cronDataReader.getMachineUserVaribles();
    }

    public DefaultMutableTreeNode insertMachineToTree(String name) {
        String machineName = this.appendNumOfjobs(name);
        Map<String, String[]> users = this.machine2UserJobs.get(name);
        DefaultMutableTreeNode tree = new DefaultMutableTreeNode(machineName);
        for (String username : users.keySet()) {
            tree.add(this.insertUserToTree(username, users.get(username)));
        }
        return tree;
    }

    public String appendNumOfjobs(String name) {
        int num = this.numberOfJobsMap.get(name) == null ? 0 : this.numberOfJobsMap.get(name);
        return name + "(" + num + ")";
    }

    public String removeNumOfNode(String name) {
        if (!name.contains("(")) {
            return name;
        }
        return name.substring(0, name.lastIndexOf("("));
    }

    public String parseJobDescription(String machineName, String userName, String jobName) {
        Map<String, String[]> usersMap = this.machine2UserJobs.get(this.removeNumOfNode(machineName));
        String[] jobs = usersMap.get(this.removeNumOfNode(userName));
        int indexFromJobName = this.getIndexFromJobName(jobName);
        String line = jobs[indexFromJobName];
        String cmd = "\ncommand";
        Object tmpCmdLine = "";
        line = line.trim().replaceAll("\\s+", " ");
        String[] lines = line.split(" ");
        for (int i = 5; i < lines.length; ++i) {
            tmpCmdLine = (String)tmpCmdLine + lines[i] + " ";
        }
        String[] cmdArr = ((String)tmpCmdLine).split(";");
        tmpCmdLine = "";
        if (cmdArr.length == 1) {
            tmpCmdLine = cmd + "\t:  " + cmdArr[0];
        } else {
            for (int i = 0; i < cmdArr.length; ++i) {
                tmpCmdLine = (String)tmpCmdLine + cmd + " " + i + "\t:  " + cmdArr[i];
            }
        }
        String description = "Job name\t:  " + jobName + "\nMinute\t:  " + lines[0] + "\nHour\t:  " + lines[1] + "\nDay\t:  " + lines[2] + "\nMonth\t:  " + lines[3] + "\nDay of week\t:  " + lines[4] + (String)tmpCmdLine;
        return description;
    }

    public String getUserDescription(String machineName, String userName) {
        machineName = this.removeNumOfNode(machineName);
        userName = this.removeNumOfNode(userName);
        String nodeName = "User";
        String description = this.m_DescriptionXMLReader.getDescriptionOfNode(nodeName);
        String[] userVars = this.machineUserVaribles.get(machineName).get(userName);
        Object vars = "";
        if (userVars != null && userVars.length != 0) {
            vars = "variables\t: ";
            for (int i = 0; i < userVars.length; ++i) {
                vars = (String)vars + userVars[i] + "\n\t  ";
            }
        }
        int jobsNum = this.machine2UserJobs.get(machineName).get(userName).length;
        return this.parseUserDescriptionParams(description, userName, jobsNum, (String)vars);
    }

    public String getMachineDescription(String machineName) {
        String description = this.m_DescriptionXMLReader.getDescriptionOfNode("Machine");
        return this.parseMachineDescriptionParams(description, machineName, this.machine2UserJobs.get(machineName).size(), this.numberOfJobsMap.get(machineName));
    }

    public Set<String> getAllMachineNames() {
        return this.machine2UserJobs.keySet();
    }

    public Set<String> getAllUsersForMachine(String machineName) {
        return this.machine2UserJobs.get(machineName).keySet();
    }

    public String getMainSummary() {
        StringBuilder mainSummary = new StringBuilder();
        OsDataImportMethodGetter dataImportMethodGetter = new OsDataImportMethodGetter();
        String dataImportMethodTitle = dataImportMethodGetter.getDataImportMethodTitle("crontab data");
        String joinQuery = dataImportMethodTitle + this.m_DescriptionXMLReader.getDescriptionOfNode("MainSummary") + this.m_DescriptionXMLReader.getDescriptionOfNode("MachinesNum") + this.m_DescriptionXMLReader.getDescriptionOfNode("UsersNum") + this.m_DescriptionXMLReader.getDescriptionOfNode("JobsNum") + this.m_DescriptionXMLReader.getDescriptionOfNode("Notes");
        mainSummary.append(this.parseMainSummaryDescirptionParams(joinQuery));
        return mainSummary.toString();
    }

    public String getEntityDescription(String messageID) {
        if (messageID == null) {
            return "";
        }
        String[] messagePartArray = messageID.split(";");
        return switch (messagePartArray.length) {
            case 3 -> {
                String machineName = messagePartArray[1];
                String userName = messagePartArray[2];
                yield this.getUserDescription(machineName, userName);
            }
            case 4 -> {
                String machineName = messagePartArray[1];
                String userName = messagePartArray[2];
                String jobName = messagePartArray[3];
                yield this.parseJobDescription(machineName, userName, jobName);
            }
            default -> "";
        };
    }

    private int numOfMachines() {
        return this.machine2UserJobs.size();
    }

    private int numOfUsers() {
        int usersNum = 0;
        Iterator<String> it = this.machine2UserJobs.keySet().iterator();
        while (it.hasNext()) {
            usersNum += this.machine2UserJobs.get(it.next()).size();
        }
        return usersNum;
    }

    private int numOfjobs() {
        int jobNum = 0;
        for (String machineKey : this.machine2UserJobs.keySet()) {
            Iterator<String> usersIt = this.machine2UserJobs.get(machineKey).keySet().iterator();
            while (usersIt.hasNext()) {
                jobNum += this.machine2UserJobs.get(machineKey).get(usersIt.next()).length;
            }
        }
        return jobNum;
    }

    private String parseMainSummaryDescirptionParams(String description) {
        if (!description.contains("#")) {
            return description;
        }
        description = description.replace("#NUM_OF_MACHINES#", "" + this.numOfMachines());
        description = description.replace("#NUM_OF_USERS#", "" + this.numOfUsers());
        description = description.replace("#NUM_OF_JOBS#", "" + this.numOfjobs());
        return description;
    }

    private String parseUserDescriptionParams(String description, String userName, int jobNum, String varsList) {
        if (!description.contains("#")) {
            return description;
        }
        description = description.replace("#USER_NAME#", userName);
        description = description.replace("#NUM_OF_JOBS_PER_USER#", "" + jobNum);
        description = description.replace("#USER_VARIABLES#", varsList);
        return description;
    }

    private String parseMachineDescriptionParams(String description, String machineName, int numOfUsers, int numOfjobs) {
        if (!description.contains("#")) {
            return description;
        }
        description = description.replace("#MACHINE_NAME#", machineName);
        description = description.replace("#NUM_OF_USERS_PER_MACHINE#", "" + numOfUsers);
        description = description.replace("#NUM_OF_JOBS_PER_MACHINE#", "" + numOfjobs);
        return description;
    }

    private DefaultMutableTreeNode insertUserToTree(String userName, String[] jobs) {
        String userNameDisplayName = userName + "(" + jobs.length + ")";
        DefaultMutableTreeNode tree = new DefaultMutableTreeNode(userNameDisplayName);
        for (int i = 0; i < jobs.length; ++i) {
            tree.add(new DefaultMutableTreeNode(this.createJobName(i, userName)));
        }
        return tree;
    }

    private String createJobName(int i, String userName) {
        return userName + "_Job_" + (i + 1);
    }

    private int getIndexFromJobName(String jobName) {
        return Integer.parseInt(jobName.substring(jobName.lastIndexOf("_") + 1)) - 1;
    }

    public Map<String, Integer> getNumberOfJobsMap() {
        return new HashMap<String, Integer>(this.numberOfJobsMap);
    }
}

