/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwood;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.calendars.DefCalFile;
import com.bmc.ctmconvert.redwood.CsvTablesManager;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class SchedulingConverter {
    private static SchedulingConverter instance;
    private static final String WIN$NAME = "WIN$NAME";
    private static final String MIN$TIME = "MIN$TIME";
    private static final String MAX$TIME = "MAX$TIME";
    private static final String MIN$DAY = "MIN$DAY";
    private static final String MAX$DAY = "MAX$DAY";
    private static final String MIN$WEEKDAY = "MIN$WEEKDAY";
    private static final String MAX$WEEKDAY = "MAX$WEEKDAY";
    private static final String MIN$WEEK = "MIN$WEEK";
    private static final String MAX$WEEK = "MAX$WEEK";
    private static final String MIN$MONTH = "MIN$MONTH";
    private static final String MAX$MONTH = "MAX$MONTH";
    private static final String MIN$DATE = "MIN$DATE";
    private static final String MAX$DATE = "MAX$DATE";
    private static final String ENA$NAME = "ENA$NAME";
    private static final String DIS$NAME = "DIS$NAME";
    private static final String FUN$NAME = "FUN$NAME";
    private static final String MIN$NUMBER = "MIN$NUMBER";
    private static final String STR$ARG1 = "STR$ARG1";
    private static final String TIME_WINDOW_BUILTIN_DAY = "TIME_WINDOW_BUILTIN_DAY";
    private static final String TIME_WINDOW_BUILTIN_DAYINWEEK = "TIME_WINDOW_BUILTIN_DAYINWEEK";
    private static final String TIME_WINDOW_BUILTIN_RECURRENCE = "TIME_WINDOW_BUILTIN_RECURRENCE";
    private static final String TIME_WINDOW_BUILTIN_WEEKDAY = "TIME_WINDOW_BUILTIN_WEEKDAY";
    private static final String SUB$NAME = "SUB$NAME";
    private static final String SPC$MINUTE = "SPC$MINUTE";
    private static final String SPC$DAY = "SPC$DAY";
    private static final String SPC$MONTH = "SPC$MONTH";
    private static final Pattern recurrencePattern;
    private final HashMap<String, Properties> allRbcs;
    private final HashMap<String, SchedlingAttributes> schedulingData = new HashMap();

    public static SchedulingConverter instance() {
        if (instance == null) {
            instance = new SchedulingConverter();
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
    }

    private SchedulingConverter() {
        this.allRbcs = new HashMap();
        this.loadSchedulingData();
    }

    private void loadSchedulingData() {
        SchedlingAttributes attributes;
        AttrHolderList windows = CsvTablesManager.get(CsvTablesManager.TableName.RWS_WEL).getAttrHoldersList();
        for (Object window : windows) {
            this.schedulingData.put(window.getAttr(WIN$NAME), this.getWindowScheduling((IAttrHolder)window));
        }
        AttrHolderList frames = CsvTablesManager.get(CsvTablesManager.TableName.RWS_SEL).getAttrHoldersList();
        for (IAttrHolder frame : frames) {
            this.schedulingData.put(frame.getAttr(SUB$NAME), this.getFrameScheduling(frame));
        }
        if (!this.allRbcs.containsKey("EVERYDAY_RBC")) {
            attributes = new SchedlingAttributes(this);
            this.addRbcToContainers("EVERYDAY_RBC", this.getAllDaysRbc("EVERYDAY_RBC"), attributes);
            this.schedulingData.put("EVERYDAY_RBC", attributes);
        }
        if (!this.allRbcs.containsKey("EMPTY_RBC")) {
            attributes = new SchedlingAttributes(this);
            this.addRbcToContainers("EMPTY_RBC", this.getEmptyRbc("EMPTY_RBC"), attributes);
            this.schedulingData.put("EMPTY_RBC", attributes);
        }
        this.writeRbcsToFile();
    }

    private void writeRbcsToFile() {
        try (DefCalFile calOutFile = DefCalFile.createDefCalFile();){
            for (Properties rbc : this.allRbcs.values()) {
                calOutFile.writeRBC(rbc);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    private SchedlingAttributes getFrameScheduling(IAttrHolder frame) {
        String interval;
        String frameName = frame.getAttr(SUB$NAME);
        SchedlingAttributes attributes = this.schedulingData.get(frameName);
        if (attributes == null) {
            attributes = new SchedlingAttributes(this);
        }
        if (!(interval = frame.getAttr(SPC$MINUTE)).isEmpty()) {
            try {
                int intervalInt = Integer.parseInt(interval);
                attributes.addJobAttribute("CYCLIC", "1");
                attributes.addJobAttribute("CYCLIC_TYPE", "Interval");
                attributes.addJobAttribute("INTERVAL", String.format("%05dM", intervalInt));
                attributes.addJobAttribute("CYCLIC_TOLERANCE", "1");
                attributes.addJobAttribute("IND_CYCLIC", "TARGET");
            }
            catch (NumberFormatException e) {
                attributes.addMessage("WRN14002", new String[]{frameName, interval});
            }
        }
        String dayInterval = frame.getAttr(SPC$DAY);
        String monthInterval = frame.getAttr(SPC$MONTH);
        if (!dayInterval.isEmpty()) {
            if (dayInterval.trim().equals("1")) {
                this.addRbcToContainers(frameName, this.getAllDaysRbc(frameName), attributes);
            } else {
                attributes.addMessage("WRN14003", new String[]{frameName, dayInterval});
            }
        }
        if (!monthInterval.isEmpty()) {
            attributes.addMessage("WRN14004", new String[]{frameName, monthInterval});
        }
        return attributes;
    }

    public Properties getAllDaysRbc(String name) {
        String[] monthArray;
        Properties rbc = new Properties();
        this.setDefaultRbcValues(rbc);
        rbc.setProperty("NAME", FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", name));
        rbc.setProperty("DAYS", "ALL");
        for (String month : monthArray = GlobalFunctions.getMonthsArray()) {
            rbc.setProperty(month, "1");
        }
        return rbc;
    }

    public Properties getEmptyRbc(String name) {
        String[] monthArray;
        Properties rbc = new Properties();
        this.setDefaultRbcValues(rbc);
        rbc.setProperty("NAME", FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", name));
        rbc.setProperty("DAYS", "");
        for (String month : monthArray = GlobalFunctions.getMonthsArray()) {
            rbc.setProperty(month, "0");
        }
        return rbc;
    }

    private void addRbcToContainers(String name, Properties rbc, SchedlingAttributes attributes) {
        this.allRbcs.put(name, rbc);
        Properties draftRbc = new Properties();
        draftRbc.putAll((Map<?, ?>)rbc);
        draftRbc.setProperty("RETRO", "0");
        draftRbc.setProperty("LEVEL", "CONTROL-M");
        attributes.setRbc(draftRbc);
    }

    private SchedlingAttributes getWindowScheduling(IAttrHolder window) {
        String windowName = window.getAttr(WIN$NAME);
        SchedlingAttributes attributes = this.schedulingData.get(windowName);
        if (attributes == null) {
            attributes = new SchedlingAttributes(this);
        }
        this.setTimeFromTO(attributes, window);
        this.setWindowRbc(attributes, window);
        this.additionalAttributes(attributes, window);
        return attributes;
    }

    private void additionalAttributes(SchedlingAttributes attributes, IAttrHolder window) {
        String DIS;
        String ENA = window.getAttr(ENA$NAME);
        if (ENA != null && !ENA.isEmpty()) {
            attributes.addMessage("WRN14012", new String[]{ENA$NAME, ENA});
        }
        if ((DIS = window.getAttr(DIS$NAME)) != null && !DIS.isEmpty()) {
            attributes.addMessage("WRN14012", new String[]{DIS$NAME, DIS});
        }
        String MINDATE = window.getAttr(MIN$DATE);
        String MAXDATE = window.getAttr(MAX$DATE);
        if (MINDATE != null && !MINDATE.isEmpty() || MAXDATE != null && !MAXDATE.isEmpty()) {
            attributes.addMessage("WRN14012", new String[]{String.format("%s,%s", MIN$DATE, MAX$DATE), String.format("%s,%s", MINDATE, MAXDATE)});
        }
    }

    private void setTimeFromTO(SchedlingAttributes attributes, IAttrHolder window) {
        String startTime = window.getAttr(MIN$TIME);
        String endTime = window.getAttr(MAX$TIME);
        if (!startTime.isEmpty() && !endTime.isEmpty()) {
            if (attributes.getJobAttributes().contains("TIMEFROM") || attributes.getJobAttributes().contains("TIMETO")) {
                attributes.addMessage("WRN14005", new String[]{window.getAttr(WIN$NAME)});
            }
            try {
                int from = Integer.parseInt(startTime) / 60;
                int to = Integer.parseInt(endTime) / 60;
                attributes.addJobAttribute("TIMEFROM", String.format("%02d%02d", from / 60, from % 60));
                attributes.addJobAttribute("TIMETO", String.format("%02d%02d", to / 60, to % 60));
            }
            catch (NumberFormatException e) {
                attributes.addMessage("WRN14006", new String[]{window.getAttr(WIN$NAME), startTime, endTime});
            }
        }
    }

    private void setWindowRbc(SchedlingAttributes attributes, IAttrHolder window) {
        Properties windowRbc = new Properties();
        String function = window.getAttr(FUN$NAME);
        if (function != null && !function.isEmpty()) {
            if (function.equalsIgnoreCase(TIME_WINDOW_BUILTIN_DAY)) {
                windowRbc = this.convertBuiltinDay(attributes, window);
            } else if (function.equalsIgnoreCase(TIME_WINDOW_BUILTIN_DAYINWEEK)) {
                windowRbc = this.convertBuiltinDayInWeek(attributes, window);
            } else if (function.equalsIgnoreCase(TIME_WINDOW_BUILTIN_RECURRENCE)) {
                windowRbc = this.convertBuiltinRecurrence(attributes, window);
            } else if (function.equalsIgnoreCase(TIME_WINDOW_BUILTIN_WEEKDAY)) {
                windowRbc = this.convertBuiltinWeekDay(attributes, window);
            } else {
                attributes.addMessage("WRN14007", new String[]{window.getAttr(WIN$NAME), function});
            }
        }
        if (!windowRbc.isEmpty()) {
            this.convertMonths(attributes, window, windowRbc);
            Properties prevRbc = this.allRbcs.get(window.getAttr(WIN$NAME));
            if (prevRbc != null) {
                windowRbc = this.mergeRbcs(prevRbc, windowRbc);
            } else {
                windowRbc.setProperty("NAME", FieldValidation.instance().validateAndReturnFixedValue("TAG_NAME", window.getAttr(WIN$NAME)));
                this.setDefaultRbcValues(windowRbc);
            }
            this.addRbcToContainers(window.getAttr(WIN$NAME), windowRbc, attributes);
        }
    }

    private void setDefaultRbcValues(Properties rbc) {
        rbc.setProperty("DATACENTER", Params.instance().getDatacenterName());
        rbc.setProperty("DAYS_AND_OR", "OR");
        rbc.put("DAYS_AND_OR", "OR");
        rbc.setProperty("MAXWAIT", RuleManager.instance().getCurrentRules().getStringRule("Redwood rules", new String[]{"MAXWAIT"}));
        rbc.setProperty("SHIFT", "IGNOREJOB");
        rbc.setProperty("SHIFTNUM", "+00");
    }

    private Properties mergeRbcs(Properties prevRbc, Properties currRbc) {
        String days;
        String[] monthArray;
        for (String month : monthArray = GlobalFunctions.getMonthsArray()) {
            prevRbc.setProperty(month, prevRbc.getProperty(month).equals("1") || currRbc.getProperty(month).equals("1") ? "1" : "0");
        }
        if (currRbc.containsKey("DAYS")) {
            days = currRbc.getProperty("DAYS");
            if (prevRbc.containsKey("DAYS")) {
                days = this.getMeragedStr(prevRbc.getProperty("DAYS"), days);
            }
            prevRbc.setProperty("DAYS", days);
        }
        if (currRbc.containsKey("WEEKDAYS")) {
            days = currRbc.getProperty("WEEKDAYS");
            if (prevRbc.containsKey("WEEKDAYS")) {
                days = this.getMeragedStr(prevRbc.getProperty("WEEKDAYS"), days);
            }
            prevRbc.setProperty("WEEKDAYS", days);
        }
        return prevRbc;
    }

    private String getMeragedStr(String oldStr, String newStr) {
        ArrayList<String> oldArr = new ArrayList<String>(Arrays.asList(oldStr.split(",")));
        ArrayList<String> newArr = new ArrayList<String>(Arrays.asList(newStr.split(",")));
        for (String day : newArr) {
            if (oldArr.contains(day)) continue;
            oldArr.add(day);
        }
        StringBuilder toRet = new StringBuilder();
        for (int index = 0; index < oldArr.size(); ++index) {
            if (index > 0) {
                toRet.append(",");
            }
            toRet.append((String)oldArr.get(index));
        }
        return toRet.toString();
    }

    private Properties convertBuiltinDay(SchedlingAttributes attributes, IAttrHolder window) {
        Properties windowRbc;
        block6: {
            windowRbc = new Properties();
            String minDay = window.getAttr(MIN$DAY);
            String maxDay = window.getAttr(MAX$DAY);
            try {
                String days;
                block5: {
                    days = minDay;
                    int minDayInt = Integer.parseInt(minDay);
                    try {
                        int maxDayInt = Integer.parseInt(maxDay);
                        days = this.getFullRangeString(minDayInt, maxDayInt);
                    }
                    catch (NumberFormatException e) {
                        if (maxDay.isEmpty()) break block5;
                        attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), MAX$DAY});
                    }
                }
                if (!days.isEmpty()) {
                    windowRbc.setProperty("DAYS", days);
                }
            }
            catch (NumberFormatException e) {
                if (minDay.isEmpty()) break block6;
                attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), MIN$DAY});
            }
        }
        return windowRbc;
    }

    private Properties convertBuiltinDayInWeek(SchedlingAttributes attributes, IAttrHolder window) {
        Properties windowRbc = new Properties();
        String minWeekDay = window.getAttr(MIN$WEEKDAY);
        String maxWeekDay = window.getAttr(MAX$WEEKDAY);
        String minWeek = window.getAttr(MIN$WEEK);
        String maxWeek = window.getAttr(MAX$WEEK);
        try {
            String weeks;
            String weekDays;
            block11: {
                int minWeekInt;
                block10: {
                    weekDays = minWeekDay;
                    int minWeekDayInt = Integer.parseInt(minWeekDay);
                    weeks = minWeek;
                    minWeekInt = Integer.parseInt(minWeek);
                    try {
                        int maxWeekDayInt = Integer.parseInt(maxWeekDay);
                        weekDays = this.getFullRangeString(minWeekDayInt, maxWeekDayInt);
                    }
                    catch (NumberFormatException e) {
                        if (maxWeekDay.isEmpty()) break block10;
                        attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), MAX$WEEKDAY});
                    }
                }
                try {
                    int maxWeekInt = Integer.parseInt(maxWeek);
                    weeks = this.getFullRangeString(minWeekInt, maxWeekInt);
                }
                catch (NumberFormatException e) {
                    if (maxWeek.isEmpty()) break block11;
                    attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), MAX$WEEK});
                }
            }
            String[] days = weekDays.split(",");
            String[] weeksList = weeks.split(",");
            StringBuilder finalWeekDays = new StringBuilder();
            for (String day : days) {
                for (String week : weeksList) {
                    if (Integer.parseInt(day) < 8 && Integer.parseInt(week) < 6) {
                        finalWeekDays.append(!finalWeekDays.toString().isEmpty() ? "," : "").append("D").append((Integer.parseInt(day) - this.getFirstDay() + 7) % 7).append("W").append(week);
                        continue;
                    }
                    attributes.addMessage("WRN14011", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), day, week});
                }
            }
            if (!finalWeekDays.toString().isEmpty()) {
                windowRbc.setProperty("WEEKDAYS", finalWeekDays.toString());
            }
        }
        catch (NumberFormatException e) {
            attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), "MIN$WEEKDAY, MIN$DAY"});
        }
        return windowRbc;
    }

    private Properties convertBuiltinRecurrence(SchedlingAttributes attributes, IAttrHolder window) {
        Matcher matcher;
        Properties windowRbc = new Properties();
        String recurrenceType = window.getAttr(MIN$NUMBER);
        String days = window.getAttr(STR$ARG1);
        StringBuilder finalDays = new StringBuilder();
        StringBuilder finalWeekDays = new StringBuilder();
        if (recurrenceType.equals("0")) {
            for (int index = 0; index < days.length(); ++index) {
                if (days.charAt(index) != '1') continue;
                finalWeekDays.append(finalWeekDays.length() > 0 ? "," : "").append((index % 7 - this.getFirstDay() + 7) % 7);
            }
        } else if ((recurrenceType.equals("1") || recurrenceType.equals("2")) && (matcher = recurrencePattern.matcher(days)).matches()) {
            if (matcher.group(3) != null && matcher.group(5) != null) {
                if (Integer.parseInt(matcher.group(4)) < 6 && Integer.parseInt(matcher.group(7)) < 8) {
                    finalWeekDays.append("D").append((Integer.parseInt(matcher.group(7)) - this.getFirstDay() + 7) % 7).append(matcher.group(2));
                } else {
                    attributes.addMessage("WRN14011", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), matcher.group(7), matcher.group(4)});
                }
            } else if (matcher.group(5) != null) {
                if (!matcher.group(6).matches("[Xx]")) {
                    finalDays.append(matcher.group(7));
                } else {
                    attributes.addMessage("WRN14011", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), matcher.group(5), ""});
                }
            }
        }
        if (!finalDays.toString().isEmpty()) {
            windowRbc.setProperty("DAYS", finalDays.toString());
        }
        if (!finalWeekDays.toString().isEmpty()) {
            windowRbc.setProperty("WEEKDAYS", finalWeekDays.toString());
        }
        return windowRbc;
    }

    private Properties convertBuiltinWeekDay(SchedlingAttributes attributes, IAttrHolder window) {
        Properties windowRbc;
        block7: {
            windowRbc = new Properties();
            String minWeekDay = window.getAttr(MIN$WEEKDAY);
            String maxWeekDay = window.getAttr(MAX$WEEKDAY);
            try {
                String weekDays;
                block6: {
                    weekDays = minWeekDay;
                    int minWeekDayInt = Integer.parseInt(minWeekDay);
                    try {
                        int maxWeekDayInt = Integer.parseInt(maxWeekDay);
                        weekDays = this.getFullRangeString(minWeekDayInt, maxWeekDayInt);
                    }
                    catch (NumberFormatException e) {
                        if (maxWeekDay.isEmpty()) break block6;
                        attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), MAX$WEEKDAY});
                    }
                }
                List<String> days = Arrays.asList(weekDays.split(","));
                StringBuilder finalDays = new StringBuilder();
                for (String day : days) {
                    finalDays.append(days.indexOf(day) > 0 ? "," : "").append((Integer.parseInt(day) - this.getFirstDay() + 7) % 7);
                }
                if (!finalDays.toString().isEmpty()) {
                    windowRbc.setProperty("WEEKDAYS", finalDays.toString());
                }
            }
            catch (NumberFormatException e) {
                if (minWeekDay.isEmpty()) break block7;
                attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), MIN$WEEKDAY});
            }
        }
        return windowRbc;
    }

    private void convertMonths(SchedlingAttributes attributes, IAttrHolder window, Properties windowRbc) {
        block11: {
            String minMonth = window.getAttr(MIN$MONTH);
            String maxMonth = window.getAttr(MAX$MONTH);
            String extraMonth = "";
            Matcher matcher = recurrencePattern.matcher(window.getAttr(STR$ARG1));
            if (matcher.matches() && matcher.group(1) != null) {
                extraMonth = matcher.group(1).replaceAll("0?(\\d+)", "$1");
            }
            if (minMonth.isEmpty() && maxMonth.isEmpty()) {
                if (extraMonth.isEmpty()) {
                    minMonth = "1";
                    maxMonth = "12";
                } else {
                    minMonth = extraMonth;
                    extraMonth = "";
                }
            }
            try {
                String month;
                block10: {
                    month = minMonth;
                    int minMonthInt = Integer.parseInt(minMonth);
                    try {
                        int maxMonthInt = Integer.parseInt(maxMonth);
                        month = this.getFullRangeString(minMonthInt, maxMonthInt);
                    }
                    catch (NumberFormatException e) {
                        if (maxMonth.isEmpty()) break block10;
                        attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), MAX$MONTH});
                    }
                }
                List<String> months = Arrays.asList(month.split(","));
                if (!extraMonth.isEmpty()) {
                    months.addAll(Arrays.asList(extraMonth.split(",")));
                }
                String[] monthArray = GlobalFunctions.getMonthsArray();
                for (int i = 0; i < monthArray.length; ++i) {
                    windowRbc.setProperty(monthArray[i], months.contains(String.valueOf(i + 1)) ? "1" : "0");
                }
            }
            catch (NumberFormatException e) {
                if (minMonth.isEmpty()) break block11;
                attributes.addMessage("WRN14008", new String[]{window.getAttr(WIN$NAME), window.getAttr(FUN$NAME), MIN$MONTH});
            }
        }
    }

    private int getFirstDay() {
        String fromConf = RuleManager.instance().getCurrentRules().getStringRule("Redwood rules", new String[]{"FIRST_DAY_OF_WEEK"});
        for (int index = 0; index < Globs.WEEKDAYS_ARRAY.length; ++index) {
            if (!fromConf.equals(Globs.WEEKDAYS_ARRAY[index])) continue;
            return index - 1;
        }
        return 0;
    }

    private String getFullRangeString(int start, int end) {
        StringBuilder range = new StringBuilder();
        if (start >= 0 && end >= 0 && start <= end) {
            range.append(start);
            for (int index = start + 1; index <= end; ++index) {
                range.append(",").append(index);
            }
        } else {
            throw new NumberFormatException("Unable to parse interval");
        }
        return range.toString();
    }

    public SchedlingAttributes getSchedulingData(String objId) {
        return this.schedulingData.get(objId);
    }

    static {
        recurrencePattern = Pattern.compile("(\\d{0,2})?(([Ww])(\\d))?(([DdXx])(\\d{0,2}))?");
    }

    class SchedlingAttributes {
        private final List<Properties> additionalRbcs = new ArrayList<Properties>();
        private final Properties jobAttributes = new Properties();
        private Properties jobRbc;
        private final Map<String, List<String[]>> messages = new HashMap<String, List<String[]>>();

        public SchedlingAttributes(SchedulingConverter this$0) {
        }

        public void addAdditionalRbc(Properties rbc) {
            this.additionalRbcs.add(rbc);
        }

        public void addJobAttribute(String key, String value) {
            this.jobAttributes.setProperty(key, value);
        }

        public void setRbc(Properties rbc) {
            this.jobRbc = rbc;
        }

        public void addMessage(String msgID, String[] params) {
            List<String[]> paramsList = this.messages.get(msgID);
            if (paramsList == null) {
                paramsList = new ArrayList<String[]>();
            }
            paramsList.add(params);
            this.messages.put(msgID, paramsList);
        }

        public Properties getJobAttributes() {
            return this.jobAttributes;
        }

        public List<Properties> getRbcs() {
            return this.additionalRbcs;
        }

        public Properties getRbc() {
            return this.jobRbc;
        }

        public Map<String, List<String[]>> getMessages() {
            return this.messages;
        }
    }
}

