/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwood;

import com.bmc.ctmconvert.common.AssistingJob;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.MessageIdTable;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.Reporter;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.common.message_id.MessageId;
import com.bmc.ctmconvert.redwood.CsvTablesManager;
import com.bmc.ctmconvert.redwood.RedwoodDefs;
import com.bmc.ctmconvert.redwood.SchedulingConverter;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.vc.FieldValidation;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class RedwoodJob
implements SchedEntity {
    private ArrayList<String> optionalProperties = new ArrayList();
    private ArrayList<String> messages = new ArrayList();
    private SchedEntity.TYPE entityType;
    private Properties properties = new Properties();
    private boolean validEntity = true;
    private ArrayList<SchedEntity> children;
    private ArrayList<AssistingJob> assistingJobs;
    private IAttrHolder entityData;
    private IAttrHolder stepData;
    private RedwoodJob entityParent;
    private ArrayList<Properties> inConds;
    private ArrayList<Properties> outConds;
    private LinkedHashMap<String, String> autoedits;
    private ArrayList<Properties> onStmts;
    private List<Properties> rbcs;
    private RulesDataSet rules;
    private String ctmorderFormat = "ctmorder -TABLE \"%s\" -NAME \"*\" -ODATE ODAT";
    public static int uniqueNumber;
    private String uniqueTableOrParentName;
    private String validatedParentName;

    public RedwoodJob(SchedEntity.TYPE type, IAttrHolder data) {
        this.entityType = type;
        this.entityData = data;
        this.initialize();
    }

    public RedwoodJob(SchedEntity.TYPE type, IAttrHolder data, RedwoodJob parent) {
        this.entityType = type;
        this.entityData = data;
        this.entityParent = parent;
        this.initialize();
    }

    public RedwoodJob(IAttrHolder data, RedwoodJob parent) {
        this.entityType = SchedEntity.TYPE.SUB_TABLE;
        this.stepData = data;
        this.entityParent = parent;
        this.initialize();
    }

    private void initialize() {
        Object jobs;
        this.assistingJobs = new ArrayList();
        this.rules = RuleManager.instance().getCurrentRules();
        HashMap<String, String> competitorValues = null;
        if (this.stepData != null) {
            competitorValues = RedwoodDefs.getVendorDetaildForConfiguration(this.entityParent.entityData);
            competitorValues.put("Name", this.stepData.getAttr("STEPNAME"));
        } else {
            competitorValues = RedwoodDefs.getVendorDetaildForConfiguration(this.entityData);
        }
        this.autoedits = new LinkedHashMap();
        this.rbcs = new ArrayList<Properties>();
        this.generateConditions();
        this.properties.setProperty("APPLICATION", FieldValidation.instance().validateAndReturnFixedValue("APPLICATION", this.rules.getFieldEditor().generateCTMField("APPLICATION", competitorValues)));
        this.properties.setProperty("GROUP", FieldValidation.instance().validateAndReturnFixedValue("GROUP", this.rules.getFieldEditor().generateCTMField("GROUP", competitorValues)));
        this.properties.setProperty("OWNER", FieldValidation.instance().validateAndReturnFixedValue("OWNER", this.rules.getFieldEditor().generateCTMField("OWNER", competitorValues)));
        this.properties.setProperty("AUTHOR", FieldValidation.instance().validateAndReturnFixedValue("AUTHOR", this.rules.getFieldEditor().generateCTMField("AUTHOR", competitorValues)));
        this.properties.setProperty("DESCRIPTION", FieldValidation.instance().validateAndReturnFixedValue("DESCRIPTION", this.rules.getFieldEditor().generateCTMField("DESCRIPTION", competitorValues)));
        switch (this.entityType) {
            case SMART_TABLE: 
            case TABLE: {
                String tmpName = this.entityData.getAttr("NAME");
                String tableName = RedwoodDefs.getUniqueTableName(tmpName, true);
                this.properties.setProperty("JOBNAME", tableName);
                this.properties.setProperty("TABLE_NAME", tableName);
                if (tmpName.equals(tableName)) break;
                Reporter.addMessage(this.messages, (String)"INF0017", (String)this.getTablePathForSons(), (String[])new String[]{"JOBNAME", "NAME", tmpName, tableName, "since '" + tmpName + "' is already in use. Control-M does not allow duplicate folder names"});
                break;
            }
            case SUB_TABLE: {
                String subTableName = "";
                subTableName = this.stepData != null ? this.stepData.getAttr("STEPNAME") : this.entityData.getAttr("NAME");
                this.properties.setProperty("JOBNAME", FieldValidation.instance.validateAndReturnFixedValue("TABLE_NAME", subTableName));
                this.properties.setProperty("PARENT_TABLE", this.getParentName());
                break;
            }
            case JOB: {
                String jobName = this.entityData.getAttr("NAME");
                this.properties.setProperty("JOBNAME", jobName);
                this.properties.setProperty("PARENT_TABLE", this.getParentName());
                this.properties.setProperty("CYCLIC", "0");
                this.properties.setProperty("TAG_RELATIONSHIP", "OR");
                this.properties.setProperty("ACTIVE_FROM", "");
                this.properties.setProperty("ACTIVE_TILL", "");
                this.properties.setProperty("NODEID", FieldValidation.instance().validateAndReturnFixedValue("NODEID", ""));
                this.setOptionalAttribute("MAXWAIT", this.rules.getStringRule("Redwood rules", new String[]{"MAXWAIT"}));
                this.convertTaskType();
                break;
            }
        }
        if (this.entityData != null && !(jobs = CsvTablesManager.get(CsvTablesManager.TableName.RWS_JOB).getAttrHoldersList("OBJ#", this.entityData.getAttr("OBJ#"))).isEmpty()) {
            String winName = ((IAttrHolder)jobs.get(0)).getAttr("WIN$NAME");
            String subName = ((IAttrHolder)jobs.get(0)).getAttr("SUB$NAME");
            SchedulingConverter.SchedlingAttributes schedulingData = SchedulingConverter.instance().getSchedulingData(winName);
            if (schedulingData != null) {
                this.addSchedulingAttributes(winName, schedulingData, true);
            } else {
                ConversionLogger.getLogger().info("There is not Time Window data for job " + this.getOriginalJobName());
            }
            schedulingData = SchedulingConverter.instance().getSchedulingData(subName);
            if (schedulingData != null) {
                this.addSchedulingAttributes(subName, schedulingData, false);
            } else {
                ConversionLogger.getLogger().info("There is not Submission Frame data for job " + this.getOriginalJobName());
            }
        }
        if (!this.type().equals((Object)SchedEntity.TYPE.JOB)) {
            for (SchedEntity child : this.getChildren()) {
                for (Properties childRbc : child.getTags()) {
                    if (childRbc.getProperty("NAME").equals("*") || this.rbcs.contains(childRbc)) continue;
                    this.rbcs.add(childRbc);
                }
            }
        }
        if (this.rbcs.isEmpty()) {
            Properties rbc = new Properties();
            if (this.entityType.equals((Object)SchedEntity.TYPE.SMART_TABLE)) {
                rbc = SchedulingConverter.instance().getSchedulingData("EMPTY_RBC").getRbc();
                this.properties.setProperty("TABLE_USERDAILY", "");
            } else {
                rbc.setProperty("NAME", "*");
            }
            this.rbcs.add(rbc);
        }
        if (this.entityData != null) {
            this.handleEvents();
        }
    }

    private void handleEvents() {
        AttrHolderList events = CsvTablesManager.get(CsvTablesManager.TableName.RWS_OWEVT).getAttrHoldersList("OBJ#", this.entityData.getAttr("OBJ#"));
        for (IAttrHolder event : events) {
            String eventName = event.getAttr("EVT$NAME");
            AttrHolderList sevtData = CsvTablesManager.get(CsvTablesManager.TableName.RWS_SEVT).getAttrHoldersList("EVT$NAME", eventName);
            AttrHolderList evtData = CsvTablesManager.get(CsvTablesManager.TableName.RWS_EVT).getAttrHoldersList("NAME", eventName);
            String fileName = "";
            String interval = "";
            if (evtData.size() == 1) {
                fileName = ((IAttrHolder)evtData.get(0)).getAttr("R_FILENAME");
            }
            if (!sevtData.isEmpty()) {
                if (!((IAttrHolder)sevtData.get(0)).getAttr("FILENAME").isEmpty()) {
                    fileName = ((IAttrHolder)sevtData.get(0)).getAttr("FILENAME");
                }
                interval = ((IAttrHolder)sevtData.get(0)).getAttr("CHK_INT");
            }
            if (sevtData.isEmpty()) {
                ConversionLogger.getLogger().info("No definition found for '" + eventName + "' in  RWS_SEVT table.");
            }
            if (sevtData.size() > 1) {
                ConversionLogger.getLogger().info("A multiple definition found for '" + eventName + "' in  RWS_SEVT table.");
                Reporter.addMessage(this.messages, (String)"WRN14013", (String)this.getTablePathForSons(), (String[])new String[]{eventName, "RWS_SEVT"});
            }
            if (evtData.isEmpty()) {
                ConversionLogger.getLogger().info("No definition found for '" + eventName + "' in  RWS_EVT table.");
            }
            if (evtData.size() > 1) {
                ConversionLogger.getLogger().info("A multiple definition found for '" + eventName + "' in  RWS_EVT table.");
                Reporter.addMessage(this.messages, (String)"WRN14013", (String)this.getTablePathForSons(), (String[])new String[]{eventName, "RWS_EVT"});
            }
            if (!fileName.isEmpty()) {
                String assistingName = FieldValidation.instance().validateAndReturnFixedValue("JOBNAME", eventName);
                if (interval.isEmpty()) {
                    interval = "60";
                }
                AssistingJob assistingJob = new AssistingJob((SchedEntity)this);
                assistingJob.setAttribute("JOBNAME", assistingName);
                assistingJob.setAttribute("MEMNAME", assistingName);
                assistingJob.setAttribute("TASKTYPE", "Job");
                assistingJob.setAttribute("TABLE_NAME", this.type() == SchedEntity.TYPE.SMART_TABLE ? "StandAloneJobs_REDWOOD_EVENTS" : this.getTableName());
                assistingJob.setAttribute("STANDALONE_TABLE_NAME", "StandAloneJobs_REDWOOD_EVENTS");
                assistingJob.setAttribute("PARENT_TABLE", this.type() == SchedEntity.TYPE.SMART_TABLE ? "StandAloneJobs_REDWOOD_EVENTS" : this.getParentName());
                assistingJob.setAttribute("TAG_RELATIONSHIP", "OR");
                assistingJob.setAttribute("MEMLIB", "Not in use for File Watcher jobs");
                assistingJob.setOptionalAttribute("APPL_FORM", "File Watcher");
                assistingJob.setOptionalAttribute("APPL_TYPE", "FileWatch");
                assistingJob.setOptionalAttribute("APPL_VER", "9.0.00.300");
                assistingJob.setOptionalAttribute("CM_VER", "8.0.00");
                assistingJob.setAutoedit("%%FileWatch-FILE_PATH", fileName);
                assistingJob.setAutoedit("%%FileWatch-MIN_DET_SIZE", "0");
                assistingJob.setAutoedit("%%FileWatch-INT_FILE_SEARCHES", interval);
                assistingJob.setAutoedit("%%FileWatch-INT_FILESIZE_COMPARISON", "10");
                assistingJob.setAutoedit("%%FileWatch-NUM_OF_ITERATIONS", "3");
                assistingJob.setAutoedit("%%FileWatch-TIME_LIMIT", "0");
                assistingJob.setAutoedit("%%FileWatch-MIN_AGE", "NO_MIN_AGE");
                assistingJob.setAutoedit("%%FileWatch-MAX_AGE", "NO_MAX_AGE");
                assistingJob.setAutoedit("%%FileWatch-PATH", "Not in use for File Watcher jobs");
                assistingJob.setAutoedit("%%FileWatch-MODE", "CREATE");
                assistingJob.setAutoedit("%%FileWatch-FILESIZE_WILDCARD", "Y");
                assistingJob.setAutoedit("%%FileWatch-START_TIME", "NOW");
                assistingJob.setAutoedit("%%FileWatch-STOP_TIME", "0");
                assistingJob.setAutoedit("%%FileWatch-TIME_LIMIT", Integer.toString(1380));
                for (int index = 0; index < this.getInConds().size(); ++index) {
                    assistingJob.addInCondition(this.getInConds().remove(index));
                }
                String condName = String.format("%s-TO-%s#%03d", assistingName, this.getJobName(), uniqueNumber++);
                Properties tmpCond = new Properties();
                tmpCond.put("NAME", condName);
                tmpCond.put("ODATE", "ODAT");
                tmpCond.put("SIGN", "ADD");
                tmpCond.setProperty("AND_OR", "AND");
                assistingJob.addOutCondition(tmpCond);
                this.getInConds().add(tmpCond);
                Reporter.addMessage(this.messages, (String)"INF0011", (String)this.getTablePathForSons(), (String[])new String[]{Params.instance().getVendorName(), this.getJobName(), this.getParentName(), "Events", assistingJob.getJobName()});
                this.assistingJobs.add(assistingJob);
                if (this.type() != SchedEntity.TYPE.JOB || !this.isCyclic()) continue;
                Reporter.addMessage(this.messages, (String)"INF14002", (String)this.getTablePathForSons(), (String[])new String[]{assistingJob.getJobName(), this.getJobName()});
                continue;
            }
            Reporter.addMessage(this.messages, (String)"WRN0016", (String)this.getTablePathForSons(), (String[])new String[]{Params.instance().getVendorName(), "Events", "the filename value in the event definition is empty."});
        }
    }

    private void convertTaskType() {
        AttrHolderList srcList = CsvTablesManager.get(CsvTablesManager.TableName.RWS_SRC).getAttrHoldersList("OBJ#", this.entityData.getAttr("OBJ#"));
        if (this.entityData.getAttr("TYPE").equals("3")) {
            this.setOrderingJobProperties();
        } else if (srcList.size() == 1 && ((IAttrHolder)srcList.get(0)).getAttr("SOURCE").contains("ACTION = ")) {
            this.setSAPProperties(((IAttrHolder)srcList.get(0)).getAttr("SOURCE").replaceAll("\\s*ACTION = (.*)", "$1"));
        } else {
            this.setJobProperties(srcList);
        }
        if (this.rules.getTaskTypeHandler().isToDummy()) {
            this.setToDummy();
        }
    }

    private void setOrderingJobProperties() {
        this.properties.setProperty("JOBNAME", this.getOriginalJobName() + "_Ordering");
        this.properties.setProperty("TASKTYPE", "Command");
        this.properties.setProperty("CMDLINE", String.format(this.ctmorderFormat, this.getOriginalJobName()));
        this.properties.setProperty("MEMNAME", this.getJobName());
        Reporter.addMessage(this.messages, (String)"INF14001", (String)this.getTablePathForSons(), (String[])new String[0]);
    }

    private void setJobProperties(AttrHolderList srcList) {
        boolean toDummy = true;
        boolean script = true;
        StringBuilder embeddedScript = new StringBuilder();
        String[] orderedScript = new String[srcList.size() + 1];
        if (srcList.size() == 0) {
            script = false;
        } else if (srcList.size() == 1) {
            String line = ((IAttrHolder)srcList.get(0)).getAttr("SOURCE");
            if (line != null && !line.isEmpty()) {
                embeddedScript.append(line).append("\n");
                toDummy = false;
            } else {
                script = false;
            }
        } else if (srcList.size() > 1) {
            for (IAttrHolder srcLine : srcList) {
                Integer lineNum = srcLine.getAttrAsInt("LINE");
                if (lineNum == null) continue;
                String line = srcLine.getAttr("SOURCE");
                if (line.matches("\\s*#!.*/(sh|ksh|csh|tcsh|bash)")) {
                    toDummy = false;
                }
                orderedScript[lineNum.intValue()] = line;
            }
            for (String line : orderedScript) {
                if (line == null || line.equals("'")) continue;
                embeddedScript.append(line).append("\n");
            }
        }
        if (script) {
            this.properties.setProperty("TASKTYPE", "Job");
            this.properties.setProperty("MEMNAME", this.getJobName());
            this.properties.setProperty("USE_INSTREAM_JCL", "Y");
            this.setOptionalAttribute("INSTREAM_JCL", embeddedScript.toString());
            if (toDummy) {
                this.setToDummy();
                Reporter.addMessage(this.messages, (String)"WRN14001", (String)this.getTablePathForSons(), (String[])new String[]{this.getJobName()});
            }
        } else {
            this.properties.setProperty("TASKTYPE", "Dummy");
        }
    }

    private void setSAPProperties(String action) {
        if (action.equalsIgnoreCase("run_copy")) {
            this.properties.setProperty("TASKTYPE", "Job");
            Globs.SAP_TYPE_FORM_VERSION.forEach(this::setOptionalAttribute);
            AttrHolderList paramList = CsvTablesManager.get(CsvTablesManager.TableName.RWS_PAR).getAttrHoldersList("OBJ#", this.entityData.getAttr("OBJ#"));
            for (IAttrHolder param : paramList) {
                String targetServer;
                if (param.getAttr("NAME").equals("SOURCE_JOBNAME")) {
                    this.autoedits.put("%%SAPR3-JOBNAME", param.getAttr("DEFAULT$").replaceAll(".*'(.*?)'.*", "$1"));
                    continue;
                }
                if (param.getAttr("NAME").equals("SOURCE_JOBCOUNT")) {
                    this.autoedits.put("%%SAPR3-JOBCOUNT", param.getAttr("DEFAULT$").replaceAll(".*'(.*?)'.*", "$1"));
                    continue;
                }
                if (param.getAttr("NAME").equals("STEP_NUMBER")) {
                    Integer startStep = param.getAttrAsInt("DEFAULT$");
                    if (startStep == null) continue;
                    this.autoedits.put("%%SAPR3-START_STEP", String.valueOf(startStep));
                    continue;
                }
                if (param.getAttr("NAME").equals("TARGET_JOBNAME")) {
                    String newJobName = param.getAttr("DEFAULT$").replaceAll(".*'(.*?)'.*", "$1");
                    if (newJobName.isEmpty()) continue;
                    this.autoedits.put("%%SAPR3-JOB_COPY_TARGET_VAL", newJobName);
                    continue;
                }
                if (!param.getAttr("NAME").equals("TARGET_SERVER") || (targetServer = param.getAttr("DEFAULT$").replaceAll(".*'(.*?)'.*", "$1")).isEmpty()) continue;
                this.autoedits.put("%%SAPR3-TARGET_SERVER", targetServer);
            }
            String sapAccount = "";
            AttrHolderList jobs = CsvTablesManager.get(CsvTablesManager.TableName.RWS_JOB).getAttrHoldersList("OBJ#", this.entityData.getAttr("OBJ#"));
            if (!jobs.isEmpty()) {
                sapAccount = ((IAttrHolder)jobs.get(0)).getAttr("SCH$NAME");
            }
            if (sapAccount.isEmpty()) {
                sapAccount = "DEFAULT_ACCOUNT";
            }
            this.properties.setProperty("OWNER", sapAccount);
            this.properties.setProperty("MEMNAME", this.getJobName());
            this.properties.setProperty("MEMLIB", "Not in use for SAP jobs");
            this.autoedits.put("%%SAPR3-ACCOUNT", sapAccount);
            this.autoedits.put("%%SAPR3-JOB_MODE", "RUN_COPY");
            this.autoedits.put("%%SAPR3-JOB_COUNT", "Specific_Job");
        } else {
            Reporter.addMessage(this.messages, (String)"WRN14010", (String)this.getTablePathForSons(), (String[])new String[]{action});
        }
    }

    private void setToDummy() {
        if (!Params.instance().getGUIVersion().equals("7") && !this.properties.getProperty("TASKTYPE").equals("Dummy")) {
            if (null == this.autoedits) {
                this.autoedits = new LinkedHashMap();
            }
            this.autoedits.put("%%$BMCWAIORIGTYPE", this.properties.getProperty("TASKTYPE"));
        }
        this.properties.setProperty("TASKTYPE", "Dummy");
    }

    private void addSchedulingAttributes(String name, SchedulingConverter.SchedlingAttributes attributes, boolean appendRbc) {
        if (attributes != null) {
            Map<String, List<String[]>> schedulingMessages;
            Properties jobAttributes;
            Properties rbc;
            List<Properties> rbcList = attributes.getRbcs();
            if (rbcList != null) {
                this.rbcs.addAll(rbcList);
            }
            if ((rbc = attributes.getRbc()) != null && (this.rbcs.isEmpty() || appendRbc)) {
                this.rbcs.add(rbc);
            }
            if ((jobAttributes = attributes.getJobAttributes()) != null) {
                this.properties.putAll((Map<?, ?>)jobAttributes);
                if (!appendRbc && this.type() != SchedEntity.TYPE.JOB && jobAttributes.containsKey("CYCLIC")) {
                    Reporter.addMessage(this.messages, (String)"WRN14009", (String)this.getTablePathForSons(), (String[])new String[]{name});
                }
            }
            if ((schedulingMessages = attributes.getMessages()) != null && !schedulingMessages.isEmpty()) {
                for (String msgID : schedulingMessages.keySet()) {
                    for (String[] params : schedulingMessages.get(msgID)) {
                        Reporter.addMessage(this.messages, (String)msgID, (String)this.getTablePathForSons(), (String[])params);
                    }
                }
            }
        }
    }

    private void setOptionalAttribute(String name, String value) {
        if (!this.optionalProperties.contains(name)) {
            this.optionalProperties.add(name);
        }
        this.properties.setProperty(name, value);
    }

    public SchedEntity.TYPE type() {
        return this.entityType;
    }

    public String originalProductID() {
        return null;
    }

    public List<SchedEntity> getChildren() {
        if (this.entityType != SchedEntity.TYPE.JOB && this.children == null) {
            this.children = new ArrayList();
            if (this.entityData != null) {
                AttrHolderList steps = CsvTablesManager.get(CsvTablesManager.TableName.RWS_STEP).getAttrHoldersList("OBJ#", this.entityData.getAttr("OBJ#"));
                for (IAttrHolder step : steps) {
                    this.children.add(new RedwoodJob(step, this));
                }
            } else if (this.stepData != null) {
                Properties select = new Properties();
                select.put("OBJ#", this.stepData.getAttr("OBJ#"));
                select.put("STEP#", this.stepData.getAttr("STEP#"));
                AttrHolderList jobs = CsvTablesManager.get(CsvTablesManager.TableName.RWS_CALL).getAttrHoldersList(select);
                for (IAttrHolder job : jobs) {
                    IAttrHolder jobData = (IAttrHolder)CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ).getAttrHoldersList("OBJ#", job.getAttr("C_OBJ#")).get(0);
                    this.children.add(new RedwoodJob(SchedEntity.TYPE.JOB, jobData, this));
                }
            } else {
                ConversionLogger.getLogger().info(this.getOriginalJobName() + " has no definition data");
            }
        }
        return this.children;
    }

    public List<AssistingJob> getAssistingJobs() {
        return this.assistingJobs;
    }

    public String getAttr(String attrName) {
        return this.properties.getProperty(attrName);
    }

    private void generateConditions() {
        AttrHolderList parentSteps;
        this.inConds = new ArrayList();
        this.outConds = new ArrayList();
        if (this.stepData != null && (parentSteps = CsvTablesManager.get(CsvTablesManager.TableName.RWS_STEP).getAttrHoldersList("OBJ#", this.stepData.getAttr("OBJ#"))).size() > 1) {
            int currSeq = Integer.valueOf(this.stepData.getAttr("SEQ#"));
            String predecessorName = "";
            int predecessorSeq = 0;
            for (IAttrHolder step : parentSteps) {
                int tmpSeq = Integer.valueOf(step.getAttr("SEQ#"));
                if (currSeq - 1 != tmpSeq) continue;
                predecessorSeq = tmpSeq;
                predecessorName = step.getAttr("STEPNAME");
                break;
            }
            if (predecessorSeq > 0) {
                Properties inCond = new Properties();
                inCond.setProperty("NAME", FieldValidation.instance().validateAndReturnFixedValue("NAME", this.entityParent.getJobName() + "@" + predecessorName + "_" + predecessorSeq));
                inCond.setProperty("AND_OR", "AND");
                inCond.setProperty("ODATE", "ODAT");
                this.inConds.add(inCond);
            }
            Properties outCond = new Properties();
            outCond.setProperty("NAME", FieldValidation.instance().validateAndReturnFixedValue("NAME", this.entityParent.getJobName() + "@" + this.stepData.getAttr("STEPNAME") + "_" + currSeq));
            outCond.setProperty("SIGN", "ADD");
            outCond.setProperty("ODATE", "ODAT");
            this.outConds.add(outCond);
        }
    }

    public List<Properties> getInConds() {
        return this.inConds;
    }

    public List<Properties> getOutConds() {
        return this.outConds;
    }

    public List<Properties> getTags() {
        return this.rbcs;
    }

    public List<Properties> getQuantResources() {
        return null;
    }

    public List<Properties> getCtrlResources() {
        return null;
    }

    public List<Properties> getOnStmt() {
        return this.onStmts;
    }

    public LinkedHashMap<Properties, List<Properties>> getOnDoStmt() {
        return null;
    }

    public List<Properties> getShouts() {
        return null;
    }

    public String getJobName() {
        return this.properties.getProperty("JOBNAME");
    }

    public String getOriginalJobName() {
        String jobName = "";
        if (this.entityData != null) {
            jobName = this.entityData.getAttr("NAME");
        } else if (this.stepData != null) {
            jobName = this.stepData.getAttr("STEPNAME");
        }
        return jobName;
    }

    public String getParentName() {
        if (this.validatedParentName == null) {
            this.validatedParentName = this.calculateAndValidateParentName();
        }
        return this.validatedParentName;
    }

    public SchedEntity getParent() {
        return this.entityParent;
    }

    private String calculateAndValidateParentName() {
        if (this.entityParent != null) {
            if (this.entityType == SchedEntity.TYPE.JOB) {
                return this.entityParent.getParentName();
            }
            if (this.entityType == SchedEntity.TYPE.SUB_TABLE) {
                return this.entityParent.getParentName() + "/" + this.getJobName();
            }
        } else if (this.type() == SchedEntity.TYPE.JOB) {
            String objectID = this.entityData.getAttr("OBJ#");
            AttrHolderList jobData = CsvTablesManager.get(CsvTablesManager.TableName.RWS_JOB).getAttrHoldersList("OBJ#", objectID);
            if (jobData == null || jobData.isEmpty() || ((IAttrHolder)jobData.get(0)).getAttr("WIN$NAME").isEmpty() && ((IAttrHolder)jobData.get(0)).getAttr("SUB$NAME").isEmpty()) {
                this.properties.setProperty("TABLE_USERDAILY", "ON_DEMAND");
                this.properties.setProperty("STANDALONE_TABLE_NAME", "StandAloneJobs_ON_DEMAND");
            }
            if (this.uniqueTableOrParentName == null) {
                this.uniqueTableOrParentName = RedwoodDefs.getUniqueTableName(this.getJobName(), false);
            }
        } else {
            this.uniqueTableOrParentName = this.getJobName();
        }
        return FieldValidation.instance().validateAndReturnFixedValue("TABLE_NAME", this.uniqueTableOrParentName, true, "OBJ#", this.getOriginalJobName(), this.getMessages());
    }

    public String getTablePathForSons() {
        return this.getParentName() + (String)(this.entityParent != null && this.entityType == SchedEntity.TYPE.JOB ? "/" + this.getJobName() : "");
    }

    public boolean isValid() {
        return this.validEntity;
    }

    public boolean hasWarnings() {
        if (this.messages.isEmpty()) {
            return false;
        }
        HashMap messageIds = MessageIdTable.instance().getMessageIds();
        for (String id : messageIds.keySet()) {
            if (!((MessageId)messageIds.get(id)).getMessageType(id).equals("W")) continue;
            for (String currMessage : this.messages) {
                if (!currMessage.startsWith(id)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean hasMessages() {
        return !this.messages.isEmpty();
    }

    public boolean isDSJob() {
        return true;
    }

    public String getTableName() {
        return this.getJobName();
    }

    public boolean isCyclic() {
        String cyclic = this.properties.getProperty("CYCLIC");
        if (cyclic == null) {
            return false;
        }
        return cyclic.equals("1");
    }

    public String applyFieldConversion(String field) {
        return null;
    }

    public String getApplication() {
        return this.properties.getProperty("APPLICATION");
    }

    public String getGroup() {
        return this.properties.getProperty("GROUP");
    }

    public LinkedHashMap<String, String> getAutoedits() {
        return this.autoedits;
    }

    public List<String> getOptionalAttributes() {
        return this.optionalProperties;
    }

    public ArrayList<String> getMessages() {
        return this.messages;
    }
}

