/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwood;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.dataimport.Importer;
import com.bmc.ctmconvert.io.csv.CsvReader;
import com.bmc.ctmconvert.io.csv.CsvWriter;
import com.bmc.ctmconvert.progress.Progressable;
import com.bmc.ctmconvert.redwood.CsvTablesManager;
import com.bmc.ctmconvert.services.ConversionEntitiesService;
import java.io.BufferedInputStream;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;

public class RedwoodImporter
extends Importer {
    public Progressable.ProgressStatus performImport() {
        Progressable.ProgressStatus tmpStatus = Progressable.ProgressStatus.ENDED_FAILURE;
        String inputDirectory = ConversionEntitiesService.getCurrentProjectDataDirectory();
        String inputBase = inputDirectory + CsvTablesManager.TableName.RWS_JOB.toString();
        String input = String.format("%s%s", inputBase, ".csv");
        String inputBackup = String.format("%s_ORIG%s", inputBase, ".csv");
        try (FileInputStream fileInputStream = new FileInputStream(inputBackup);
             BufferedInputStream inputStream = new BufferedInputStream(fileInputStream);){
            byte[] buffer = new byte[1024];
            int readChars = 0;
            int recordCount = 0;
            while ((readChars = ((InputStream)inputStream).read(buffer)) != -1) {
                for (int i = 0; i < readChars; ++i) {
                    if (buffer[i] != 10) continue;
                    ++recordCount;
                }
            }
            this.setProgressMax(recordCount);
            try (CsvReader origTableReader = new CsvReader(inputBackup);
                 CsvWriter distinctTableWriter = new CsvWriter(input);){
                ArrayList<String> IDs = new ArrayList<String>();
                int objIDIndex = 2;
                int stepIDIndex = 54;
                origTableReader.readHeaders();
                String[] headers = origTableReader.getHeaders();
                distinctTableWriter.writeRecord(headers);
                for (int index = 0; index < headers.length; ++index) {
                    if (headers[index].equals("OBJ#")) {
                        objIDIndex = index;
                        continue;
                    }
                    if (!headers[index].equals("STEP$")) continue;
                    stepIDIndex = index;
                }
                recordCount = 0;
                while (origTableReader.readRecord()) {
                    ++recordCount;
                    String[] record = origTableReader.getValues();
                    if (record[stepIDIndex].isEmpty() && !IDs.contains(record[objIDIndex])) {
                        IDs.add(record[objIDIndex]);
                        distinctTableWriter.writeRecord(record);
                    }
                    this.setCurrentProgress(recordCount);
                }
            }
            tmpStatus = Progressable.ProgressStatus.ENDED_SUCCESS;
        }
        catch (IOException e1) {
            ConversionLogger.getLogger().severe(e1.getMessage());
            tmpStatus = Progressable.ProgressStatus.ENDED_FAILURE;
        }
        if (this.isStopped()) {
            tmpStatus = Progressable.ProgressStatus.ENDED_STOPED;
        }
        this.setStatus(tmpStatus);
        return this.getStatus();
    }

    public String getTitle() {
        return "Create filtered RWS_JOB table";
    }

    public String getID() {
        return "RWS_JOB";
    }
}

