/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwood;

import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.SchedEntity;
import com.bmc.ctmconvert.common.SourceDefinitions;
import com.bmc.ctmconvert.common.exceptions.ConvertorCancelClickException;
import com.bmc.ctmconvert.redwood.CsvTablesManager;
import com.bmc.ctmconvert.redwood.RedwoodJob;
import com.bmc.ctmconvert.redwood.SchedulingConverter;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.utils.UniqueValueGenerator;
import com.csvreader.CsvWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Properties;
import java.util.Set;

public class RedwoodDefs
implements SourceDefinitions {
    private AttrHolderList top_level_parents;
    private ArrayList<String> messages = new ArrayList();
    private RulesDataSet rules;
    private static UniqueValueGenerator uniqueValue;

    public RedwoodDefs() {
        RedwoodJob.uniqueNumber = 1;
        this.rules = RuleManager.instance().getCurrentRules();
        uniqueValue = new UniqueValueGenerator();
    }

    public static String getUniqueTableName(String name, boolean update) {
        return uniqueValue.getUniqueValue("TABLE_NAME", name, 64, "#", update);
    }

    public AttrHolderList getTopLevelEntities() {
        this.top_level_parents = new AttrHolderList();
        HashMap<String, String> filterDetails = new HashMap<String, String>();
        AttrHolderList items = CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ).getAttrHoldersList("TYPE", "3");
        for (IAttrHolder item : items) {
            filterDetails.put("Chain name", item.getAttr("NAME"));
            if (!this.rules.getFilterHandler().isFilter(filterDetails)) continue;
            this.top_level_parents.add((Object)item);
        }
        filterDetails.put("Chain name", "");
        if (this.rules.getFilterHandler().isFilter(filterDetails)) {
            items = CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ).getAttrHoldersList();
            for (IAttrHolder item : items) {
                String objectType = item.getAttr("TYPE");
                String objectID = item.getAttr("OBJ#");
                if (objectType.equals("3") || !CsvTablesManager.get(CsvTablesManager.TableName.RWS_CALL).getAttrHoldersList("C_OBJ#", objectID).isEmpty()) continue;
                this.top_level_parents.add((Object)item);
            }
        }
        return this.top_level_parents;
    }

    public static HashMap<String, String> getVendorDetaildForConfiguration(IAttrHolder data) {
        HashMap<String, String> toRet = new HashMap<String, String>();
        toRet.put("Name", data.getAttr("NAME"));
        toRet.put("Application", data.getAttr("APP$NAME"));
        toRet.put("Queue", data.getAttr("QUE$NAME"));
        toRet.put("Schedule", data.getAttr("SCT$NAME"));
        toRet.put("Owner", data.getAttr("OWNER"));
        toRet.put("Description", data.getAttr("DESCRIPTION"));
        return toRet;
    }

    public AttrHolderList getChildren(String parentEntityId) {
        return null;
    }

    public void finalize_() {
        SchedulingConverter.destroy();
        CsvWriter writer = new CsvWriter(Globs.TEMP_EVALUATION_DIR + Globs.DIRSEP + "RedwoodEvents.csv");
        try {
            String[] header = new String[]{"EVENT_ID", "EVENT_NAME", "JOB_ID", "JOB_NAME", "FILE_NAME", "CHECK_INTERVAL"};
            writer.writeRecord(header);
            AttrHolderList allEvents = CsvTablesManager.get(CsvTablesManager.TableName.RWS_EVT).getAttrHoldersList();
            for (IAttrHolder event : allEvents) {
                AttrHolderList allJobsForEvent;
                String[] row = new String[header.length];
                row[0] = event.getAttr("OBJ#");
                row[1] = event.getAttr("NAME");
                row[4] = event.getAttr("R_FILENAME");
                AttrHolderList additionalEventData = CsvTablesManager.get(CsvTablesManager.TableName.RWS_SEVT).getAttrHoldersList("EVT$NAME", row[1]);
                if (additionalEventData != null && additionalEventData.size() == 1) {
                    row[5] = ((IAttrHolder)additionalEventData.get(0)).getAttr("CHK_INT");
                }
                if ((allJobsForEvent = CsvTablesManager.get(CsvTablesManager.TableName.RWS_OWEVT).getAttrHoldersList("EVT$NAME", row[1])) != null && allJobsForEvent.size() > 0) {
                    for (IAttrHolder jobEvent : allJobsForEvent) {
                        row[2] = jobEvent.getAttr("OBJ#");
                        row[3] = ((IAttrHolder)CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ).getAttrHoldersList("OBJ#", row[2]).get(0)).getAttr("NAME");
                        writer.writeRecord(row);
                    }
                    continue;
                }
                writer.writeRecord(row);
            }
            writer.close();
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile((Exception)e);
        }
    }

    public void init() throws ConvertorCancelClickException {
        SchedulingConverter.instance();
    }

    public SchedEntity spawnJob(String table, IAttrHolder attributes) {
        RedwoodJob toRet = null;
        toRet = attributes.getAttr("TYPE").equals("3") ? new RedwoodJob(SchedEntity.TYPE.SMART_TABLE, attributes) : new RedwoodJob(SchedEntity.TYPE.JOB, attributes);
        return toRet;
    }

    public SchedEntity spawnJob(SchedEntity parent, IAttrHolder attributes) {
        return null;
    }

    public String getIdFieldName() {
        return "OBJ#";
    }

    public String getEntNameFieldName() {
        return null;
    }

    public String getParentEntFieldName() {
        return null;
    }

    public boolean hasChildren(String entId) {
        return false;
    }

    public void createDependencies(String root) {
    }

    public void applyFilter(String root) {
    }

    public List<Properties> getJobInconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOutconds(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobOnstmts(SchedEntity job) {
        return null;
    }

    public List<Properties> getJobControlRes(SchedEntity job) {
        return null;
    }

    public Set<Properties> createTags(String root) {
        return null;
    }

    public boolean isStandAloneGrouped() {
        return this.rules.getStringRule("", new String[]{"GROUP_STANDALONE_JOBS_IN_ONE_TABLE"}).equals("OneTable");
    }

    public boolean isContainerEntity(IAttrHolder entAttr) {
        return entAttr.getAttr("TYPE").equals("3");
    }

    public ArrayList<String> getGeneralMessages() {
        return this.messages;
    }
}

