/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwood;

import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.AttrHolderList;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.IAttrHolder;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.redwood.CsvTable;
import com.bmc.ctmconvert.redwood.CsvTablesManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Properties;
import javax.swing.tree.DefaultMutableTreeNode;

public class RedwoodAssessmentReport
extends AbstractAssessmentReport {
    private final String redwoodTableDataTitle = "Redwood Tables Data";
    private final String redwoodHierarchyTreeTitle = "Redwood Hierarchy Tree";
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private HashMap<String, String> currJobParamsDescription = new HashMap();

    public RedwoodAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        DefaultMutableTreeNode root = new DefaultMutableTreeNode(Params.instance().getDatasourceName());
        root.add(this.getTablesData());
        root.add(this.getHierarchyTree());
        return root;
    }

    private DefaultMutableTreeNode getTablesData() {
        DefaultMutableTreeNode redwoodTables = new DefaultMutableTreeNode("Redwood Tables Data");
        for (CsvTablesManager.TableName table : CsvTablesManager.TableName.values()) {
            if (table == CsvTablesManager.TableName.RWS_SEL) {
                redwoodTables.add(this.getTablesChilds(table, "SUB$NAME"));
                continue;
            }
            if (table == CsvTablesManager.TableName.RWS_WEL) {
                redwoodTables.add(this.getTablesChilds(table, "WIN$NAME"));
                continue;
            }
            if (table == CsvTablesManager.TableName.RWS_JOB || table == CsvTablesManager.TableName.RWS_OBJ || table == CsvTablesManager.TableName.RWS_EVT) {
                redwoodTables.add(this.getTablesChilds(table, "NAME"));
                continue;
            }
            if (table == CsvTablesManager.TableName.RWS_PAR || table == CsvTablesManager.TableName.RWS_SRC) {
                redwoodTables.add(this.getMultiLineNames(table));
                continue;
            }
            if (table == CsvTablesManager.TableName.RWS_STEP || table == CsvTablesManager.TableName.RWS_CALL || table != CsvTablesManager.TableName.RWS_SEVT && table != CsvTablesManager.TableName.RWS_OWEVT) continue;
            redwoodTables.add(this.getTablesChilds(table, "EVT$NAME"));
        }
        return redwoodTables;
    }

    private DefaultMutableTreeNode getTablesChilds(CsvTablesManager.TableName table, String childNameKey) {
        AttrHolderList childsList = CsvTablesManager.get(table).getAttrHoldersList();
        DefaultMutableTreeNode tableData = new DefaultMutableTreeNode(table.toString() + " (" + childsList.size() + ")");
        for (IAttrHolder record : childsList) {
            tableData.add(new DefaultMutableTreeNode(record.getAttr(childNameKey)));
        }
        return tableData;
    }

    private DefaultMutableTreeNode getMultiLineNames(CsvTablesManager.TableName table) {
        ArrayList<String> IDs = new ArrayList<String>();
        DefaultMutableTreeNode tableData = new DefaultMutableTreeNode(table.toString());
        AttrHolderList childsList = CsvTablesManager.get(table).getAttrHoldersList();
        for (IAttrHolder record : childsList) {
            String id = record.getAttr(table.getTableIDKey());
            if (IDs.contains(id)) continue;
            IDs.add(id);
            AttrHolderList job = CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ).getAttrHoldersList("OBJ#", id);
            tableData.add(new DefaultMutableTreeNode(((IAttrHolder)job.get(0)).getAttr("NAME")));
        }
        tableData.setUserObject(String.valueOf(tableData.getUserObject()) + " (" + tableData.getChildCount() + ")");
        return tableData;
    }

    private DefaultMutableTreeNode getHierarchyTree() {
        DefaultMutableTreeNode toRet = new DefaultMutableTreeNode("Redwood Hierarchy Tree");
        CsvTable objTable = CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ);
        CsvTable stepTable = CsvTablesManager.get(CsvTablesManager.TableName.RWS_STEP);
        CsvTable callTable = CsvTablesManager.get(CsvTablesManager.TableName.RWS_CALL);
        AttrHolderList chains = objTable.getAttrHoldersList("TYPE", "3");
        for (IAttrHolder chain : chains) {
            DefaultMutableTreeNode chainTree = new DefaultMutableTreeNode(chain.getAttr("NAME"));
            AttrHolderList steps = stepTable.getAttrHoldersList("OBJ#", chain.getAttr("OBJ#"));
            for (IAttrHolder step : steps) {
                DefaultMutableTreeNode stepTree = new DefaultMutableTreeNode(step.getAttr("STEPNAME"));
                Properties select = new Properties();
                select.put("OBJ#", step.getAttr("OBJ#"));
                select.put("STEP#", step.getAttr("STEP#"));
                AttrHolderList jobs = callTable.getAttrHoldersList(select);
                for (IAttrHolder job : jobs) {
                    stepTree.add(new DefaultMutableTreeNode(job.getAttr("OBJ$NAME")));
                }
                chainTree.add(stepTree);
            }
            toRet.add(chainTree);
        }
        return toRet;
    }

    protected String getJobInfo(String messageID) {
        String[] messagePartArray = messageID.split(";");
        String rootName = null;
        String nodeName = null;
        String entityName = null;
        Object message = null;
        if (messageID == null || messageID.isEmpty()) {
            return "";
        }
        if (messagePartArray.length > 1) {
            rootName = messagePartArray[1];
            if (messagePartArray[1].endsWith(")")) {
                rootName = messagePartArray[1].substring(0, messagePartArray[2].lastIndexOf(" ("));
            }
        }
        if (messagePartArray.length > 2 && messagePartArray[2].endsWith(")")) {
            nodeName = messagePartArray[2];
            if (messagePartArray[2].endsWith(")")) {
                nodeName = messagePartArray[2].substring(0, messagePartArray[2].lastIndexOf(" ("));
            }
        }
        if (messagePartArray.length >= 3) {
            entityName = messagePartArray[messagePartArray.length - 1];
        }
        if (rootName.equals("Redwood Tables Data")) {
            if (messagePartArray.length == 3 && entityName.endsWith(")")) {
                entityName = entityName.substring(0, entityName.lastIndexOf(" ("));
            }
            if (entityName != null && !entityName.isEmpty()) {
                if (messagePartArray.length > 3) {
                    try {
                        CsvTablesManager.TableName table = CsvTablesManager.TableName.valueOf(nodeName);
                        if (table == CsvTablesManager.TableName.RWS_SEL) {
                            message = this.getJobInfo((IAttrHolder)CsvTablesManager.get(table).getAttrHoldersList("SUB$NAME", entityName).get(0));
                        } else if (table == CsvTablesManager.TableName.RWS_WEL) {
                            message = this.getJobInfo((IAttrHolder)CsvTablesManager.get(table).getAttrHoldersList("WIN$NAME", entityName).get(0));
                        } else if (table == CsvTablesManager.TableName.RWS_JOB || table == CsvTablesManager.TableName.RWS_OBJ) {
                            message = this.getJobInfo((IAttrHolder)CsvTablesManager.get(table).getAttrHoldersList("NAME", entityName).get(0));
                        } else if (table != CsvTablesManager.TableName.RWS_PAR) {
                            if (table == CsvTablesManager.TableName.RWS_SRC) {
                                AttrHolderList job = CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ).getAttrHoldersList("NAME", entityName);
                                AttrHolderList srcList = CsvTablesManager.get(CsvTablesManager.TableName.RWS_SRC).getAttrHoldersList("OBJ#", ((IAttrHolder)job.get(0)).getAttr("OBJ#"));
                                StringBuilder embeddedScript = new StringBuilder();
                                String[] orderedScript = new String[srcList.size() + 1];
                                for (IAttrHolder srcLine : srcList) {
                                    Integer lineNum = srcLine.getAttrAsInt("LINE");
                                    if (lineNum == null) continue;
                                    orderedScript[lineNum.intValue()] = srcLine.getAttr("SOURCE");
                                }
                                for (String line : orderedScript) {
                                    if (line == null) continue;
                                    embeddedScript.append(line).append("\n");
                                }
                                message = embeddedScript.toString();
                            } else if (table != CsvTablesManager.TableName.RWS_STEP && table != CsvTablesManager.TableName.RWS_CALL) {
                                if (table == CsvTablesManager.TableName.RWS_EVT) {
                                    message = this.getJobInfo((IAttrHolder)CsvTablesManager.get(table).getAttrHoldersList("NAME", entityName).get(0));
                                } else if (table == CsvTablesManager.TableName.RWS_SEVT || table == CsvTablesManager.TableName.RWS_OWEVT) {
                                    message = this.getJobInfo((IAttrHolder)CsvTablesManager.get(table).getAttrHoldersList("EVT$NAME", entityName).get(0));
                                }
                            }
                        }
                    }
                    catch (IllegalArgumentException e) {
                        ExceptionHandler.writeToExceptionFile((Exception)e);
                    }
                } else {
                    message = entityName + "\n";
                }
            }
        } else if (rootName.equals("Redwood Hierarchy Tree")) {
            if (messagePartArray.length >= 3 && entityName.endsWith(")")) {
                entityName = entityName.substring(0, entityName.lastIndexOf(" ("));
            }
            message = messagePartArray.length == 4 ? this.getJobInfo((IAttrHolder)CsvTablesManager.get(CsvTablesManager.TableName.RWS_STEP).getAttrHoldersList("STEPNAME", entityName).get(0)) : this.getJobInfo((IAttrHolder)CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ).getAttrHoldersList("NAME", entityName).get(0));
        }
        return message;
    }

    private String getJobInfo(IAttrHolder data) {
        Object jobInfo = "";
        if (data != null) {
            String[] header = data.getCsvHeader().split(",");
            for (int index = 0; index < header.length; ++index) {
                jobInfo = (String)jobInfo + String.format("%-40s\t: %s%s", header[index], data.getAttr(header[index]), "\n");
            }
        }
        return jobInfo;
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add("Redwood Tables Data");
        toRet.add("Redwood Hierarchy Tree");
        return toRet;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        toRet.add(CsvTablesManager.TableName.RWS_PAR.toString());
        return toRet;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        ArrayList<String> toRet = new ArrayList<String>();
        String[] messagePartArray = parentNodeID.split(";");
        String entityName = messagePartArray[messagePartArray.length - 1];
        AttrHolderList job = CsvTablesManager.get(CsvTablesManager.TableName.RWS_OBJ).getAttrHoldersList("NAME", entityName);
        AttrHolderList paramList = CsvTablesManager.get(CsvTablesManager.TableName.RWS_PAR).getAttrHoldersList("OBJ#", ((IAttrHolder)job.get(0)).getAttr("OBJ#"));
        for (IAttrHolder param : paramList) {
            toRet.add(param.getAttr("NAME"));
            this.currJobParamsDescription.put(param.getAttr("NAME"), this.getJobInfo(param));
        }
        return toRet;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        return descriptionMap_NodeName_NodeDesc;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return this.currJobParamsDescription.get(messageID);
    }
}

