/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.redwood;

import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.redwood.CsvJobsTable;
import com.bmc.ctmconvert.redwood.CsvTable;
import java.util.HashMap;

public class CsvTablesManager {
    private static String datasourcePath = "";
    private static HashMap<TableName, CsvTable> tables = new HashMap();

    private CsvTablesManager() {
    }

    public static CsvTable get(TableName table) {
        CsvTable csvTable;
        String path = Params.instance().getDatasourcePath();
        if (!path.equals(datasourcePath)) {
            CsvTablesManager.clear();
            datasourcePath = path;
        }
        if ((csvTable = tables.get((Object)table)) == null) {
            csvTable = table == TableName.RWS_JOB ? new CsvJobsTable(CsvTablesManager.getTableProperties(table)) : new CsvTable(CsvTablesManager.getTableProperties(table));
            tables.put(table, csvTable);
        }
        return csvTable;
    }

    public static void clear() {
        tables = new HashMap();
    }

    public static void clear(TableName table) {
        tables.remove((Object)table);
    }

    private static String getTableProperties(TableName table) {
        return datasourcePath + table.toString() + ".csv";
    }

    public static enum TableName {
        RWS_OBJ("OBJ#"),
        RWS_STEP("OBJ#"),
        RWS_CALL("OBJ#"),
        RWS_PAR("OBJ#"),
        RWS_SRC("OBJ#"),
        RWS_JOB("OBJ#"),
        RWS_SEL("SUB$NAME"),
        RWS_WEL("WIN$NAME"),
        RWS_EVT("OBJ#"),
        RWS_SEVT("EVT$NAME"),
        RWS_OWEVT("OBJ#");

        private final String tableIDKey;

        private TableName(String tableIDKey) {
            this.tableIDKey = tableIDKey;
        }

        public String getTableIDKey() {
            return this.tableIDKey;
        }
    }
}

