/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.applications;

import com.bmc.ctmconvert.applications.ApplicationsEntitiy;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Params;
import java.io.File;
import java.util.ArrayList;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ApplicationsHierarchyTree {
    private static ApplicationsHierarchyTree instance;
    private static String datasource;
    private ArrayList<String> entitiesIndexes = new ArrayList();
    private ApplicationsEntitiy root;
    private Properties genericJobsProperties = new Properties();
    private static String defaultFolder;
    private static boolean folderOverrideFlag;

    public static ApplicationsHierarchyTree instance() {
        String datasourceName = Params.instance().getDatasourceName();
        if (instance == null || !datasourceName.equals(datasource)) {
            instance = new ApplicationsHierarchyTree();
            datasource = datasourceName;
        }
        return instance;
    }

    public static void destroy() {
        instance = null;
        datasource = "";
        defaultFolder = "DEFAULT_FOLDER";
        folderOverrideFlag = false;
    }

    public static void setDefaultFolder(String folderName) {
        defaultFolder = folderName;
    }

    public static void setFolderOverrideFlag(boolean flag) {
        folderOverrideFlag = flag;
    }

    private ApplicationsHierarchyTree() {
        this.root = new ApplicationsEntitiy(String.format("%s Hierarchy tree", Params.instance().getVendorName()));
        ArrayList<File> dataFilesList = ApplicationsHierarchyTree.getDataFilesList();
        for (File dataFile : dataFilesList) {
            try {
                DocumentBuilder parser = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = parser.parse(dataFile);
                NamedNodeMap applicationJobsAttributes = document.getElementsByTagName("ApplicationJobs").item(0).getAttributes();
                for (int i = 0; i < applicationJobsAttributes.getLength(); ++i) {
                    Node attribute = applicationJobsAttributes.item(i);
                    this.genericJobsProperties.put(attribute.getNodeName(), attribute.getNodeValue());
                }
                NodeList applicationJobs = document.getElementsByTagName("JobData");
                for (int i = 0; i < applicationJobs.getLength(); ++i) {
                    Element jobData = (Element)applicationJobs.item(i);
                    String folderName = jobData.getAttribute("FOLDER");
                    String jobName = jobData.getAttribute("JOBNAME");
                    if (defaultFolder != null && !defaultFolder.isEmpty() && (folderOverrideFlag || folderName.isEmpty())) {
                        folderName = defaultFolder;
                    }
                    ApplicationsEntitiy folder = null;
                    if (this.entitiesIndexes.contains(folderName)) {
                        folder = (ApplicationsEntitiy)this.root.getChildAt(this.entitiesIndexes.indexOf(folderName));
                    } else {
                        folder = new ApplicationsEntitiy(folderName);
                        this.root.add(folder);
                        this.entitiesIndexes.add(this.root.getIndex(folder), folderName);
                    }
                    ApplicationsEntitiy job = new ApplicationsEntitiy(jobName, jobData);
                    folder.add(job);
                }
            }
            catch (Exception e) {
                ExceptionHandler.writeToExceptionFile((Exception)e);
            }
        }
    }

    public ApplicationsEntitiy getHierarchyTree() {
        return this.root;
    }

    public Properties getGenericJobsProperties() {
        return this.genericJobsProperties;
    }

    public static ArrayList<File> getDataFilesList() {
        String dataFilePrefix = String.format("%sData", Params.instance().getVendorName());
        ArrayList<File> results = new ArrayList<File>();
        File[] files = new File(Params.instance().getDatasourcePath()).listFiles();
        if (files != null) {
            for (File file : files) {
                if (!file.isFile() || !file.getName().startsWith(dataFilePrefix) || !file.getName().endsWith(".xml")) continue;
                results.add(file);
            }
        }
        return results;
    }

    public static void setApplicationsHierarchyTree(ApplicationsHierarchyTree _instance) {
        instance = _instance;
    }

    public static void setDatasource(String _datasource) {
        datasource = _datasource;
    }

    static {
        datasource = "";
        defaultFolder = "DEFAULT_FOLDER";
        folderOverrideFlag = false;
    }
}

