/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.applications;

import com.bmc.ctmconvert.applications.ApplicationsEntitiy;
import com.bmc.ctmconvert.applications.ApplicationsHierarchyTree;
import com.bmc.ctmconvert.base.AbstractAssessmentReport;
import com.bmc.ctmconvert.common.AssessmentXMLDescriptionReader;
import com.bmc.ctmconvert.common.Params;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.tree.DefaultMutableTreeNode;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class ApplicationsAssessmentReport
extends AbstractAssessmentReport {
    private AssessmentXMLDescriptionReader m_DescriptionXMLReader;
    private DefaultMutableTreeNode root;
    private Pattern parametersPattern = Pattern.compile("(#\\S+#)");
    private static final String SECTION_SEPARETOR = "---------------------------------------------------------------------------- \n";

    public ApplicationsAssessmentReport(String pathName, String descriptionXMLFileName, String optionalFile) {
        super(pathName, descriptionXMLFileName, optionalFile);
    }

    protected void initSourceData(String pathName, String descriptionXMLFileName, String optionalFile) {
        this.m_DescriptionXMLReader = new AssessmentXMLDescriptionReader(descriptionXMLFileName, Params.instance().getVendorName());
    }

    protected DefaultMutableTreeNode getDefaultTreeModel() {
        if (this.root == null) {
            this.root = ApplicationsHierarchyTree.instance().getHierarchyTree();
        }
        return this.root;
    }

    protected String getJobInfo(String messageID) {
        return null;
    }

    protected String getJobInfo(DefaultMutableTreeNode node) {
        String message = null;
        if (node != null && node.getClass().equals(ApplicationsEntitiy.class)) {
            message = this.getJobInfo(((ApplicationsEntitiy)node).getEntityData());
        }
        return message;
    }

    private String getJobInfo(Element data) {
        Object jobInfo = "";
        if (data != null) {
            NodeList fields = ((Element)data.getElementsByTagName("Variables").item(0)).getElementsByTagName("Field");
            jobInfo = (String)jobInfo + "General\n";
            jobInfo = (String)jobInfo + SECTION_SEPARETOR;
            for (int i = 0; i < fields.getLength(); ++i) {
                Element field = (Element)fields.item(i);
                jobInfo = (String)jobInfo + String.format("%-32s\t: %s%s", field.getAttribute("NAME"), field.getAttribute("VALUE"), "\n");
            }
        }
        return jobInfo;
    }

    protected ArrayList<String> getDescriptionTypeLookNodes() {
        ArrayList<String> toRet = new ArrayList<String>();
        for (ApplicationsEntitiy child = (ApplicationsEntitiy)this.getDefaultTreeModel().getFirstChild(); child != null; child = (ApplicationsEntitiy)child.getNextSibling()) {
            toRet.add((String)child.getUserObject());
        }
        return toRet;
    }

    protected ArrayList<String> getDescriptionTypeSplitLookNodes() {
        return null;
    }

    protected ArrayList<String> getSelectionList(String parentNodeID) {
        return null;
    }

    protected HashMap<String, String> getDescriptionNodes() {
        LinkedHashMap descriptionMap_NodeName_NodeDesc = this.m_DescriptionXMLReader.getNodeNameNodeDescriptionMap();
        StringBuilder mainSummary = new StringBuilder();
        mainSummary.append("Summary:").append("\n").append("\n");
        String extraSummary = null;
        if (this.m_DescriptionXMLReader.isAutoBuildMainSummary()) {
            for (String nodeName : descriptionMap_NodeName_NodeDesc.keySet()) {
                String nodeDescription = this.evaluateDescriptionParameters(nodeName, (String)descriptionMap_NodeName_NodeDesc.get(nodeName));
                descriptionMap_NodeName_NodeDesc.put(nodeName, nodeDescription);
                if (nodeName.compareToIgnoreCase("MainSummary") == 0 || nodeName.compareToIgnoreCase("AppWorxTables") == 0) continue;
                if (nodeName.compareToIgnoreCase("ExtraSummary") == 0) {
                    extraSummary = this.evaluateDescriptionParameters("ExtraSummary", (String)descriptionMap_NodeName_NodeDesc.get(nodeName));
                    continue;
                }
                mainSummary.append(nodeDescription).append("\n").append("\n");
            }
            if (null != extraSummary) {
                mainSummary.append(extraSummary).append("\n").append("\n");
            }
        } else {
            mainSummary.append(this.evaluateDescriptionParameters("MainSummary", (String)descriptionMap_NodeName_NodeDesc.get("MainSummary")));
            String sExtraSummary = (String)descriptionMap_NodeName_NodeDesc.get("ExtraSummary");
            if (null != sExtraSummary) {
                mainSummary.append("\n").append("\n").append("ExtraSummary").append("\n").append(this.evaluateDescriptionParameters("ExtraSummary", sExtraSummary)).append("\n");
            }
        }
        descriptionMap_NodeName_NodeDesc.put(Params.instance().getDatasourceName(), mainSummary.toString());
        return descriptionMap_NodeName_NodeDesc;
    }

    private String evaluateDescriptionParameters(String sNodeName, String sDescription) {
        if (sDescription != null && sDescription.contains("#")) {
            Matcher matcher = this.parametersPattern.matcher(sDescription);
            while (matcher.find()) {
                String sNum;
                Object sKey = matcher.group(0);
                if (((String)sKey).equals("#NUMBER_OF_ENTRIES_IN_TABLE#")) {
                    sKey = (String)sKey + sNodeName;
                }
                if (null == (sNum = null)) {
                    sNum = "0";
                }
                sDescription = sDescription.replace(matcher.group(0), sNum);
            }
        }
        return sDescription;
    }

    protected String getJobInfoFromSelectionList(String messageID) {
        return null;
    }
}

