/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.rules.GuiRuleComponent;
import com.bmc.ctmconvert.rules.VersionRange;

public class StringReplaceComponent
extends GuiRuleComponent {
    private DataRetrievable optionsComponent;
    private DataRetrievable delimiterComponent;
    private DataRetrievable prefixComponent;
    private DataRetrievable suffixComponent;

    public StringReplaceComponent(DataRetrievable component, VersionRange version) {
        super(component, version);
    }

    public void setOptionComponent(DataRetrievable component) {
        if (component.getDataType() != DataRetrievable.DataType.STRING) {
            return;
        }
        this.optionsComponent = component;
        component.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                StringReplaceComponent.this.resolveFormat();
            }
        });
    }

    public void setDelimiterComponent(DataRetrievable component) {
        if (component.getDataType() != DataRetrievable.DataType.STRING) {
            return;
        }
        this.delimiterComponent = component;
        component.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                StringReplaceComponent.this.resolveFormat();
            }
        });
    }

    public void setPrefixComponent(DataRetrievable component) {
        if (component.getDataType() != DataRetrievable.DataType.STRING) {
            return;
        }
        this.prefixComponent = component;
        component.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                StringReplaceComponent.this.resolveFormat();
            }
        });
    }

    public void setsuffixComponent(DataRetrievable component) {
        if (component.getDataType() != DataRetrievable.DataType.STRING) {
            return;
        }
        this.suffixComponent = component;
        component.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                StringReplaceComponent.this.resolveFormat();
            }
        });
    }

    private void resolveFormat() {
        if (this.optionsComponent == null) {
            return;
        }
        Object selecteddata = this.optionsComponent.getData();
        if (selecteddata == null || !(selecteddata instanceof String)) {
            return;
        }
        String formaString = (String)selecteddata;
        String delString = "{DELIMITER}";
        String preString = "{PREFIX}";
        String sufString = "{SUFFIX}";
        String del = null;
        String prefix = null;
        String suffix = null;
        if (this.delimiterComponent != null && this.delimiterComponent.getData() instanceof String) {
            del = (String)this.delimiterComponent.getData();
        }
        if (this.prefixComponent != null && this.prefixComponent.getData() instanceof String) {
            prefix = (String)this.prefixComponent.getData();
        }
        if (this.suffixComponent != null && this.suffixComponent.getData() instanceof String) {
            suffix = (String)this.suffixComponent.getData();
        }
        if (del == null || prefix == null || suffix == null) {
            return;
        }
        String item = formaString.replace(delString, del);
        if (prefix.isEmpty()) {
            item = item.replace(preString, "");
            if (((String)selecteddata).contains(delString)) {
                item = item.substring(del.length(), item.length());
            }
        } else {
            item = item.replace(preString, prefix);
        }
        if (suffix.isEmpty()) {
            item = item.replace(sufString, "");
            if (((String)selecteddata).contains(delString)) {
                item = item.substring(0, item.length() - del.length());
            }
        } else {
            item = item.replace(sufString, suffix);
        }
        super.setData(item);
    }

    @Override
    public void setActive(Boolean b) {
        super.setActive(b);
        this.optionsComponent.setActive(b);
        this.delimiterComponent.setActive(b);
        this.prefixComponent.setActive(b);
        this.suffixComponent.setActive(b);
    }

    @Override
    public void setData(Object obj) {
        super.setData(obj);
        this.resolveFormat();
    }

    @Override
    public Object getData() {
        return super.getData();
    }
}

