/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Table;
import com.bmc.ctmconvert.rules.GuiRuleComponent;
import com.bmc.ctmconvert.rules.GuiRuleContainerComponent;
import com.bmc.ctmconvert.rules.Rule;
import com.bmc.ctmconvert.rules.RulesContainer;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import javax.swing.table.TableModel;

public class RulesEditor {
    private ArrayList<GuiRuleComponent> componentList;
    private BaseComponent editorComponent;
    private String EditorVersion;
    private boolean isCurrentDataSetValid;
    private Actionable validyChangedAction;
    private ArrayList<GuiRuleComponent> unValidComponentsList;

    public RulesEditor(BaseComponent editorPanel, ArrayList<GuiRuleComponent> componentList) {
        this.editorComponent = editorPanel;
        this.componentList = componentList;
        this.unValidComponentsList = new ArrayList();
    }

    public RulesDataSet getEditorData() {
        RulesDataSet ruleSet = new RulesDataSet();
        Rule rule = null;
        for (GuiRuleComponent ruleComponent : this.componentList) {
            if (ruleComponent instanceof GuiRuleContainerComponent) {
                rule = this.getListRuleFromComponent((GuiRuleContainerComponent)ruleComponent);
                continue;
            }
            rule = this.getRuleFromComponent(ruleComponent);
            ruleSet.addRule(ruleComponent.getGroupName(), ruleComponent.getGroupName(), rule);
        }
        return ruleSet;
    }

    private RulesContainer getListRuleFromComponent(GuiRuleContainerComponent ruleComponent) {
        RulesContainer listRule = new RulesContainer(ruleComponent.getName());
        for (GuiRuleComponent item : ruleComponent.getItems()) {
            Rule rule = item instanceof GuiRuleContainerComponent ? this.getListRuleFromComponent((GuiRuleContainerComponent)item) : this.getRuleFromComponent(item);
            listRule.add(rule);
        }
        return null;
    }

    private Rule getRuleFromComponent(GuiRuleComponent ruleComponent) {
        DataRetrievable.DataType dataType = ruleComponent.getDataType();
        Object data = ruleComponent.getData();
        switch (dataType) {
            case BOOLEAN: {
                if (!(data instanceof Boolean)) break;
                return new Rule(ruleComponent.getName(), (Boolean)ruleComponent.getData());
            }
            case STRING: {
                if (!(data instanceof String)) break;
                return new Rule(ruleComponent.getName(), (String)ruleComponent.getData());
            }
            case TABLE: {
                if (!(data instanceof TableModel)) break;
                return new Rule(ruleComponent.getName(), new Table((TableModel)ruleComponent.getData()));
            }
        }
        return null;
    }

    public BaseComponent getEditorGuiComponent() {
        return this.editorComponent;
    }

    public void loadData(RulesDataSet data) {
        for (GuiRuleComponent ruleComponent : this.componentList) {
            String group = ruleComponent.getGroupName();
            if (ruleComponent instanceof GuiRuleContainerComponent) {
                this.setMultyComponent(data, (GuiRuleContainerComponent)ruleComponent, new ArrayList<String>(), group);
                continue;
            }
            this.setComponent(data, ruleComponent, new ArrayList<String>(), ruleComponent.getGroupName());
        }
    }

    private void setComponent(RulesDataSet data, GuiRuleComponent ruleComponent, ArrayList<String> parents, String group) {
        String RuleName = ruleComponent.getName();
        parents.add(RuleName);
        String[] parentsArr = parents.toArray(new String[parents.size()]);
        boolean isRuleExist = data.isRuleExist(group, parentsArr);
        parents.remove(RuleName);
        if (!isRuleExist) {
            return;
        }
        Rule.RuleDataType ruletype = data.getRuleType(group, parentsArr);
        DataRetrievable.DataType componentType = ruleComponent.getDataType();
        switch (componentType) {
            case BOOLEAN: {
                if (!ruletype.equals((Object)Rule.RuleDataType.BOOLEAN)) {
                    ExceptionHandler.writeToExceptionFile(new Exception("unmatched rule type and GUI component type. RuleName : " + ruleComponent.getName() + " component type: " + String.valueOf((Object)componentType) + " rule type : " + String.valueOf((Object)ruletype)));
                    return;
                }
                this.connectComponentToRule(ruleComponent, data, group, parentsArr);
                break;
            }
            case STRING: {
                if (!ruletype.equals((Object)Rule.RuleDataType.STRING) && !ruletype.equals((Object)Rule.RuleDataType.INTEGER)) {
                    ExceptionHandler.writeToExceptionFile(new Exception("unmatched rule type and GUI component type RuleName  : " + ruleComponent.getName() + " component type: " + String.valueOf((Object)componentType) + " rule type : " + String.valueOf((Object)ruletype)));
                    return;
                }
                this.connectComponentToRule(ruleComponent, data, group, parentsArr);
                break;
            }
            case TABLE: {
                if (!(ruletype.equals((Object)Rule.RuleDataType.TABLE) || ruletype.equals((Object)Rule.RuleDataType.LIST) || ruletype.equals((Object)Rule.RuleDataType.PAIRS_LIST))) {
                    ExceptionHandler.writeToExceptionFile(new Exception("unmatched rule type and GUI component type RuleName  : " + ruleComponent.getName() + " component type: " + String.valueOf((Object)componentType) + " rule type : " + String.valueOf((Object)ruletype)));
                    return;
                }
                this.connectComponentToRule(ruleComponent, data, group, parentsArr);
                break;
            }
            case PAIRS_LIST: {
                if (!ruletype.equals((Object)Rule.RuleDataType.PAIRS_LIST)) {
                    ExceptionHandler.writeToExceptionFile(new Exception("unmatched rule type and GUI component type RuleName  : " + ruleComponent.getName() + " component type: " + String.valueOf((Object)componentType) + " rule type : " + String.valueOf((Object)ruletype)));
                    return;
                }
                this.connectComponentToRule(ruleComponent, data, group, parentsArr);
                break;
            }
        }
    }

    private void connectComponentToRule(final GuiRuleComponent ruleComponent, final RulesDataSet data, final String group, final String[] path) {
        ruleComponent.setRuleUpdater(new Actionable(){

            @Override
            public void act() {
                data.setData(ruleComponent.getData(), group, path);
                RulesEditor.this.setIsCurrentDataSetValid(ruleComponent);
            }
        });
        ruleComponent.setData(data.getData(group, path));
        ruleComponent.handleVersionCompatibility();
    }

    protected void setIsCurrentDataSetValid(GuiRuleComponent ruleComponent) {
        boolean isRuleValid = ruleComponent.isValidData();
        if (this.unValidComponentsList.contains(ruleComponent) && isRuleValid) {
            this.unValidComponentsList.remove(ruleComponent);
        }
        if (!this.unValidComponentsList.contains(ruleComponent) && !isRuleValid) {
            this.unValidComponentsList.add(ruleComponent);
        }
        if (this.unValidComponentsList.isEmpty()) {
            this.setEditorValidity(true);
        } else {
            this.setEditorValidity(false);
        }
    }

    private void setEditorValidity(boolean b) {
        if (this.isCurrentDataSetValid != b) {
            this.isCurrentDataSetValid = b;
            if (this.validyChangedAction != null) {
                this.validyChangedAction.act();
            }
        }
    }

    private void setMultyComponent(RulesDataSet data, GuiRuleContainerComponent ruleListComponent, ArrayList<String> parents, String group) {
        String ruleName = ruleListComponent.getName();
        parents.add(ruleName);
        ArrayList<GuiRuleComponent> childsList = ruleListComponent.getItems();
        for (GuiRuleComponent guiRuleComponent : childsList) {
            if (guiRuleComponent instanceof GuiRuleContainerComponent) {
                this.setMultyComponent(data, (GuiRuleContainerComponent)guiRuleComponent, parents, group);
                continue;
            }
            this.setComponent(data, guiRuleComponent, parents, group);
        }
        parents.remove(ruleName);
    }

    public void setVersion(String version) {
        this.EditorVersion = version;
        for (GuiRuleComponent component : this.componentList) {
            component.handleVersion(this.EditorVersion);
        }
    }

    public boolean isValidRules() {
        return this.isCurrentDataSetValid;
    }

    public void loadDataOnViewOnlyMode(RulesDataSet dataSet) {
        this.loadData(dataSet);
        this.setActive(false);
    }

    public void setValidyChangedAction(Actionable validyChangedAction) {
        this.validyChangedAction = validyChangedAction;
    }

    public void setActive(boolean b) {
        for (GuiRuleComponent ruleComponent : this.componentList) {
            ruleComponent.setActive(b);
        }
    }
}

