/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.Table;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.rules.FieldEditor;
import com.bmc.ctmconvert.rules.NameManipulator;
import com.bmc.ctmconvert.rules.Rule;
import com.bmc.ctmconvert.rules.RulesContainer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.table.TableModel;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class RulesDataSet {
    private static final String XML_TAG_ENTRY = "entry";
    private static final String XML_TAG_RULE_SET = "RuleSet";
    private static final String XML_TAG_GROUP = "GROUP";
    private static final String XML_TAG_PROPERTIES = "PROPERTIES";
    private static final String XML_ATTR_KEY = "KEY";
    private static final String DATA_SET_NAME = "NAME";
    private static final String DATA_SET_TITLE = "TITLE";
    private static final String DATA_SET_DESCRIPTION = "DESCRIPTION";
    protected Path ruleSetPath;
    protected LinkedHashMap<String, String> groupNames;
    protected LinkedHashMap<String, LinkedHashMap<String, Rule>> ruleData;
    protected LinkedHashMap<String, String> properties;
    private FieldEditor fieldEditor;
    private NameManipulator nameManipulator;
    private TaskTypeHandler taskTypeHandler;
    private FilterData filterHandler;
    protected RulesDataSet rulesMetaData;

    public RulesDataSet(RulesDataSet rulesMetaData, Path ruleSetFile) {
        this.ruleSetPath = ruleSetFile;
        this.rulesMetaData = rulesMetaData;
        this.init();
    }

    public RulesDataSet() {
        this.init();
    }

    public RulesDataSet(Path ruleSetPath) {
        this(new RulesDataSet(), ruleSetPath);
    }

    protected void init() {
        this.ruleData = new LinkedHashMap();
        this.properties = new LinkedHashMap();
        this.groupNames = new LinkedHashMap();
        if (this.ruleSetPath != null && Files.exists(this.ruleSetPath, new LinkOption[0])) {
            this.readDataFromFile();
        }
    }

    private void readDataFromFile() {
        if (this.ruleSetPath == null || !Files.exists(this.ruleSetPath, new LinkOption[0])) {
            return;
        }
        XmlLoader loader = new XmlLoader();
        try {
            loader.loadFile(Files.newInputStream(this.ruleSetPath, new OpenOption[0]));
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile("gui rule xml file : " + e.getMessage());
            return;
        }
        XmlElement dataElement = loader.getXmlElement();
        if (dataElement == null) {
            System.out.println(loader.getErrorMessage());
            return;
        }
        this.getProperties(dataElement);
        List<XmlElement> groupElemnts = dataElement.getDirectchildsElementbyName(XML_TAG_GROUP);
        List<XmlElement> nonGroupedrulesElemnts = dataElement.getDirectchildsElementbyName("RULE", "RULE_CONTAINER");
        this.getRulesFromGroup(groupElemnts);
        for (XmlElement ruleElement : nonGroupedrulesElemnts) {
            this.addRuleFromXmlElement("", ruleElement);
        }
    }

    public void restoreData() {
        this.init();
    }

    private void getProperties(XmlElement dataElement) {
        XmlElement propertiesElement = dataElement.getFirstChildElementByName(XML_TAG_PROPERTIES);
        if (propertiesElement == null) {
            return;
        }
        List<XmlElement> entrysElements = propertiesElement.getDirectchildsElementbyName(XML_TAG_ENTRY);
        for (XmlElement xmlElement : entrysElements) {
            String key = xmlElement.getAttribute(XML_ATTR_KEY);
            String value = xmlElement.getValue();
            if (key.isEmpty()) continue;
            this.properties.put(key, value);
        }
    }

    private void addRuleFromXmlElement(String group, XmlElement ruleElement) {
        Rule newRule = null;
        if (!this.rulesMetaData.hasRule(group, Rule.getRuleName(ruleElement))) {
            return;
        }
        Rule metaDataRule = this.rulesMetaData.getRule(group, Rule.getRuleName(ruleElement));
        if (ruleElement.getTagName().equals("RULE")) {
            if (this.rulesMetaData.hasRule(group, Rule.getRuleName(ruleElement))) {
                newRule = new Rule(metaDataRule, ruleElement);
            }
        } else if (ruleElement.getTagName().equals("RULE_CONTAINER") && metaDataRule instanceof RulesContainer) {
            newRule = new RulesContainer((RulesContainer)metaDataRule, ruleElement);
        }
        if (newRule != null && !newRule.isEmpty()) {
            this.addRule(group, newRule.getName(), newRule);
        }
    }

    private void getRulesFromGroup(List<XmlElement> groupElemnts) {
        for (XmlElement groupElement : groupElemnts) {
            String groupName = groupElement.getAttribute(DATA_SET_NAME);
            List<XmlElement> ruleList = groupElement.getDirectchildsElementbyName("RULE", "RULE_CONTAINER");
            for (XmlElement ruleElement : ruleList) {
                this.addRuleFromXmlElement(groupName, ruleElement);
            }
        }
    }

    public void saveToFile(Path targetPath) {
        try {
            DocumentBuilderFactory docFactory = DocumentBuilderFactory.newInstance();
            DocumentBuilder docBuilder = docFactory.newDocumentBuilder();
            Document doc = docBuilder.newDocument();
            Element rootElement = doc.createElement(XML_TAG_RULE_SET);
            Element propertiesElement = this.getPropertiesElement(doc);
            rootElement.appendChild(propertiesElement);
            doc.appendChild(rootElement);
            for (String group : this.ruleData.keySet()) {
                Element groupElement = doc.createElement(XML_TAG_GROUP);
                groupElement.setAttribute(DATA_SET_NAME, group);
                for (String ruleName : this.ruleData.get(group).keySet()) {
                    if (group.isEmpty()) {
                        rootElement.appendChild(this.getRule(group, ruleName).toXmlElement(doc));
                        continue;
                    }
                    groupElement.appendChild(this.getRule(group, ruleName).toXmlElement(doc));
                }
                if (group.isEmpty()) continue;
                rootElement.appendChild(groupElement);
            }
            TransformerFactory transformerFactory = TransformerFactory.newInstance();
            Transformer transformer = transformerFactory.newTransformer();
            transformer.setOutputProperty("indent", "yes");
            transformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", "2");
            DOMSource source = new DOMSource(doc);
            File targetFile = targetPath.toFile();
            if (Files.notExists(targetPath, new LinkOption[0])) {
                try {
                    targetFile.createNewFile();
                }
                catch (IOException e) {
                    System.out.println("itai file problem");
                    ExceptionHandler.writeToExceptionFile(e);
                }
            }
            StreamResult result = new StreamResult(targetFile);
            transformer.transform(source, result);
        }
        catch (ParserConfigurationException pce) {
            ExceptionHandler.writeToExceptionFile(pce);
        }
        catch (TransformerException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
    }

    private Element getPropertiesElement(Document doc) {
        Element propertiesElement = doc.createElement(XML_TAG_PROPERTIES);
        for (String key : this.properties.keySet()) {
            Element entryElement = doc.createElement(XML_TAG_ENTRY);
            entryElement.setAttribute(XML_ATTR_KEY, key);
            entryElement.setTextContent(this.properties.get(key));
            propertiesElement.appendChild(entryElement);
        }
        return propertiesElement;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Properties " + this.properties.size()).append("\n");
        for (String entry : this.properties.keySet()) {
            builder.append(entry).append(":");
            builder.append(this.properties.get(entry)).append("\n");
        }
        builder.append("Group size " + this.ruleData.size()).append("\n");
        for (String group : this.ruleData.keySet()) {
            builder.append("group\t:\t").append(group).append("\n");
            for (String rule : this.ruleData.get(group).keySet()) {
                builder.append(this.ruleData.get(group).get(rule)).append("\n");
            }
        }
        return builder.toString();
    }

    public void addRule(String groupName, String ruleName, Boolean boolValue) {
        this.addRule(groupName, ruleName, new Rule(ruleName, boolValue));
    }

    public void addRule(String ruleGroup, String ruleName, String ruleValue) {
        this.addRule(ruleGroup, ruleName, new Rule(ruleName, ruleValue));
    }

    public void addRule(String ruleGroup, String ruleName, ArrayList<String> ruleValue) {
        this.addRule(ruleGroup, ruleName, new Rule(ruleName, ruleValue));
    }

    public void addRule(String ruleGroup, String ruleName, Table table) {
        this.addRule(ruleGroup, ruleName, new Rule(ruleName, table));
    }

    public void addRule(String groupName, String ruleName, TableModel table) {
        this.addRule(groupName, ruleName, new Table(table));
    }

    public void addRule(String groupName, String ruleName, Rule rule) {
        if (groupName == null) {
            groupName = "";
        }
        if (!this.ruleData.containsKey(groupName)) {
            this.groupNames.put(groupName, "");
            this.ruleData.put(groupName, new LinkedHashMap());
        }
        this.ruleData.get(groupName).put(ruleName, rule);
    }

    private Rule getRule(String group, String ruleName) {
        if (!this.ruleData.containsKey(group) || !this.ruleData.get(group).containsKey(ruleName)) {
            return null;
        }
        Rule t = this.ruleData.get(group).get(ruleName);
        return t;
    }

    public boolean hasRule(String group, String ... rulePath) {
        Rule rule = null;
        try {
            rule = this.getRule(group, rulePath);
        }
        catch (NullPointerException nullPointerException) {
            // empty catch block
        }
        return rule != null;
    }

    public Rule getRule(String group, String ... rulePath) {
        Rule rule;
        Object ret = null;
        ret = rulePath == null || rulePath.length < 1 ? null : (rulePath.length == 1 ? this.getRule(group, rulePath[0]) : (!((rule = this.getRule(group, rulePath[0])) instanceof RulesContainer) ? null : ((RulesContainer)rule).getRule(Arrays.copyOfRange(rulePath, 1, rulePath.length))));
        if (ret == null && (ret = this.getRuleIfExistInStandardRules(group, rulePath)) == null) {
            NullPointerException e = new NullPointerException("RulesDataSet- Rule is not exist. group: " + group + ".  rule :  " + Arrays.toString(rulePath) + " request - but was not found .");
            throw e;
        }
        return ret;
    }

    private Rule getRuleIfExistInStandardRules(String group, String ... rulePath) {
        if (this.rulesMetaData != null && this.rulesMetaData.hasRule(group, rulePath)) {
            return this.rulesMetaData.getRule(group, rulePath);
        }
        return null;
    }

    public Object getData(String group, String[] rulePath) {
        Rule rule = this.getRule(group, rulePath);
        if (rule == null) {
            return null;
        }
        return rule.getData();
    }

    public boolean isRuleExist(String group, String ... rulePath) {
        Rule rule = null;
        try {
            rule = this.getRule(group, rulePath);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rule != null;
    }

    public void setData(Object newData, String group, String[] path) {
        Rule rule = this.getRule(group, path);
        if (rule == null) {
            return;
        }
        rule.setData(newData);
    }

    public Rule.RuleDataType getRuleType(String group, String[] path) {
        Rule rule = this.getRule(group, path);
        if (rule == null) {
            return null;
        }
        return rule.getDataType();
    }

    public ArrayList<Map.Entry<String, String>> getPairsListRule(String group, String ... rulePath) {
        Rule retRule = this.getRule(group, rulePath);
        if (retRule == null || retRule.getDataType() != Rule.RuleDataType.PAIRS_LIST) {
            return null;
        }
        return (ArrayList)retRule.getData();
    }

    public String getProperty(String property) {
        if (!this.properties.containsKey(property)) {
            return null;
        }
        return this.properties.get(property);
    }

    public void setProperty(String key, String value) {
        if (this.properties == null || key == null || value == null) {
            return;
        }
        this.properties.put(key, value);
    }

    public boolean hasProperty(String property) {
        return this.getProperty(property) != null;
    }

    public Boolean getBooleanRule(String group, String ... rulePath) {
        Rule retRule = this.getRule(group, rulePath);
        if (retRule == null || retRule.getDataType() != Rule.RuleDataType.BOOLEAN) {
            return null;
        }
        return (Boolean)retRule.getData();
    }

    public Integer getIntegerRule(String group, String ... rulePath) {
        Rule retRule = this.getRule(group, rulePath);
        if (retRule == null || retRule.getDataType() != Rule.RuleDataType.INTEGER) {
            return null;
        }
        return (Integer)retRule.getData();
    }

    public String getStringRule(String group, String ... rulePath) {
        Rule retRule = this.getRule(group, rulePath);
        if (retRule == null || retRule.getDataType() != Rule.RuleDataType.STRING && retRule.getDataType() != Rule.RuleDataType.INTEGER) {
            return null;
        }
        Object data = retRule.getData();
        String ret = null;
        if (retRule.getDataType() == Rule.RuleDataType.STRING) {
            ret = (String)data;
        } else if (retRule.getDataType() == Rule.RuleDataType.INTEGER) {
            ret = ((Integer)data).toString();
        }
        return ret == null ? "" : ret;
    }

    public ArrayList<String> getListRule(String group, String ... rulePath) {
        Rule retRule = this.getRule(group, rulePath);
        if (retRule == null || retRule.getDataType() != Rule.RuleDataType.LIST) {
            return null;
        }
        return (ArrayList)retRule.getData();
    }

    public FieldEditor getFieldEditor() {
        if (this.fieldEditor == null) {
            this.fieldEditor = new FieldEditor(this);
        }
        return this.fieldEditor;
    }

    public ArrayList<String> getRuleContainerContent(String group, String ... rulePath) {
        ArrayList<String> ret = new ArrayList<String>();
        Rule rule = this.getRule(group, rulePath);
        if (rule == null || rule.getDataType() != Rule.RuleDataType.RULES_CONTAINER) {
            return ret;
        }
        RulesContainer container = (RulesContainer)rule;
        ArrayList<Rule> itemList = container.getContent();
        for (Rule item : itemList) {
            ret.add(item.getName());
        }
        return ret;
    }

    public TaskTypeHandler getTaskTypeHandler() {
        if (this.taskTypeHandler == null) {
            this.taskTypeHandler = new TaskTypeHandler();
        }
        return this.taskTypeHandler;
    }

    public FilterData getFilterHandler() {
        if (this.filterHandler == null) {
            this.filterHandler = new FilterData();
        }
        return this.filterHandler;
    }

    public NameManipulator getNameManipulator() {
        if (this.nameManipulator == null) {
            this.nameManipulator = new NameManipulator();
        }
        return this.nameManipulator;
    }

    public String getName() {
        if (!this.properties.containsKey(DATA_SET_NAME)) {
            return "";
        }
        return this.properties.get(DATA_SET_NAME);
    }

    public String getdescription() {
        if (!this.properties.containsKey(DATA_SET_DESCRIPTION)) {
            return "";
        }
        return this.properties.get(DATA_SET_DESCRIPTION);
    }

    public void setDescription(String description) {
        this.properties.put(DATA_SET_DESCRIPTION, description);
    }

    public String getTitle() {
        if (!this.properties.containsKey(DATA_SET_TITLE)) {
            return this.getName();
        }
        return this.properties.get(DATA_SET_TITLE);
    }

    public void setName(String name) {
        this.properties.put(DATA_SET_NAME, name);
    }

    public void setTitle(String title) {
        this.properties.put(DATA_SET_TITLE, title);
    }

    public void saveToFile() {
        if (this.ruleSetPath != null) {
            this.saveToFile(this.ruleSetPath);
        }
    }

    public Boolean delete() {
        if (this.ruleSetPath != null) {
            try {
                return Files.deleteIfExists(this.ruleSetPath);
            }
            catch (IOException e) {
                ExceptionHandler.writeToExceptionFile(e);
            }
        }
        return false;
    }

    public static String getRulesFileErrorMessage(String srcPath) {
        XmlLoader loader = new XmlLoader();
        try {
            loader.loadFile(new FileInputStream(srcPath));
        }
        catch (Exception e) {
            return "invalid xml File : \n" + e.getMessage();
        }
        XmlElement dataElement = loader.getXmlElement();
        if (dataElement == null) {
            System.out.println(loader.getErrorMessage());
            return loader.getErrorMessage();
        }
        if (!dataElement.getTagName().equalsIgnoreCase(XML_TAG_RULE_SET)) {
            return "invalid rule : cannot find <RuleSet> element in xml file <" + dataElement.getTagName() + ">";
        }
        return null;
    }

    public static boolean isValidRuleFile(String srcPath) {
        String errorMessage = RulesDataSet.getRulesFileErrorMessage(srcPath);
        return errorMessage == null;
    }

    public void setRulesMetaData(RulesDataSet rulesMetaData) {
        this.rulesMetaData = rulesMetaData;
    }

    public class TaskTypeHandler {
        private static final String TASK_TYPE_RULE_NAME = "CONVERT_TYPE";
        private static final String CONVERT_ALL_TO_DUMMY_RULENAME = "ConvertAllToDummy";
        private static final String TASK_TYPE_GROUP = "TaskType";
        public static final String TASK_TYPE_JOB = "JOB";
        public static final String TASK_TYPE_COMMAND = "COMMAND";

        public String getTaskType() {
            if (RulesDataSet.this.getBooleanRule(TASK_TYPE_GROUP, CONVERT_ALL_TO_DUMMY_RULENAME).booleanValue()) {
                return "Dummy";
            }
            return "Job";
        }

        public boolean isToDummy() {
            return RulesDataSet.this.getBooleanRule(TASK_TYPE_GROUP, CONVERT_ALL_TO_DUMMY_RULENAME);
        }

        public String getJobType() {
            String jobType = RulesDataSet.this.getStringRule(TASK_TYPE_GROUP, TASK_TYPE_RULE_NAME);
            return jobType;
        }

        public boolean isToJobType() {
            String jobType = RulesDataSet.this.getStringRule(TASK_TYPE_GROUP, TASK_TYPE_RULE_NAME);
            return jobType.equals(TASK_TYPE_JOB);
        }

        public boolean isToCommandType() {
            String jobType = RulesDataSet.this.getStringRule(TASK_TYPE_GROUP, TASK_TYPE_RULE_NAME);
            return jobType.equals(TASK_TYPE_COMMAND);
        }

        public ArrayList<String> getTaskTypeFilters() {
            return RulesDataSet.this.getListRule(TASK_TYPE_GROUP, "taskTypeTable");
        }
    }

    public class FilterData {
        private static final String FILTER_JOBS_TABLE_RULE_NAME = "FilterJobsTable";
        private static final String FILTER_GROUP_NAME = "Filter";
        private static final String FILTER_TYPE_RULE_NAME = "Type";
        private static final String FILTER_INCLUDE_VALUE = "INCLUDE";
        private static final String FILTER_RELATIONSHIP_RULE_NAME = "Relationship";
        private static final String FILTER_OR_VALUE = "OR";

        public ArrayList<Map.Entry<String, String>> getConditions() {
            return RulesDataSet.this.getPairsListRule(FILTER_GROUP_NAME, FILTER_JOBS_TABLE_RULE_NAME);
        }

        public boolean isEmptyFilter() {
            ArrayList<Map.Entry<String, String>> conditions = this.getConditions();
            boolean result = true;
            if (conditions != null && !conditions.isEmpty()) {
                for (Map.Entry<String, String> entry : this.getConditions()) {
                    if (entry.getValue() == null || entry.getValue().isEmpty()) continue;
                    result = false;
                }
            }
            return result;
        }

        public boolean isInclude() {
            return RulesDataSet.this.getStringRule(FILTER_GROUP_NAME, FILTER_TYPE_RULE_NAME).equalsIgnoreCase(FILTER_INCLUDE_VALUE);
        }

        public boolean isOr() {
            return RulesDataSet.this.getStringRule(FILTER_GROUP_NAME, FILTER_RELATIONSHIP_RULE_NAME).equalsIgnoreCase(FILTER_OR_VALUE);
        }

        public boolean isFilter(HashMap<String, String> filterDetails) {
            boolean retVal = this.isInclude();
            boolean match = false;
            ArrayList<Map.Entry<String, String>> conditions = this.getConditions();
            if (conditions == null || conditions.isEmpty()) {
                return true;
            }
            for (Map.Entry<String, String> entry : conditions) {
                String field = entry.getKey();
                String regVal = entry.getValue();
                String recordVal = null;
                recordVal = filterDetails.get(field);
                if (recordVal == null) continue;
                match = this.matchWildcard(recordVal, regVal);
                if (match) {
                    retVal = true;
                    if (!this.isOr()) continue;
                    break;
                }
                retVal = false;
                if (this.isOr()) continue;
            }
            return this.isInclude() ? retVal : !retVal;
        }

        private boolean matchWildcard(String value, String expr) {
            String regExp = expr.replaceAll("\\\\", "\\\\\\\\");
            regExp = regExp.replaceAll("\\*", ".*");
            regExp = regExp.replaceAll("\\?", ".");
            return value.matches(regExp);
        }
    }

    public class FieldConvertorData {
        public FieldConvertorData(RulesDataSet this$0) {
        }
    }
}

