/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseMessageDialog;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Globs;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.ProcessAlertsManager;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.interfaces.VendorData;
import com.bmc.ctmconvert.rules.MetaDataHendler;
import com.bmc.ctmconvert.rules.RetrivalDataSet;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.rules.RulesEditor;
import com.bmc.ctmconvert.services.DraftFormatRule;
import com.bmc.ctmconvert.services.VendorDataManager;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.intellij.lang.annotations.Language;
import org.jetbrains.annotations.NotNull;

public class RuleManager {
    public static final String CONVERSION_DRAFT_FORMAT_RULE_GROUP = "ConversionDraftFormat";
    public static final String CONVERSION_DRAFT_FORMAT_RULE_NAME = "CONVERSION_DRAFT_FORMAT";
    public static final String CONVERSION_DRAFT_FORMAT_RULE_XML = "XML";
    public static final String CONVERSION_DRAFT_FORMAT_RULE_JSON = "JSON";
    private static final String VENDOR = "VENDOR";
    private static final String YES_VALUE = "Y";
    private static final String NO_VALUE = "N";
    private static final String PROPERTY_IS_DEFAULT = "IsDefault";
    public static final String RULE_FILE_ASSOCIATION_WITHOUTDOT = "xml";
    public static final String RULE_FILE_ASSOCIATION = ".xml";
    private static final String NAME = "NAME";
    private static final String STANDART_RULE_NAME = "standard rules";
    public static RuleManager instance;
    private RulesEditor currentEditor = null;
    private RulesDataSet currentRuleSet;
    private RulesDataSet standartRuleSet;
    private RulesDataSet resourceStandardRuleSet;
    private RulesDataSet defaultRuleSet;
    private String currentVersion;
    private ArrayList<RulesDataSet> vendorRuleSetList;
    private final String currentVendor;
    private final File currentVendorResource;
    private final File rulesDirectory;
    private Actionable onRuleschangeAction = null;
    private MetaDataHendler guibuilder;

    public DraftFormatRule getDraftFormatRule() {
        if (SettingsBooleanKeys.isSaas()) {
            return DraftFormatRule.JSON;
        }
        return Optional.ofNullable(this.getCurrentRules().getStringRule(CONVERSION_DRAFT_FORMAT_RULE_GROUP, CONVERSION_DRAFT_FORMAT_RULE_NAME)).map(ruleValue -> switch (ruleValue) {
            case CONVERSION_DRAFT_FORMAT_RULE_JSON -> DraftFormatRule.JSON;
            default -> DraftFormatRule.XML;
        }).orElse(DraftFormatRule.XML);
    }

    public RuleManager(String vendor, String version, VendorData vendorData) {
        this.currentVersion = version;
        this.currentVendor = vendor;
        this.currentVendorResource = this.streamToTempFile(vendorData.getRulesResourceFile());
        this.rulesDirectory = new File(Globs.CONFIGURATIONS_DIR);
        if (this.currentVendorResource == null) {
            return;
        }
        this.resourceStandardRuleSet = this.getResourceStandardFromResourceFile(this.currentVersion);
        this.standartRuleSet = this.getStandartDataFromResourceDataSet();
        this.vendorRuleSetList = this.getVendorRuleSetList(this.resourceStandardRuleSet);
        this.setDafaultRuleSet(this.getDafaultRuleSetFromVendorList());
        this.setCurrentDataSet(this.defaultRuleSet);
    }

    public RuleManager(String vendor, String version) {
        this(vendor, version, VendorDataManager.instance().getVendorData(vendor));
    }

    public String getCurrentVendor() {
        return this.currentVendor;
    }

    private File streamToTempFile(InputStream rulesResourceFile) {
        if (rulesResourceFile == null) {
            throw new NullPointerException("rules resource file is missing");
        }
        File tempFile = null;
        try {
            tempFile = File.createTempFile("rules_resource", RULE_FILE_ASSOCIATION, new File(Globs.TEMP_DIR));
            tempFile.deleteOnExit();
            try (FileOutputStream out = new FileOutputStream(tempFile);){
                String rulesResourceFileContent = GlobalFunctions.readText(rulesResourceFile);
                String enhancedRules = rulesResourceFileContent.replaceFirst(RuleManager.generalTabMarkerRegex(), RuleManager.additionalGeneralRules());
                out.write(enhancedRules.getBytes());
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        return tempFile;
    }

    @Language(value="XML")
    private static String additionalGeneralRules() {
        return "<RULE_SECTION TITLE=\"Conversion draft format\" ENABLED=\"y\" TARGET_ENVIRONMENT=\"ON_PREMISE\">\n    <RULE_FIELD TITLE=\"\" GROUP=\"ConversionDraftFormat\" NAME=\"CONVERSION_DRAFT_FORMAT\" GUI_TYPE=\"radio\"\n                RULE_TYPE=\"STRING\"\n                ORIENTATION=\"horizontal\" ENABLED=\"y\" TARGET_VERSION=\"7+\">\n        <DEFAULT_VALUE VALUE=\"XML\" TARGET_VERSION=\"7+\"/>\n        <ITEM TITLE=\"XML\" NAME=\"XML\" TARGET_VERSION=\"7+\"/>\n        <ITEM TITLE=\"JSON\" NAME=\"JSON\" TARGET_VERSION=\"7+\"/>\n    </RULE_FIELD>\n</RULE_SECTION>\n";
    }

    @NotNull
    private static String generalTabMarkerRegex() {
        return "(?<=<RULE_TAB TITLE=\"General\" HELP_TITLE=\"RULES_GENERAL\">)\n";
    }

    public static RuleManager instance() {
        if (instance == null || !instance.getCurrentVendor().equals(Params.instance().getVendorName())) {
            String vendorName = Params.instance().getVendorName();
            VendorData vendorData = VendorDataManager.instance().getVendorData(vendorName);
            instance = new RuleManager(vendorName, Params.instance().getGUIVersion(), vendorData);
        }
        return instance;
    }

    private ArrayList<RulesDataSet> getVendorRuleSetList(RulesDataSet metaDataRuleSet) {
        ArrayList<RulesDataSet> result = new ArrayList<RulesDataSet>();
        try (Stream<Path> configuration = Files.list(Paths.get(Globs.CONFIGURATIONS_DIR, new String[0]));){
            List collect = configuration.filter(file -> file.getFileName().toString().endsWith(RULE_FILE_ASSOCIATION)).collect(Collectors.toList());
            for (Path file2 : collect) {
                RetrivalDataSet tmpSet = new RetrivalDataSet(metaDataRuleSet, file2);
                if (!tmpSet.hasProperty(VENDOR) || !tmpSet.getProperty(VENDOR).equalsIgnoreCase(this.getCurrentVendor())) continue;
                result.add(tmpSet);
            }
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        return result;
    }

    public Map<String, String> getVendorRulesSetList() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (RulesDataSet rulesDataSet : this.vendorRuleSetList) {
            result.put(rulesDataSet.getName(), rulesDataSet.getTitle());
        }
        return result;
    }

    public Map<String, String> getVendorRulesDescriptionSetList() {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        for (RulesDataSet rulesDataSet : this.vendorRuleSetList) {
            result.put(rulesDataSet.getName(), rulesDataSet.getdescription());
        }
        return result;
    }

    private RulesDataSet getDafaultRuleSetFromVendorList() {
        for (RulesDataSet ruleSet : this.vendorRuleSetList) {
            if (!ruleSet.hasProperty(PROPERTY_IS_DEFAULT) || !ruleSet.getProperty(PROPERTY_IS_DEFAULT).equalsIgnoreCase(YES_VALUE)) continue;
            return ruleSet;
        }
        return null;
    }

    public void setDafaultRuleSet(String name) {
        RulesDataSet newDefaultDataSet = this.getDataSetByName(name);
        this.setDafaultRuleSet(newDefaultDataSet);
    }

    public void setDafaultRuleSet(RulesDataSet newDefaultDataSet) {
        if (newDefaultDataSet == null) {
            newDefaultDataSet = this.standartRuleSet;
        }
        for (RulesDataSet ruleSet : this.vendorRuleSetList) {
            ruleSet.setProperty(PROPERTY_IS_DEFAULT, NO_VALUE);
            ruleSet.saveToFile();
        }
        this.standartRuleSet.setProperty(PROPERTY_IS_DEFAULT, NO_VALUE);
        this.standartRuleSet.saveToFile();
        newDefaultDataSet.setProperty(PROPERTY_IS_DEFAULT, YES_VALUE);
        newDefaultDataSet.saveToFile();
        this.defaultRuleSet = newDefaultDataSet;
    }

    public void viewDataSetFromFile(String srcPath) {
        Path path = Paths.get(srcPath, new String[0]);
        if (!Files.exists(path, new LinkOption[0])) {
            return;
        }
        RulesDataSet dataSet = new RulesDataSet(this.resourceStandardRuleSet, path);
        this.currentEditor.loadDataOnViewOnlyMode(dataSet);
    }

    public void exportDataSetFile(String dstpath) {
        String tmpName = this.currentRuleSet.getName();
        this.currentRuleSet.setName(this.currentRuleSet.getTitle());
        Path path = Paths.get(dstpath, new String[0]);
        this.currentRuleSet.saveToFile(path);
        this.currentRuleSet.setName(tmpName);
    }

    public String importDataSetFile(String srcPath) throws InvalidRuleFileException {
        File srcFile = new File(srcPath);
        if (!RulesDataSet.isValidRuleFile(srcPath)) {
            throw new InvalidRuleFileException(RulesDataSet.getRulesFileErrorMessage(srcPath));
        }
        Path path = Paths.get(srcPath, new String[0]);
        RulesDataSet srcDataSet = new RulesDataSet(this.resourceStandardRuleSet, path);
        String uniqeFileName = GlobalFunctions.getUniqueFileOrFoldertName("Imported-" + srcFile.getName(), this.rulesDirectory.getAbsolutePath());
        Path targetPath = Paths.get(this.rulesDirectory.getAbsolutePath() + Globs.DIRSEP + uniqeFileName, new String[0]);
        srcDataSet.setTitle(srcFile.getName().replaceFirst("[.][^.]+$", ""));
        srcDataSet.setName(uniqeFileName);
        srcDataSet.setProperty(PROPERTY_IS_DEFAULT, NO_VALUE);
        String ruleVendor = srcDataSet.getProperty(VENDOR);
        if (ruleVendor == null || ruleVendor.isEmpty()) {
            throw new InvalidRuleFileException(TextManager.instance().get("CONVERSION_PANEL_IMPORT_RULES_INVALID_RULES_FILE"));
        }
        srcDataSet.saveToFile(targetPath);
        String ret = null;
        if (ruleVendor.equalsIgnoreCase(this.getCurrentVendor())) {
            RetrivalDataSet dstDataSet = new RetrivalDataSet(this.resourceStandardRuleSet, targetPath);
            this.vendorRuleSetList.add(dstDataSet);
            this.setCurrentDataSet(dstDataSet);
            ret = dstDataSet.getName();
        } else {
            BaseMessageDialog.showMessageDialog(TextManager.instance().get("CAPTURE_DATA_IMPORT"), String.format(TextManager.instance().get("CONVERSION_PANEL_IMPORT_RULES_FILE_DIFFERENT_VENDOR_WAS_IMPORT_FORMAT"), ruleVendor, this.getCurrentVendor()), BaseMessageDialog.TYPE.SUCCESS_MESSAGE, ProcessAlertsManager.instance().getMessages());
        }
        return ret;
    }

    public String getCurrentRulesName() {
        return this.currentRuleSet.getName();
    }

    public String getCurrentRulesTitle() {
        return this.currentRuleSet.getTitle();
    }

    public void deleteDataset(String datsSetName) {
        RulesDataSet dataSet = this.getDataSetByName(datsSetName);
        if (dataSet == null) {
            return;
        }
        dataSet.delete();
        this.vendorRuleSetList.remove(dataSet);
        if (this.currentRuleSet == dataSet) {
            this.setCurrentDataSet(this.standartRuleSet);
        }
    }

    public void loadDataSet(String name) {
        RulesDataSet dataSet = this.standartRuleSet.getName().equals(name) ? this.standartRuleSet : this.getDataSetByName(name);
        if (dataSet == null) {
            return;
        }
        this.setCurrentDataSet(dataSet);
    }

    private void setCurrentDataSet(RulesDataSet dataSet) {
        if (this.currentRuleSet instanceof RetrivalDataSet) {
            ((RetrivalDataSet)this.currentRuleSet).setRulesOnChangedAction(null);
        }
        if (this.currentEditor != null) {
            this.currentEditor.loadData(dataSet);
        }
        this.currentRuleSet = dataSet;
        if (dataSet instanceof RetrivalDataSet) {
            ((RetrivalDataSet)dataSet).setRulesOnChangedAction(() -> {
                if (this.onRuleschangeAction != null) {
                    this.onRuleschangeAction.act();
                }
            });
        }
        if (this.onRuleschangeAction != null) {
            this.onRuleschangeAction.act();
        }
    }

    public RulesDataSet getDataSetByName(String name) {
        if (this.standartRuleSet.getName().equals(name)) {
            return this.standartRuleSet;
        }
        for (RulesDataSet rulesDataSet : this.vendorRuleSetList) {
            if (!rulesDataSet.getName().equals(name)) continue;
            return rulesDataSet;
        }
        return null;
    }

    protected boolean isValid() {
        return this.currentEditor == null || this.currentEditor.isValidRules();
    }

    public String saveAsCurrentData(String newName, String description) {
        String uniqeName = GlobalFunctions.getUniqueFileOrFoldertName(newName + RULE_FILE_ASSOCIATION, this.rulesDirectory.getAbsolutePath());
        File targetFile = new File(this.rulesDirectory.getAbsolutePath() + Globs.DIRSEP + uniqeName);
        String oldRuleName = this.currentRuleSet.getName();
        String oldRuleTitle = this.currentRuleSet.getTitle();
        String oldDescription = this.currentRuleSet.getdescription();
        this.currentRuleSet.setName(uniqeName);
        this.currentRuleSet.setTitle(newName);
        this.currentRuleSet.setProperty(VENDOR, this.getCurrentVendor());
        this.currentRuleSet.setDescription(description);
        this.currentRuleSet.saveToFile(targetFile.toPath());
        this.currentRuleSet.setName(oldRuleName);
        this.currentRuleSet.setTitle(oldRuleTitle);
        if (oldDescription != null) {
            this.currentRuleSet.setDescription(oldDescription);
        }
        RetrivalDataSet newDataSet = new RetrivalDataSet(this.resourceStandardRuleSet, targetFile.toPath());
        this.vendorRuleSetList.add(newDataSet);
        return uniqeName;
    }

    public void saveCurrentData() {
        this.currentRuleSet.saveToFile();
    }

    public void changeVersion(String version) {
        this.currentVersion = version;
        this.resourceStandardRuleSet = this.getResourceStandardFromResourceFile(version);
        this.standartRuleSet = this.getStandartDataFromResourceDataSet();
        if (this.isCurrentRuleIsStandard()) {
            this.setCurrentDataSet(this.standartRuleSet);
        }
        if (this.currentEditor != null) {
            this.currentEditor.setVersion(version);
        }
    }

    private RulesDataSet getResourceStandardFromResourceFile(String version) {
        MetaDataHendler hendler = new MetaDataHendler();
        RulesDataSet resourceStandard = hendler.getDefaultData(this.currentVendorResource, version);
        resourceStandard.setProperty(NAME, STANDART_RULE_NAME);
        resourceStandard.setProperty(VENDOR, this.getCurrentVendor());
        return resourceStandard;
    }

    private RulesDataSet getStandartDataFromResourceDataSet() {
        RetrivalDataSet standardRule = null;
        try {
            File standardRuleFile = File.createTempFile("standardRules", RULE_FILE_ASSOCIATION, new File(Globs.TEMP_DIR));
            standardRuleFile.deleteOnExit();
            Path standardRulepath = standardRuleFile.toPath();
            this.resourceStandardRuleSet.saveToFile(standardRulepath);
            standardRule = new RetrivalDataSet(this.resourceStandardRuleSet, standardRulepath);
        }
        catch (IOException e) {
            ExceptionHandler.writeToExceptionFile(e);
        }
        return standardRule;
    }

    public BaseComponent getEditorComponent() {
        this.guibuilder = new MetaDataHendler();
        this.currentEditor = this.guibuilder.getRulesGuiComponent(this.currentVendorResource, this.currentVersion);
        this.currentEditor.setVersion(this.currentVersion);
        this.setCurrentDataSet(this.currentRuleSet);
        BaseComponent rulesEditorComponent = this.currentEditor.getEditorGuiComponent();
        if (rulesEditorComponent == null) {
            return null;
        }
        this.currentEditor.setValidyChangedAction(() -> rulesEditorComponent.setValid(this.currentEditor.isValidRules()));
        rulesEditorComponent.setValid(this.currentEditor.isValidRules());
        return rulesEditorComponent;
    }

    public String getStandartRuleSetName() {
        return this.standartRuleSet.getName();
    }

    public String getStandartRuleSetTitle() {
        return this.standartRuleSet.getTitle();
    }

    public RulesDataSet getCurrentRules() {
        return this.currentRuleSet;
    }

    public String getDefaultRuleSetName() {
        if (this.defaultRuleSet == null) {
            this.setDafaultRuleSet(this.defaultRuleSet);
        }
        return this.defaultRuleSet.getName();
    }

    public String getRuleSetTitle(String newName) {
        RulesDataSet dataSet = this.getDataSetByName(newName);
        if (dataSet == null) {
            return "";
        }
        return dataSet.getTitle();
    }

    public static String getRuleSetTitle(File ruleSetFile) {
        RulesDataSet dataSet = new RulesDataSet(ruleSetFile.toPath());
        return dataSet.getTitle();
    }

    public boolean isRulesChanged() {
        if (this.currentRuleSet instanceof RetrivalDataSet) {
            return ((RetrivalDataSet)this.currentRuleSet).isRulesSameAsFile();
        }
        return false;
    }

    public void setOnChangeAction(Actionable changeAction) {
        this.onRuleschangeAction = changeAction;
    }

    public void init() {
        this.setCurrentDataSet(this.currentRuleSet);
    }

    public String getHelpTitle() {
        return this.guibuilder.getTabHelpTitle();
    }

    public void restoreCurrentDataSet() {
        this.currentRuleSet.restoreData();
    }

    public boolean isCurrentRuleIsStandard() {
        return this.getCurrentRulesName().equals(this.getStandartRuleSetName());
    }

    public static void destroy() {
        instance = null;
    }

    public static class InvalidRuleFileException
    extends Exception {
        public InvalidRuleFileException(String rulesFileErrorMessage) {
            super(rulesFileErrorMessage);
        }
    }
}

