/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Arrays;

public class RetrivalDataSet
extends RulesDataSet {
    private RulesDataSet unChangebleDataSet;
    private ArrayList<RuleKey> changedRulesList;
    private boolean isdataSetChanged = false;
    private Actionable changeAction;

    public RetrivalDataSet(RulesDataSet metaDataRuleSet, Path ruleSetPath) {
        super(metaDataRuleSet, ruleSetPath);
    }

    @Override
    public void init() {
        super.init();
        this.resetUnchangableDataSet();
    }

    @Override
    public void setData(Object newData, String group, String[] path) {
        super.setData(newData, group, path);
        Object oldValue = this.unChangebleDataSet.getData(group, path);
        newData = super.getData(group, path);
        if (newData != null && this.changeAction != null) {
            RuleKey ruleKey = new RuleKey(group, path);
            if (!oldValue.equals(newData) && !this.changedRulesList.contains(ruleKey)) {
                this.changedRulesList.add(ruleKey);
            }
            if (oldValue.equals(newData) && this.changedRulesList.contains(ruleKey)) {
                this.changedRulesList.remove(ruleKey);
            }
            this.setIsRulesChanged();
        }
    }

    @Override
    public void saveToFile() {
        super.saveToFile();
        this.resetUnchangableDataSet();
    }

    private void resetUnchangableDataSet() {
        this.unChangebleDataSet = new RulesDataSet(this.rulesMetaData, this.ruleSetPath);
        this.changedRulesList = new ArrayList();
        this.changedRulesList.clear();
        this.setIsRulesChanged();
    }

    public void setRulesOnChangedAction(Actionable onchangedAction) {
        this.changeAction = onchangedAction;
    }

    private void setIsRulesChanged() {
        if (this.isdataSetChanged && !this.changedRulesList.isEmpty() || !this.isdataSetChanged && this.changedRulesList.isEmpty()) {
            return;
        }
        boolean bl = this.isdataSetChanged = !this.changedRulesList.isEmpty();
        if (this.changeAction != null) {
            this.changeAction.act();
        }
    }

    public boolean isRulesSameAsFile() {
        return this.isdataSetChanged;
    }

    private class RuleKey {
        private String group;
        private String[] path;

        public RuleKey(String group, String[] path) {
            this.group = group;
            this.path = path;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.getOuterType().hashCode();
            result = 31 * result + (this.group == null ? 0 : this.group.hashCode());
            result = 31 * result + Arrays.hashCode(this.path);
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            RuleKey other = (RuleKey)obj;
            if (!this.getOuterType().equals(other.getOuterType())) {
                return false;
            }
            if (this.group == null ? other.group != null : !this.group.equals(other.group)) {
                return false;
            }
            return Arrays.equals(this.path, other.path);
        }

        private RetrivalDataSet getOuterType() {
            return RetrivalDataSet.this;
        }

        public String toString() {
            return this.group + Arrays.toString(this.path);
        }
    }
}

