/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.common.Table;
import com.bmc.ctmconvert.rules.ChangingComponentData;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.Map;

public class PairsListData
extends ChangingComponentData {
    private ArrayList<Map.Entry<String, String>> list = new ArrayList();

    public PairsListData(String name, String componentGroupName) {
        super(name, componentGroupName);
    }

    @Override
    public ArrayList<Map.Entry<String, String>> getData() {
        return this.list;
    }

    @Override
    public void setData(Object data) {
        if (data instanceof ArrayList || data instanceof Table) {
            this.putDataInList(data);
            super.setData(this.list);
        }
    }

    private void putDataInList(Object data) {
        if (data instanceof ArrayList) {
            ArrayList listData = (ArrayList)data;
            this.list.clear();
            for (Object obj : listData) {
                if (obj == null || !(obj instanceof Map.Entry)) continue;
                Map.Entry entrydata = (Map.Entry)obj;
                Object keyObj = entrydata.getKey();
                Object valueObj = entrydata.getValue();
                if (keyObj == null || !(keyObj instanceof String) || valueObj == null || !(valueObj instanceof String)) continue;
                String key = (String)keyObj;
                String value = (String)valueObj;
                this.list.add(new AbstractMap.SimpleEntry<String, String>(key, value));
            }
        } else if (data instanceof Table) {
            Table tableData = (Table)data;
            this.list.clear();
            for (int i = 0; i < tableData.getRowCount(); ++i) {
                if (!tableData.hasValueAt(i, 0)) continue;
                String key = tableData.getValueAt(i, 0);
                String value = "";
                if (tableData.hasValueAt(i, 1)) {
                    value = tableData.getValueAt(i, 1);
                }
                this.list.add(new AbstractMap.SimpleEntry<String, String>(key, value));
            }
        } else {
            return;
        }
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return DataRetrievable.DataType.PAIRS_LIST;
    }

    public String toString() {
        return "HashData [list=" + String.valueOf(this.list) + "]";
    }

    @Override
    protected void storeValue(Object value) {
        this.putDataInList(value);
        super.storeValue(value);
    }
}

