/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.Activable;
import com.bmc.ctmconvert.base.BaseButton;
import com.bmc.ctmconvert.base.BaseButtonGroup;
import com.bmc.ctmconvert.base.BaseCheckBox;
import com.bmc.ctmconvert.base.BaseComboBox;
import com.bmc.ctmconvert.base.BaseComponent;
import com.bmc.ctmconvert.base.BaseComponentWrapper;
import com.bmc.ctmconvert.base.BaseContentPanel;
import com.bmc.ctmconvert.base.BaseField;
import com.bmc.ctmconvert.base.BaseLinkLabel;
import com.bmc.ctmconvert.base.BasePanel;
import com.bmc.ctmconvert.base.BaseRadioButton;
import com.bmc.ctmconvert.base.BaseSection;
import com.bmc.ctmconvert.base.BaseSpinner;
import com.bmc.ctmconvert.base.BaseTabbedPane;
import com.bmc.ctmconvert.base.BaseTableAddRemoveWrapper;
import com.bmc.ctmconvert.base.BaseTextArea;
import com.bmc.ctmconvert.base.BaseTextContainer;
import com.bmc.ctmconvert.base.BaseTextField;
import com.bmc.ctmconvert.base.ButtonFactory;
import com.bmc.ctmconvert.common.ExceptionHandler;
import com.bmc.ctmconvert.common.FlowGlobals;
import com.bmc.ctmconvert.common.GlobalFunctions;
import com.bmc.ctmconvert.common.Params;
import com.bmc.ctmconvert.common.TextManager;
import com.bmc.ctmconvert.common.xml.XmlElement;
import com.bmc.ctmconvert.common.xml.XmlLoader;
import com.bmc.ctmconvert.configuration.ThemeConfiguration;
import com.bmc.ctmconvert.rules.DisabledComboBoxModel;
import com.bmc.ctmconvert.rules.EnabledJComboBoxRenderer;
import com.bmc.ctmconvert.rules.FieldComboElement;
import com.bmc.ctmconvert.rules.FieldEditorPanel;
import com.bmc.ctmconvert.rules.GuiRuleComponent;
import com.bmc.ctmconvert.rules.GuiRuleContainerComponent;
import com.bmc.ctmconvert.rules.GuiRuleGroupComponent;
import com.bmc.ctmconvert.rules.PairsListData;
import com.bmc.ctmconvert.rules.Rule;
import com.bmc.ctmconvert.rules.RulesContainer;
import com.bmc.ctmconvert.rules.RulesDataSet;
import com.bmc.ctmconvert.rules.RulesEditor;
import com.bmc.ctmconvert.rules.StringData;
import com.bmc.ctmconvert.rules.StringReplaceComponent;
import com.bmc.ctmconvert.rules.VersionRange;
import com.bmc.ctmconvert.rules.validators.EmailValidator;
import com.bmc.ctmconvert.rules.validators.LenghValidator;
import com.bmc.ctmconvert.rules.validators.PermitedValuesValidator;
import com.bmc.ctmconvert.services.settings.SettingsBooleanKeys;
import java.awt.Dimension;
import java.awt.event.ActionListener;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.DefaultCellEditor;
import javax.swing.JComboBox;
import javax.swing.JMenuItem;
import javax.swing.JPanel;
import javax.swing.JPopupMenu;
import javax.swing.JTable;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.TableColumn;

public class MetaDataHendler {
    public static final String XML_TAG_RULE_FIELD = "RULE_FIELD";
    public static final String XML_ATTR_TYPE = "TYPE";
    private static final String XML_TAG_RULE_TAB = "RULE_TAB";
    private static final String XML_TAG_RULE_SECTION = "RULE_SECTION";
    private static final String XML_TAG_DEPENDENCY_CONDOTION = "DEPENDENCY_CONDOTION";
    private static final String XML_ATTR_TITLE = "TITLE";
    private static final String XML_ATTR_HELP_TITLE = "HELP_TITLE";
    public static final String XML_TAG_ITEM = "ITEM";
    public static final String XML_ATTR_NAME = "NAME";
    private static final String XML_ATTR_GROUP = "GROUP";
    private static final String XML_ATTR_RULE_TYPE = "RULE_TYPE";
    private static final String ADDREMOVETABLE = "addremovetable";
    private static final String RULES_CONTAINER = "RULES_CONTAINER";
    private static final String XML_ATTR_VALIDATOR_TYPE = "VALIDATOR_TYPE";
    private static final String RADIO_TYPE = "radio";
    public static final String CHECK_BOX = "check_box";
    public static final String SELECT_LIST = "select_list";
    public static final String TEXT = "text";
    public static final String TEXT_AREA = "text_area";
    public static final String TITLE = "title";
    public static final String SPINNER = "spinner";
    public static final String STRING_REPLACER = "replaceStrings";
    public static final Object TEXT_WITH_CHOICE = "text_with_choice";
    public static final String LINK = "link";
    public static final String XML_ATTR_GUI_TYPE = "GUI_TYPE";
    private static final String XML_ATTR_LINK = "LINK";
    private static final String XML_TAG_ALLOWED_VALUES = "ALLOWED_VALUES";
    private static final String XML_TAG_RULE_DEFAULT_VALUES = "DEFAULT_VALUE";
    private static final String XML_ATTR_KEY = "KEY";
    private static final String XML_ATTR_VALUE = "VALUE";
    public static final String XML_ATTR_TARGET_VERSION = "TARGET_VERSION";
    public static final String XML_ATTR_TARGET_ENVIRONMENT = "TARGET_ENVIRONMENT";
    public static final String FIELD_EDITOR = "Field_Editor";
    public static final String XML_ATTR_RESET_VALUE = "RESET_VALUE";
    public static final String XML_ATTR_MANDATORY = "MANDATORY";
    public static final String FORMAT_VALUE = "FORMAT_VALUE";
    public static final String XML_TAG_RULE = "RULE";
    public static final String XML_TAG_RULE_ITEM = "RULE_ITEM";
    public static final String XML_ATTR_MAX_CHARACTER = "MAX_CHARACTERS";
    public static final String XML_ATTR_MIN_CHARACTER = "MIN_CHARACTERS";
    public static final String XML_ATTR_ORIENTATION = "ORIENTATION";
    private static final String VERTICAL = "vertical";
    public static final String XML_ATTR_DEFAULT_VALUE = "DEFAULT_VALUE";
    public static final String XML_ATTR_MAX_VALUE = "MAX_VALUE";
    public static final String XML_ATTR_MIN_VALUE = "MIN_VALUE";
    public static final String XML_TAG_DELIMITER = "DELIMITER";
    public static final String XML_TAG_PREFIX = "PREFIX";
    public static final String XML_TAG_SUFFIX = "SUFFIX";
    public static final String XML_ATTR_VALUE_DELIMITER = "DELIMITER";
    public static final String XML_TAG_FORMAT = "FORMAT";
    public static final String XML_ATTR_GRAY_TEXT = "GRAY_TEXT";
    public static final String XML_ATTR_VALUE_FORMAT = "FORMAT";
    public static final String XML_TAG_FORMAT_OPTIONS = "FORMAT_OPTIONS";
    private XmlElement guiRuleXmlElement;
    private ArrayList<GuiRuleComponent> componentList;
    private String version;
    private BaseTabbedPane baseTabbedPane;
    private String[] helpTitles;

    public RulesEditor getRulesGuiComponent(File currentVendorResource, String version) {
        XmlLoader loader = new XmlLoader();
        try {
            loader.loadFile(this.getRulesInputStream(currentVendorResource));
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile(e);
            return null;
        }
        this.guiRuleXmlElement = loader.getXmlElement();
        this.version = version;
        this.componentList = new ArrayList();
        this.initialize();
        return new RulesEditor(this.baseTabbedPane, this.componentList);
    }

    public RulesDataSet getDefaultData(File currentVendorResource, String ctmVersion) {
        XmlLoader loader = new XmlLoader();
        try {
            loader.loadFile(this.getRulesInputStream(currentVendorResource));
        }
        catch (Exception e) {
            ExceptionHandler.writeToExceptionFile("gui rule xml file : " + e.getMessage());
            return null;
        }
        RulesDataSet dataSet = new RulesDataSet();
        XmlElement dataElement = loader.getXmlElement();
        if (dataElement == null) {
            ExceptionHandler.writeToExceptionFile(loader.getErrorMessage());
            return null;
        }
        List<XmlElement> ruleElementList = dataElement.getAllDecnedElementByName(XML_TAG_RULE_FIELD);
        for (XmlElement ruleElement : ruleElementList) {
            String ruleGroup = ruleElement.getAttribute(XML_ATTR_GROUP);
            String ruleName = ruleElement.getAttribute(XML_ATTR_NAME);
            String ruletype = ruleElement.getAttribute(XML_ATTR_RULE_TYPE);
            Rule rule = ruletype.equals(RULES_CONTAINER) ? this.getMultyRule(ruleElement, ctmVersion) : this.getDataFromElement(ctmVersion, ruleElement);
            if (rule == null) continue;
            dataSet.addRule(ruleGroup, ruleName, rule);
        }
        return dataSet;
    }

    InputStream getRulesInputStream(File currentVendorResource) throws IOException {
        String rulesContent = Files.readString(currentVendorResource.toPath());
        String processedRulesContent = ThemeConfiguration.get().processRulesContent(rulesContent);
        return new ByteArrayInputStream(processedRulesContent.getBytes(StandardCharsets.UTF_8));
    }

    private Rule getDataFromElement(String ctmVersion, XmlElement ruleElement) {
        String ruleName = ruleElement.getAttribute(XML_ATTR_NAME);
        String ruletype = ruleElement.getAttribute(XML_ATTR_RULE_TYPE);
        String ruleVersion = ruleElement.getAttribute(XML_ATTR_TARGET_VERSION);
        VersionRange ruleVersionRange = new VersionRange(ruleVersion);
        if (!ruleVersionRange.isInRange(ctmVersion)) {
            return null;
        }
        XmlElement defaultElement = this.getDefaultValusElement(ruleElement, ctmVersion);
        if (ruletype.equals("BOOLEAN")) {
            String ruleValue = defaultElement.getAttribute(XML_ATTR_VALUE);
            Boolean val = null;
            if (defaultElement != null) {
                if (ruleValue.equalsIgnoreCase("Y") || ruleValue.equalsIgnoreCase("YES")) {
                    val = true;
                } else if (ruleValue.equalsIgnoreCase("N") || ruleValue.equalsIgnoreCase("NO")) {
                    val = false;
                }
            }
            return new Rule(ruleName, val);
        }
        if (ruletype.equals("STRING")) {
            String ruleValue = null;
            if (defaultElement != null) {
                ruleValue = defaultElement.getAttribute(XML_ATTR_VALUE);
            }
            return new Rule(ruleName, ruleValue);
        }
        if (ruletype.equals("LIST")) {
            ArrayList<String> itemList = new ArrayList<String>();
            if (defaultElement != null) {
                itemList = defaultElement.getDirectChildsElementAttrByName(XML_TAG_ITEM, XML_ATTR_VALUE);
            }
            return new Rule(ruleName, itemList);
        }
        if (ruletype.equals("KEY_VALUE")) {
            ArrayList<Map.Entry<String, String>> entrisList = new ArrayList<Map.Entry<String, String>>();
            if (defaultElement != null) {
                List<XmlElement> itemList = defaultElement.getDirectchildsElementbyName(XML_TAG_ITEM);
                for (XmlElement itemElement : itemList) {
                    String key = itemElement.getAttribute(XML_ATTR_KEY);
                    String value = itemElement.getAttribute(XML_ATTR_VALUE);
                    entrisList.add(new AbstractMap.SimpleEntry<String, String>(key, value));
                }
            }
            return new Rule(ruleName, entrisList, Map.Entry.class);
        }
        if (ruletype.equals("INTEGER")) {
            String stringValue;
            Integer ruleValue = null;
            if (defaultElement != null && GlobalFunctions.isNumber(stringValue = defaultElement.getAttribute(XML_ATTR_VALUE))) {
                ruleValue = Integer.parseInt(stringValue);
            }
            return new Rule(ruleName, ruleValue);
        }
        if (ruletype.equals(RULES_CONTAINER)) {
            return this.getMultyRule(ruleElement, ctmVersion);
        }
        return null;
    }

    private RulesContainer getMultyRule(XmlElement ruleElement, String ctmVersion) {
        String ruleName = ruleElement.getAttribute(XML_ATTR_NAME);
        RulesContainer multyRule = new RulesContainer(ruleName);
        List<XmlElement> childRules = ruleElement.getDirectchildsElementbyName(XML_TAG_RULE_ITEM);
        for (XmlElement child : childRules) {
            String childtype = child.getAttribute(XML_ATTR_RULE_TYPE);
            String childRange = child.getAttribute(XML_ATTR_TARGET_VERSION);
            if (!VersionRange.isInRange(childRange, ctmVersion).booleanValue()) continue;
            Rule childRule = childtype.equals(RULES_CONTAINER) ? this.getMultyRule(child, ctmVersion) : this.getDataFromElement(ctmVersion, child);
            multyRule.add(childRule);
        }
        return multyRule;
    }

    private XmlElement getDefaultValusElement(XmlElement ruleElement, String ctmVersion) {
        List<XmlElement> DefaultValusElementList = ruleElement.getDirectchildsElementbyName("DEFAULT_VALUE");
        for (XmlElement defaultElement : DefaultValusElementList) {
            VersionRange defaultRange = new VersionRange(defaultElement.getAttribute(XML_ATTR_TARGET_VERSION));
            if (!defaultRange.isInRange(ctmVersion)) continue;
            return defaultElement;
        }
        return null;
    }

    private void initialize() {
        this.baseTabbedPane = new BaseTabbedPane();
        ArrayList<RuleTab> rulesTabs = this.getRulesTabsFromXml();
        this.helpTitles = new String[rulesTabs.size()];
        int index = 0;
        for (RuleTab tab : rulesTabs) {
            this.helpTitles[index++] = tab.getTabHelpName();
            this.baseTabbedPane.addTab(tab.getTabName(), tab.getComponent());
        }
    }

    public String getTabHelpTitle() {
        return this.helpTitles[this.baseTabbedPane.getSelectedIndex()];
    }

    private ArrayList<RuleTab> getRulesTabsFromXml() {
        ArrayList<RuleTab> tabList = new ArrayList<RuleTab>();
        List<XmlElement> tagElements = this.guiRuleXmlElement.getDirectchildsElementbyName(XML_TAG_RULE_TAB);
        for (XmlElement tabElement : tagElements) {
            RuleTab tab = new RuleTab(tabElement, this.version, this.componentList);
            tabList.add(tab);
        }
        return tabList;
    }

    public static class RuleTab
    extends BasePanel {
        public static final String ON_PREMISE_ENVIRONMENT = "ON_PREMISE";
        public static final String SAAS_ENVIRONMENT = "SAAS";
        private final List<GuiRuleComponent> componentList;
        XmlElement tabElement;
        String tabName;
        String tabHelpName;
        String ctmVersion;
        BaseContentPanel baseContentPanel;

        public RuleTab(XmlElement tabElement, String ctmVersion, List<GuiRuleComponent> componentList) {
            this.tabElement = tabElement;
            this.ctmVersion = ctmVersion;
            this.componentList = componentList;
            this.tabName = tabElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
            this.tabHelpName = tabElement.getAttribute(MetaDataHendler.XML_ATTR_HELP_TITLE);
            this.init();
        }

        private void init() {
            this.baseContentPanel = new BaseContentPanel();
            this.baseContentPanel.setBorder(null);
            List<XmlElement> sectionElements = this.tabElement.getDirectchildsElementbyName(MetaDataHendler.XML_TAG_RULE_SECTION);
            for (XmlElement sectionElement : sectionElements) {
                BaseSection section = this.getSectionsXml(sectionElement);
                if (!this.shouldAddSection(section, sectionElement)) continue;
                this.baseContentPanel.addSection(section);
            }
            this.baseContentPanel.buildContentPanel();
            this.setContentPanel(this.baseContentPanel);
        }

        private boolean shouldAddSection(BaseSection section, XmlElement sectionElement) {
            return !section.getFields().isEmpty() && !this.shouldHideElement(sectionElement);
        }

        private BaseSection getSectionsXml(XmlElement sectionElement) {
            String sectionName = sectionElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
            BaseSection section = new BaseSection(sectionName);
            List<XmlElement> ruleFiledList = sectionElement.getDirectchildsElementbyName(MetaDataHendler.XML_TAG_RULE_FIELD);
            for (XmlElement fieldElement : ruleFiledList) {
                String GuiType = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GUI_TYPE);
                if (GuiType.equals(MetaDataHendler.FIELD_EDITOR)) {
                    return this.getFieldEditorToSection(fieldElement);
                }
                GuiRuleComponent component = this.addFieldElementToSection(section, fieldElement);
                if (component == null) continue;
                this.componentList.add(component);
            }
            return section;
        }

        private GuiRuleComponent addFieldElementToSection(BaseSection section, XmlElement fieldElement) {
            return this.addFieldElementToSection(section, fieldElement, null);
        }

        private GuiRuleComponent addFieldElementToSection(BaseSection section, XmlElement fieldElement, Integer padding) {
            if (this.shouldHideElement(fieldElement)) {
                return null;
            }
            String title = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
            String name = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
            String version = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
            String ruleGroup = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
            String GuiType = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GUI_TYPE);
            GuiRuleComponent ret = null;
            if (GuiType.equals(MetaDataHendler.RADIO_TYPE)) {
                ret = this.createRadioButttonsPanel(section, fieldElement);
            } else if (GuiType.equals(MetaDataHendler.CHECK_BOX)) {
                BaseCheckBox checkBox = new BaseCheckBox(title, name, ruleGroup);
                checkBox.setBackground(FlowGlobals.ConversionWhite);
                BaseField checkBoxField = new BaseField(checkBox);
                if (padding != null) {
                    checkBoxField.setPadding(padding);
                }
                checkBoxField.setValid(false);
                VersionRange range = new VersionRange(version);
                GuiRuleComponent checkBoxComponent = new GuiRuleComponent(checkBoxField, range);
                section.addField(checkBoxField);
                this.handleElementDependencys(checkBoxComponent, Boolean.TRUE, fieldElement, section);
                ret = checkBoxComponent;
            } else if (GuiType.equals(MetaDataHendler.LINK)) {
                ret = this.createLinkFile(section, fieldElement, version);
            } else if (GuiType.equals(MetaDataHendler.TITLE)) {
                ret = this.createTitle(section, fieldElement, version);
            } else if (GuiType.equals(MetaDataHendler.TEXT)) {
                ret = this.insertTextFieldToSection(section, fieldElement, padding);
            } else if (GuiType.equals(MetaDataHendler.ADDREMOVETABLE)) {
                ret = this.addRemoveTableToSection(section, fieldElement, padding);
            } else if (GuiType.equals(MetaDataHendler.SELECT_LIST)) {
                ret = this.insertComboBoxToSection(section, fieldElement, ruleGroup, title, name, version, padding);
            } else if (GuiType.equals(MetaDataHendler.TEXT_AREA)) {
                ret = this.insertTextAreaToSection(section, fieldElement, ruleGroup, title, name, version, padding);
            } else if (GuiType.equals(MetaDataHendler.SPINNER)) {
                ret = this.insertSpinnerToSection(section, fieldElement, padding);
            } else if (GuiType.equals(MetaDataHendler.STRING_REPLACER)) {
                ret = this.insertCondionsFieldsToSection(section, fieldElement, padding);
            } else if (GuiType.equals(TEXT_WITH_CHOICE)) {
                ret = this.insertTextWithCoiceToSection(section, fieldElement, padding);
            }
            String validatorType = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_VALIDATOR_TYPE);
            if (validatorType != null && !validatorType.isEmpty() && validatorType.equals("MAIL_ADDRESS")) {
                ret.setValidator(new EmailValidator());
            }
            return ret;
        }

        private GuiRuleComponent addRemoveTableToSection(BaseSection section, XmlElement fieldElement, Integer padding) {
            String ruleName = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
            String ruleGroup = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
            String ruleTargetVersion = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
            ArrayList<String> headers = fieldElement.getDirectChildsElementAttrByName(MetaDataHendler.XML_TAG_ITEM, MetaDataHendler.XML_ATTR_TITLE);
            XmlElement cellValuesElement = fieldElement.getFirstChildElementByName(MetaDataHendler.XML_TAG_ALLOWED_VALUES);
            ArrayList<String> cellValues = null;
            if (cellValuesElement != null) {
                cellValues = cellValuesElement.getDirectChildsElementAttrByName(MetaDataHendler.XML_TAG_ITEM, MetaDataHendler.XML_ATTR_VALUE);
            }
            JTable table = this.initTable(headers, cellValues);
            BaseTableAddRemoveWrapper baseTable = new BaseTableAddRemoveWrapper(table, ruleName, ruleGroup);
            table.setName(ruleName);
            VersionRange range = new VersionRange(ruleTargetVersion);
            GuiRuleComponent addRemoveTableComponent = new GuiRuleComponent(baseTable, range);
            BaseField FilterJobsTableField = new BaseField(baseTable);
            if (padding != null) {
                FilterJobsTableField.setPadding(padding);
            }
            section.addField(FilterJobsTableField);
            return addRemoveTableComponent;
        }

        private JTable initTable(ArrayList<String> headerList, ArrayList<String> cellFieldValues) {
            JTable jtable = new JTable();
            DefaultTableModel tableModel = new DefaultTableModel();
            if (headerList != null && !headerList.isEmpty()) {
                for (String header : headerList) {
                    tableModel.addColumn(header);
                }
            }
            jtable.setModel(tableModel);
            jtable.setRowHeight(18);
            jtable.setSelectionMode(0);
            jtable.getTableHeader().setReorderingAllowed(false);
            TableColumn ctmFieldsColumn = jtable.getColumnModel().getColumn(0);
            JComboBox<String> comboBox = new JComboBox<String>();
            if (cellFieldValues != null && !cellFieldValues.isEmpty()) {
                for (String val : cellFieldValues) {
                    comboBox.addItem(val);
                }
                ctmFieldsColumn.setCellEditor(new DefaultCellEditor(comboBox));
            }
            return jtable;
        }

        private boolean shouldHideElement(XmlElement fieldElement) {
            String targetEnvironment = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_ENVIRONMENT);
            return this.shouldHideRule(targetEnvironment);
        }

        private boolean shouldHideRule(String targetEnvironment) {
            if (targetEnvironment.isBlank()) {
                return false;
            }
            if (SettingsBooleanKeys.isSaas()) {
                return ON_PREMISE_ENVIRONMENT.equals(targetEnvironment);
            }
            return SAAS_ENVIRONMENT.equals(targetEnvironment);
        }

        private GuiRuleComponent createTitle(BaseSection section, XmlElement fieldElement, String version) {
            String title = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
            title = title.replaceAll("/n", System.getProperty("line.separator"));
            BaseTextContainer baseTextContainer = new BaseTextContainer(title);
            baseTextContainer.setAutoResize(false);
            BaseField textBaseField = new BaseField(baseTextContainer);
            VersionRange range = new VersionRange(version);
            GuiRuleComponent textComponent = new GuiRuleComponent(textBaseField, range);
            section.addField(textBaseField);
            return textComponent;
        }

        private GuiRuleComponent createLinkFile(BaseSection section, XmlElement fieldElement, String version) {
            Object filesPath = Params.instance().getDatasourcePath();
            String linkFile = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_LINK);
            filesPath = (String)filesPath + linkFile;
            String linkDirectory = "file:///" + ((String)filesPath).replace('\\', '/');
            String linkName = "<html>" + fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME) + "</html>";
            BaseLinkLabel baseLinkLabel = new BaseLinkLabel(linkDirectory, linkName);
            baseLinkLabel.setFont(FlowGlobals.FONT_STYLE_ARIAL_MS_UNICODE);
            VersionRange range = new VersionRange(version);
            GuiRuleComponent linkComponent = new GuiRuleComponent(baseLinkLabel, range);
            BaseField linkField = new BaseField(baseLinkLabel);
            section.addField(linkField);
            return linkComponent;
        }

        private GuiRuleComponent insertTextWithCoiceToSection(BaseSection section, XmlElement fieldElement, Integer padding) {
            String name = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
            String version = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
            String ruleGroup = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
            XmlElement AllowedElemet = fieldElement.getFirstChildElementByName(MetaDataHendler.XML_TAG_ALLOWED_VALUES);
            String grayText = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GRAY_TEXT);
            BaseTextField textWithCoice = new BaseTextField(name, ruleGroup);
            JPanel format = new JPanel();
            JPopupMenu popupMenu = new JPopupMenu();
            format.setLayout(new BoxLayout(format, 0));
            final BaseButton menuButton = ButtonFactory.createButton(ButtonFactory.ButtonType.FIELD_EDITOR_MENU, e -> popupMenu.show(format, ((BaseButton)e.getSource()).getX() + (int)((BaseButton)e.getSource()).getSize().getWidth(), ((BaseButton)e.getSource()).getY()));
            format.add(menuButton);
            format.add(Box.createRigidArea(new Dimension(5, 0)));
            final BaseButton resetButton = ButtonFactory.createButton(ButtonFactory.ButtonType.RESET, e -> textWithCoice.setText(""));
            resetButton.setToolTipText(TextManager.instance().get("MAIN_NAVIGATION_RESET_TOOLTIP"));
            format.add(resetButton);
            ActionListener actionListener = e -> textWithCoice.setText(textWithCoice.getText() + "{" + e.getActionCommand() + "}");
            ArrayList<String> formatList = AllowedElemet.getDirectChildsElementAttrByName(MetaDataHendler.XML_TAG_ITEM, MetaDataHendler.XML_ATTR_VALUE);
            for (String choice : formatList) {
                JMenuItem menuItem = new JMenuItem(choice);
                menuItem.addActionListener(actionListener);
                popupMenu.add(menuItem);
            }
            textWithCoice.setExtraComponent(format);
            VersionRange range = new VersionRange(version);
            BaseField textWithCoiceField = new BaseField((BaseComponent)textWithCoice, grayText);
            if (padding != null) {
                textWithCoiceField.setPadding(padding);
            }
            GuiRuleComponent textWithCoiceComponenet = new GuiRuleComponent(textWithCoiceField, range);
            textWithCoiceComponenet.setErrorComponent(textWithCoiceField);
            textWithCoiceComponenet.addAssistingConponent(new Activable(){

                @Override
                public void setActive(Boolean b) {
                    resetButton.setEnabled(b);
                    menuButton.setEnabled(b);
                }

                @Override
                public boolean isActive() {
                    return resetButton.isEnabled() && menuButton.isEnabled();
                }
            });
            section.addField(textWithCoiceField);
            return textWithCoiceComponenet;
        }

        private GuiRuleComponent insertCondionsFieldsToSection(BaseSection section, XmlElement fieldElement, Integer padding) {
            String name = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
            String version = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
            String ruleGroup = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
            XmlElement grayFieldElemet = fieldElement.getFirstChildElementByAttrValue(MetaDataHendler.XML_TAG_RULE_ITEM, MetaDataHendler.XML_ATTR_NAME, "FORMAT");
            XmlElement delimitrElemet = fieldElement.getFirstChildElementByAttrValue(MetaDataHendler.XML_TAG_RULE_ITEM, MetaDataHendler.XML_ATTR_NAME, "DELIMITER");
            XmlElement prefixElemet = fieldElement.getFirstChildElementByAttrValue(MetaDataHendler.XML_TAG_RULE_ITEM, MetaDataHendler.XML_ATTR_NAME, MetaDataHendler.XML_TAG_PREFIX);
            XmlElement suffixElemet = fieldElement.getFirstChildElementByAttrValue(MetaDataHendler.XML_TAG_RULE_ITEM, MetaDataHendler.XML_ATTR_NAME, MetaDataHendler.XML_TAG_SUFFIX);
            XmlElement formatOptionsComboElemet = fieldElement.getFirstChildElementByAttrValue(MetaDataHendler.XML_TAG_RULE_ITEM, MetaDataHendler.XML_ATTR_NAME, MetaDataHendler.XML_TAG_FORMAT_OPTIONS);
            XmlElement formatOptionsAllowedElemet = formatOptionsComboElemet.getFirstChildElementByName(MetaDataHendler.XML_TAG_ALLOWED_VALUES);
            if (delimitrElemet == null || prefixElemet == null || suffixElemet == null) {
                return null;
            }
            VersionRange range = new VersionRange(version);
            GuiRuleContainerComponent condionsConventionRuleContainer = new GuiRuleContainerComponent(ruleGroup, name, range);
            BaseTextField formatTextField = new BaseTextField("FORMAT", "");
            formatTextField.setEnabled(false);
            StringReplaceComponent mainComponent = new StringReplaceComponent(formatTextField, range);
            condionsConventionRuleContainer.add(mainComponent);
            BaseTextField delimetertextField = new BaseTextField("DELIMITER", "");
            BaseField delimeterBaseField = new BaseField((BaseComponent)delimetertextField, delimitrElemet.getAttribute(MetaDataHendler.XML_ATTR_TITLE));
            section.addField(delimeterBaseField);
            GuiRuleComponent delimeterComponent = new GuiRuleComponent(delimeterBaseField, range);
            mainComponent.setDelimiterComponent(delimeterComponent);
            condionsConventionRuleContainer.add(delimeterComponent);
            BaseTextField prefixtextField = new BaseTextField(MetaDataHendler.XML_TAG_PREFIX, "");
            BaseField prefixBaseField = new BaseField((BaseComponent)prefixtextField, prefixElemet.getAttribute(MetaDataHendler.XML_ATTR_TITLE));
            section.addField(prefixBaseField);
            GuiRuleComponent prefixComponent = new GuiRuleComponent(prefixBaseField, range);
            mainComponent.setPrefixComponent(prefixComponent);
            condionsConventionRuleContainer.add(prefixComponent);
            BaseTextField suffixtextField = new BaseTextField(MetaDataHendler.XML_TAG_SUFFIX, "");
            BaseField suffixBaseField = new BaseField((BaseComponent)suffixtextField, suffixElemet.getAttribute(MetaDataHendler.XML_ATTR_TITLE));
            section.addField(suffixBaseField);
            GuiRuleComponent suffixComponent = new GuiRuleComponent(suffixBaseField, range);
            mainComponent.setsuffixComponent(suffixComponent);
            condionsConventionRuleContainer.add(suffixComponent);
            BaseField optionsTitle = new BaseField(null, formatOptionsComboElemet.getAttribute(MetaDataHendler.XML_ATTR_TITLE));
            section.addField(optionsTitle);
            ArrayList<String> formatList = formatOptionsAllowedElemet.getDirectChildsElementAttrByName(MetaDataHendler.XML_TAG_ITEM, MetaDataHendler.XML_ATTR_VALUE);
            BaseComboBox formatComboBox = new BaseComboBox(formatList.toArray(), MetaDataHendler.XML_TAG_FORMAT_OPTIONS, "");
            BaseField formatComboBaseField = new BaseField(formatComboBox);
            GuiRuleComponent formatComponent = new GuiRuleComponent(formatComboBaseField, range);
            formatComponent.addAssistingConponent(optionsTitle);
            section.addField(formatComboBaseField);
            mainComponent.setOptionComponent(formatComponent);
            condionsConventionRuleContainer.add(formatComponent);
            BaseField formatTitle = new BaseField(null, grayFieldElemet.getAttribute(MetaDataHendler.XML_ATTR_TITLE));
            mainComponent.addAssistingConponent(formatTitle);
            section.addField(formatTitle);
            BaseField formatTextBaseField = new BaseField(formatTextField);
            section.addField(formatTextBaseField);
            if (padding != null) {
                delimeterBaseField.setPadding(padding);
                prefixBaseField.setPadding(padding);
                suffixBaseField.setPadding(padding);
                formatComboBaseField.setPadding(padding);
                formatTitle.setPadding(padding);
                formatTextBaseField.setPadding(padding);
            }
            return condionsConventionRuleContainer;
        }

        private GuiRuleComponent insertSpinnerToSection(BaseSection section, XmlElement fieldElement, Integer padding) {
            String title = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
            String name = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
            String version = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
            String ruleGroup = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
            String maxValue = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_MAX_VALUE);
            String minValue = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_MIN_VALUE);
            String defaultValue = fieldElement.getAttribute("DEFAULT_VALUE");
            GuiRuleComponent spinnerComponent = null;
            if (GlobalFunctions.isNumber(maxValue) && GlobalFunctions.isNumber(minValue) && GlobalFunctions.isNumber(defaultValue)) {
                int maxValueInt = Integer.parseInt(maxValue);
                int minValueInt = Integer.parseInt(minValue);
                int defaultValueInt = Integer.parseInt(defaultValue);
                BaseSpinner spinner = new BaseSpinner(name, ruleGroup, defaultValueInt, minValueInt, maxValueInt);
                VersionRange range = new VersionRange(version);
                BaseField spinnerBaseField = new BaseField((BaseComponent)spinner, title);
                if (padding != null) {
                    spinnerBaseField.setPadding(padding);
                }
                spinnerComponent = new GuiRuleComponent(spinnerBaseField, range);
                section.addField(spinnerBaseField);
            }
            return spinnerComponent;
        }

        private GuiRuleComponent insertTextAreaToSection(BaseSection section, XmlElement fieldElement, String ruleGroup, String title, String name, String version, Integer padding) {
            BaseTextArea textArea = new BaseTextArea(ruleGroup, name, "", "");
            VersionRange range = new VersionRange(version);
            GuiRuleComponent textAreaComponent = new GuiRuleComponent(textArea, range);
            textAreaComponent.setErrorComponent(textArea);
            BaseField textAreaBaseField = new BaseField((BaseComponent)textArea, title, true);
            if (padding != null) {
                textAreaBaseField.setPadding(padding);
            }
            section.addField(textAreaBaseField);
            this.setLenghValidator(textAreaComponent, fieldElement);
            return textAreaComponent;
        }

        private GuiRuleComponent insertTextFieldToSection(BaseSection section, XmlElement fieldElement, Integer padding) {
            String title = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
            String name = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
            String version = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
            String ruleGroup = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
            String MandatoryAttr = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_MANDATORY);
            boolean isMandatory = MandatoryAttr != null && (MandatoryAttr.equalsIgnoreCase("Y") || MandatoryAttr.equalsIgnoreCase("YES"));
            BaseTextField jTextField = new BaseTextField(name, ruleGroup);
            BaseField textBaseField = new BaseField((BaseComponent)jTextField, title, isMandatory);
            if (padding != null) {
                textBaseField.setPadding(padding);
            }
            section.addField(textBaseField);
            VersionRange range = new VersionRange(version);
            GuiRuleComponent textComponent = new GuiRuleComponent(textBaseField, range);
            textComponent.setErrorComponent(textBaseField);
            this.setLenghValidator(textComponent, fieldElement);
            return textComponent;
        }

        private GuiRuleComponent insertComboBoxToSection(BaseSection section, XmlElement fieldElement, String ruleGroup, String title, String name, String version, Integer padding) {
            DisabledComboBoxModel comboModel = new DisabledComboBoxModel();
            BaseComboBox comboBox = new BaseComboBox(this, comboModel, name, ruleGroup){

                @Override
                public Object getData() {
                    Object ret = super.getData();
                    if (ret instanceof FieldComboElement) {
                        return ((FieldComboElement)ret).getValue();
                    }
                    return super.getData();
                }

                @Override
                public void setData(Object obj) {
                    if (obj instanceof String) {
                        String stringObj = (String)obj;
                        FieldComboElement comboElementObj = new FieldComboElement(stringObj, stringObj);
                        super.setData(comboElementObj);
                    } else {
                        super.setData(obj);
                    }
                }
            };
            EnabledJComboBoxRenderer enableRenderer = new EnabledJComboBoxRenderer();
            ((JComboBox)comboBox.getComponent()).setRenderer(enableRenderer);
            BaseField comboField = new BaseField((BaseComponent)comboBox, title);
            if (padding != null) {
                comboField.setPadding(padding);
            }
            LinkedHashMap<String, String> itemVersionMap = fieldElement.getDirectChildsElementKeyVAlueAttrByName(MetaDataHendler.XML_TAG_ITEM, MetaDataHendler.XML_ATTR_VALUE, MetaDataHendler.XML_ATTR_TARGET_VERSION);
            LinkedHashMap<String, String> itemTitleMap = fieldElement.getDirectChildsElementKeyVAlueAttrByName(MetaDataHendler.XML_TAG_ITEM, MetaDataHendler.XML_ATTR_VALUE, MetaDataHendler.XML_ATTR_TITLE);
            VersionRange range = new VersionRange(version);
            GuiRuleGroupComponent comboComponent = new GuiRuleGroupComponent(comboField, range);
            comboComponent.setErrorComponent(comboBox);
            comboComponent.setValidator(new PermitedValuesValidator(itemVersionMap, this.ctmVersion));
            Iterator<String> iterator = itemVersionMap.keySet().iterator();
            while (iterator.hasNext()) {
                String item;
                final String tmp = item = iterator.next();
                VersionRange itamRange = new VersionRange(itemVersionMap.get(item));
                final GuiRuleComponent listItem = new GuiRuleComponent(new StringData(item, ""), itamRange);
                comboComponent.addComponent(listItem);
                Activable active = new Activable(){
                    private final String value;
                    {
                        this.value = tmp;
                    }

                    @Override
                    public boolean isActive() {
                        return listItem.isActive();
                    }

                    @Override
                    public void setActive(Boolean b) {
                        listItem.setActive(b);
                    }

                    public boolean equals(Object obj) {
                        return this.value.equals(obj);
                    }

                    public String toString() {
                        return tmp;
                    }
                };
                FieldComboElement newElement = comboModel.addElement(item, itemTitleMap.get(item), active);
                enableRenderer.addActiveToElement(newElement, active);
            }
            section.addField(comboField);
            this.handleElementDependencys(comboComponent, fieldElement, section);
            return comboComponent;
        }

        private void handleElementDependencys(GuiRuleGroupComponent component, XmlElement fieldElement, BaseSection section) {
            if (!fieldElement.hasChild(MetaDataHendler.XML_TAG_RULE_FIELD)) {
                return;
            }
            List<XmlElement> dependsfield = fieldElement.getDirectchildsElementbyName(MetaDataHendler.XML_TAG_RULE_FIELD);
            for (XmlElement dependElement : dependsfield) {
                XmlElement dependancyElement = dependElement.getFirstChildElementByName(MetaDataHendler.XML_TAG_DEPENDENCY_CONDOTION);
                if (dependancyElement == null || !dependancyElement.hasAttribute(MetaDataHendler.XML_ATTR_VALUE)) continue;
                String condition = dependancyElement.getAttribute(MetaDataHendler.XML_ATTR_VALUE);
                GuiRuleComponent dependComponent = this.addFieldElementToSection(section, dependElement, 17);
                if (dependComponent == null) continue;
                component.addComponentDependency(condition, dependComponent);
                this.componentList.add(dependComponent);
            }
        }

        private BaseSection getFieldEditorToSection(XmlElement fieldEditorElement) {
            FieldEditorPanel FieldEditorPanel2 = new FieldEditorPanel();
            List<XmlElement> fieldsElementList = fieldEditorElement.getDirectchildsElementbyName(MetaDataHendler.XML_TAG_RULE_ITEM);
            String EditorName = fieldEditorElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
            String EditorGroupName = fieldEditorElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
            String EditorTargetVersion = fieldEditorElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
            VersionRange EditorTargetVersionRange = new VersionRange(EditorTargetVersion);
            GuiRuleContainerComponent fieldsRules = new GuiRuleContainerComponent(EditorGroupName, EditorName, EditorTargetVersionRange);
            HashMap<String, Boolean> mandatoryValues = new HashMap<String, Boolean>();
            for (XmlElement fieldElement : fieldsElementList) {
                String ctmFieldName = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
                String ctmFieldTitle = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
                String CTMfieldVersion = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
                VersionRange CTMfieldVersionRange = new VersionRange(CTMfieldVersion);
                GuiRuleContainerComponent fieldRule = new GuiRuleContainerComponent(EditorGroupName, ctmFieldName, CTMfieldVersionRange);
                List<XmlElement> fieldsElementRulesList = fieldElement.getDirectchildsElementbyName(MetaDataHendler.XML_TAG_RULE_ITEM);
                StringData fieldFormatString = null;
                StringData fieldDefaultString = null;
                PairsListData StringReplaceMap = null;
                for (XmlElement xmlElement : fieldsElementRulesList) {
                    String ruleGroup = xmlElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
                    String ruleName = xmlElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
                    String version = xmlElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
                    VersionRange range = new VersionRange(version);
                    if (ruleName.equalsIgnoreCase(MetaDataHendler.FORMAT_VALUE)) {
                        fieldFormatString = new StringData(ruleName, ruleGroup);
                        GuiRuleComponent fieldFormatComponent = new GuiRuleComponent(fieldFormatString, range);
                        fieldRule.add(fieldFormatComponent);
                        continue;
                    }
                    if (ruleName.equalsIgnoreCase("DEFAULT_VALUE")) {
                        fieldDefaultString = new StringData(ruleName, ruleGroup);
                        GuiRuleComponent fieldDefaultComponent = new GuiRuleComponent(fieldDefaultString, range);
                        boolean isMandatory = this.setLenghValidator(fieldDefaultComponent, xmlElement);
                        fieldRule.add(fieldDefaultComponent);
                        mandatoryValues.put(ctmFieldName, isMandatory);
                        continue;
                    }
                    if (!ruleName.equalsIgnoreCase("STRING_REPLACEMENTS")) continue;
                    StringReplaceMap = new PairsListData(ruleName, ruleGroup);
                    GuiRuleComponent StringReplaceComponent2 = new GuiRuleComponent(StringReplaceMap, range);
                    fieldRule.add(StringReplaceComponent2);
                }
                fieldsRules.add(fieldRule);
                FieldEditorPanel2.addCTMField(ctmFieldName, ctmFieldTitle, fieldFormatString, fieldDefaultString, StringReplaceMap);
                XmlElement allowedValuesElement = fieldElement.getFirstChildElementByName(MetaDataHendler.XML_TAG_ALLOWED_VALUES);
                ArrayList<String> allowedValues = null;
                if (allowedValuesElement != null) {
                    allowedValues = allowedValuesElement.getDirectChildsElementAttrByName(MetaDataHendler.XML_TAG_ITEM, MetaDataHendler.XML_ATTR_VALUE);
                }
                FieldEditorPanel2.putCompetitorFields(ctmFieldName, allowedValues);
            }
            this.componentList.add(fieldsRules);
            LinkedHashMap<String, String> resetValues = fieldEditorElement.getDirectChildsElementKeyVAlueAttrByName(MetaDataHendler.XML_TAG_RULE_ITEM, MetaDataHendler.XML_ATTR_NAME, MetaDataHendler.XML_ATTR_RESET_VALUE);
            FieldEditorPanel2.setResetfieldsValue(resetValues);
            FieldEditorPanel2.setMandatoryFields(mandatoryValues);
            return FieldEditorPanel2;
        }

        private boolean setLenghValidator(GuiRuleComponent comp, XmlElement xmlElement) {
            String maxCharacter = xmlElement.getAttribute(MetaDataHendler.XML_ATTR_MAX_CHARACTER);
            String minCharacter = xmlElement.getAttribute(MetaDataHendler.XML_ATTR_MIN_CHARACTER);
            String MandatoryAttr = xmlElement.getAttribute(MetaDataHendler.XML_ATTR_MANDATORY);
            boolean isMandatory = MandatoryAttr != null && (MandatoryAttr.equalsIgnoreCase("Y") || MandatoryAttr.equalsIgnoreCase("YES"));
            int maxLenth = -1;
            int minLenth = -1;
            if (isMandatory) {
                minLenth = 1;
            }
            if (GlobalFunctions.isNumber(maxCharacter)) {
                maxLenth = Integer.parseInt(maxCharacter);
            }
            if (GlobalFunctions.isNumber(minCharacter)) {
                minLenth = Integer.parseInt(minCharacter);
            }
            comp.setValidator(new LenghValidator(maxLenth, minLenth));
            return isMandatory;
        }

        private GuiRuleComponent createRadioButttonsPanel(BaseSection section, XmlElement fieldElement) {
            String title = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
            String name = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
            String version = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
            String groupName = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_GROUP);
            List<XmlElement> radioList = fieldElement.getDirectchildsElementbyName(MetaDataHendler.XML_TAG_ITEM);
            String orientation = fieldElement.getAttribute(MetaDataHendler.XML_ATTR_ORIENTATION);
            BaseButtonGroup radioButtonGroup = new BaseButtonGroup(name, groupName, title);
            VersionRange range = new VersionRange(version);
            GuiRuleGroupComponent buttonGroupComponent = new GuiRuleGroupComponent(radioButtonGroup, range);
            if (!title.isEmpty()) {
                BaseField titleBaseField = new BaseField(radioButtonGroup);
                section.addField(titleBaseField);
                buttonGroupComponent.addAssistingConponent(titleBaseField);
            }
            JPanel jPanel = new JPanel();
            jPanel.setLayout(new BoxLayout(jPanel, 0));
            jPanel.setBackground(FlowGlobals.ConversionWhite);
            buttonGroupComponent.setErrorComponent(radioButtonGroup);
            HashMap<String, String> AllowedRuleValues = new HashMap<String, String>();
            for (XmlElement radioElement : radioList) {
                String radioTitle = radioElement.getAttribute(MetaDataHendler.XML_ATTR_TITLE);
                String radioName = radioElement.getAttribute(MetaDataHendler.XML_ATTR_NAME);
                String radioVersion = radioElement.getAttribute(MetaDataHendler.XML_ATTR_TARGET_VERSION);
                BaseRadioButton radioButtone = new BaseRadioButton(radioTitle);
                AllowedRuleValues.put(radioName, radioVersion);
                radioButtonGroup.add(radioButtone, radioName);
                VersionRange radioVersionRange = new VersionRange(radioVersion);
                buttonGroupComponent.addComponent(new GuiRuleComponent(radioButtone, radioVersionRange));
                if (orientation.equalsIgnoreCase(MetaDataHendler.VERTICAL)) {
                    section.addField(new BaseField(radioButtone));
                } else {
                    jPanel.add(radioButtone.getComponent());
                    jPanel.add(Box.createRigidArea(new Dimension(5, 0)));
                }
                this.handleElementDependencys(buttonGroupComponent, radioName, radioElement, section);
            }
            buttonGroupComponent.setValidator(new PermitedValuesValidator(AllowedRuleValues, this.ctmVersion));
            section.addField(new BaseField((BaseComponent)new BaseComponentWrapper(jPanel), 17));
            return buttonGroupComponent;
        }

        private void handleElementDependencys(GuiRuleComponent component, Object condition, XmlElement fieldElement, BaseSection section) {
            if (fieldElement.hasChild(MetaDataHendler.XML_TAG_RULE_FIELD)) {
                List<XmlElement> dependsfield = fieldElement.getDirectchildsElementbyName(MetaDataHendler.XML_TAG_RULE_FIELD);
                for (XmlElement dependElement : dependsfield) {
                    GuiRuleComponent dependComponent = this.addFieldElementToSection(section, dependElement, 17);
                    if (dependComponent == null) continue;
                    component.addComponentDependency(condition, dependComponent);
                    this.componentList.add(dependComponent);
                }
            }
        }

        public String getTabName() {
            return this.tabName;
        }

        public String getTabHelpName() {
            return this.tabHelpName;
        }

        protected void setPanelName(String tabName) {
            this.tabName = tabName;
        }
    }
}

