/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.base.Actionable;
import com.bmc.ctmconvert.base.Activable;
import com.bmc.ctmconvert.base.DataRetrievable;
import com.bmc.ctmconvert.base.Errorable;
import com.bmc.ctmconvert.rules.VersionRange;
import com.bmc.ctmconvert.rules.validators.RuleValidator;
import java.util.ArrayList;
import java.util.List;

public class GuiRuleComponent
implements DataRetrievable {
    protected VersionRange versionRange;
    private DataRetrievable component;
    private Errorable errorComponent;
    protected RuleValidator validator;
    private ArrayList<Actionable> actions;
    private Actionable ruleUpdater;
    private ArrayList<Activable> guiAssistantComponents;
    private String currentVersion;
    private List<GuiRuleComponent> componentDependency;

    public GuiRuleComponent(DataRetrievable component, VersionRange versionRange) {
        this.versionRange = versionRange;
        this.component = component;
        this.actions = new ArrayList();
        this.guiAssistantComponents = new ArrayList();
        this.componentDependency = new ArrayList<GuiRuleComponent>();
        this.actions.add(new Actionable(){

            @Override
            public void act() {
                GuiRuleComponent.this.checkData();
            }
        });
        if (this.component == null) {
            return;
        }
        this.component.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                GuiRuleComponent.this.handleDataChanged();
            }
        });
    }

    public List<GuiRuleComponent> getComponentDependency() {
        return this.componentDependency;
    }

    private void handleDataChanged() {
        for (Actionable action : this.actions) {
            action.act();
        }
        if (this.ruleUpdater != null) {
            this.ruleUpdater.act();
        }
        for (GuiRuleComponent dependency : this.getComponentDependency()) {
            dependency.handleDataChanged();
        }
    }

    public DataRetrievable getComponent() {
        return this.component;
    }

    public void handleVersion(String newCtmVersion) {
        this.currentVersion = newCtmVersion;
        boolean iscurrentVersionInRange = this.versionRange.isInRange(newCtmVersion);
        this.setActive(iscurrentVersionInRange);
        this.setError(false, "");
        if (this.validator != null && iscurrentVersionInRange) {
            this.validator.setVersion(newCtmVersion);
            this.checkData();
        }
        this.handleDataChanged();
    }

    public void checkData() {
        if (this.validator == null) {
            return;
        }
        if (!this.isValidData()) {
            String error = this.getErrorMessage();
            this.setError(true, error == null || error.isEmpty() ? "Rule Error" : error);
        } else {
            this.setError(false, "");
        }
    }

    public boolean isValidData() {
        Object input = this.getData();
        boolean valid = false;
        valid = this.validator == null || !this.isActive() ? true : this.validator.isValid(input);
        return valid;
    }

    public String getErrorMessage() {
        Object input = this.getData();
        String errorStr = null;
        if (this.validator != null) {
            errorStr = this.validator.getErrorMessage(input);
        }
        return errorStr;
    }

    public void setValidator(RuleValidator validator) {
        this.validator = validator;
    }

    public void setErrorComponent(Errorable component) {
        this.errorComponent = component;
    }

    @Override
    public Object getData() {
        if (this.component == null) {
            return null;
        }
        return this.component.getData();
    }

    @Override
    public void setData(Object obj) {
        this.component.setData(obj);
        this.handleDataChanged();
    }

    @Override
    public String getName() {
        return this.component.getName();
    }

    @Override
    public DataRetrievable.DataType getDataType() {
        return this.component.getDataType();
    }

    @Override
    public String getGroupName() {
        return this.component.getGroupName();
    }

    @Override
    public void setActive(Boolean b) {
        if (this.component != null) {
            this.component.setActive(b);
        }
        this.checkData();
        for (Activable assistantComponent : this.guiAssistantComponents) {
            assistantComponent.setActive(b);
        }
    }

    @Override
    public void addValueChangedAction(Actionable newAction) {
        this.actions.add(newAction);
    }

    protected void setError(Boolean b, String Message) {
        if (this.errorComponent != null) {
            this.errorComponent.setError(b, Message);
        }
    }

    @Override
    public boolean isActive() {
        return this.component.isActive();
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("group : " + this.getGroupName()).append("\t");
        builder.append("name : " + this.getName()).append("\t");
        builder.append(" data type : " + String.valueOf((Object)this.getDataType())).append("\t");
        builder.append(" data : " + String.valueOf(this.getData())).append("\n");
        return builder.toString();
    }

    public void addComponentDependency(final Object condition, final GuiRuleComponent tableComponent) {
        if (!this.componentDependency.contains(tableComponent)) {
            this.componentDependency.add(tableComponent);
        }
        this.addValueChangedAction(new Actionable(){

            @Override
            public void act() {
                Object input = GuiRuleComponent.this.getData();
                if (input != null && input.equals(condition)) {
                    tableComponent.setActive(true);
                } else {
                    tableComponent.setActive(false);
                }
            }
        });
    }

    public void setRuleUpdater(Actionable updater) {
        this.ruleUpdater = updater;
    }

    public void addAssistingConponent(Activable assistant) {
        this.guiAssistantComponents.add(assistant);
    }

    public void handleVersionCompatibility() {
        this.handleVersion(this.currentVersion);
    }
}

