/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.rules;

import com.bmc.ctmconvert.common.log.ConversionLogger;
import com.bmc.ctmconvert.rules.RuleManager;
import com.bmc.ctmconvert.rules.RulesDataSet;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.logging.Level;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class FieldEditor {
    public static final String STRING_REPLACEMENTS_RULE_NAME = "STRING_REPLACEMENTS";
    public static final String FORMAT_VALUE_RULE_NAME = "FORMAT_VALUE";
    private static final String DEFAULT_VALUE_RULE_NAME = "DEFAULT_VALUE";
    public static final String FIELD_EDITOR_RULE_NAME = "Field Editor";
    private RulesDataSet rules = null;
    private static HashMap<String, Integer> CTMField_FieldCounter_map = new HashMap();
    private static final String REGEX_FIND_CURLY_BARRACKS = "(?<!\\\\)\\{(.+?)(?<!\\\\)}(.*?)(?=(\\{|$))";
    static final Pattern metaCharsPattern = Pattern.compile("[\\.\\\\+\\[^\\]$\\(\\)\\{\\}=!<>|:]");
    public static final String FIELD_EDITOR_GROUP = "";
    private static final String APPEND_MESSAGE_ID = "AppendMessageID";
    private static final String APPEND_MESSAGE_TEXT = "AppendMessageText";

    public FieldEditor(RulesDataSet rules) {
        this.rules = rules;
    }

    public String generateCTMField(String CTMfield, SourceFieldGetter sourceFieldGetter) {
        if (!this.rules.hasRule(FIELD_EDITOR_GROUP, FIELD_EDITOR_RULE_NAME, CTMfield, FORMAT_VALUE_RULE_NAME)) {
            ConversionLogger.getLogger().log(Level.INFO, "Rule Editor - can't find the field: " + CTMfield + ". in resource file.");
            return FIELD_EDITOR_GROUP;
        }
        String convertedString = this.replaceFormats(CTMfield, sourceFieldGetter);
        if ((convertedString = this.replaceStrings(convertedString, CTMfield)).isEmpty()) {
            convertedString = this.getDefaultValue(CTMfield);
        }
        return convertedString;
    }

    public String generateCTMField(String CTMfield, final Map<String, String> fieldHash) {
        return this.generateCTMField(CTMfield, new SourceFieldGetter(){

            @Override
            public String getField(String fieldName) {
                return (String)fieldHash.get(fieldName);
            }
        });
    }

    public String getDefaultValue(String CTMfield) {
        return this.rules.getStringRule(FIELD_EDITOR_GROUP, FIELD_EDITOR_RULE_NAME, CTMfield, DEFAULT_VALUE_RULE_NAME);
    }

    public String replaceStrings(String convertedString, String CTMField) {
        if (convertedString.isEmpty()) {
            return convertedString;
        }
        ArrayList<Map.Entry<String, String>> from_to_List = this.rules.getPairsListRule(FIELD_EDITOR_GROUP, FIELD_EDITOR_RULE_NAME, CTMField, STRING_REPLACEMENTS_RULE_NAME);
        for (Map.Entry<String, String> entry : from_to_List) {
            String fromVal = entry.getKey();
            String toVal = entry.getValue();
            if (fromVal == null || toVal == null) continue;
            String regExp = metaCharsPattern.matcher(fromVal).replaceAll("\\\\$0");
            regExp = regExp.replace("?", ".");
            Pattern pattern = Pattern.compile(regExp = regExp.replace("*", ".*?"));
            Matcher matcher = pattern.matcher(convertedString);
            convertedString = matcher.find() ? matcher.replaceAll(toVal) : convertedString;
        }
        return convertedString;
    }

    public String replaceFormats(String CTMfield, SourceFieldGetter sourceFieldGetter) {
        String formattedValue;
        String convertedString = formattedValue = this.rules.getStringRule(FIELD_EDITOR_GROUP, FIELD_EDITOR_RULE_NAME, CTMfield, FORMAT_VALUE_RULE_NAME);
        convertedString = this.convertCompetitorField(CTMfield, convertedString, sourceFieldGetter);
        return convertedString;
    }

    public int getFieldCount(String field) {
        if (!CTMField_FieldCounter_map.containsKey(field)) {
            CTMField_FieldCounter_map.put(field, 0);
        }
        int value = CTMField_FieldCounter_map.get(field);
        CTMField_FieldCounter_map.put(field, value + 1);
        return value;
    }

    private String convertCompetitorField(String CTMfield, String formattedValue, SourceFieldGetter sourceFieldGetter) {
        Pattern p = Pattern.compile(REGEX_FIND_CURLY_BARRACKS);
        Matcher matcher = p.matcher(formattedValue);
        StringBuilder builder = new StringBuilder(formattedValue.split("\\{")[0]);
        while (matcher.find()) {
            String competitorField = matcher.group(1);
            String restAfterFormat = matcher.group(2);
            String compitetorFieldValue = null;
            compitetorFieldValue = sourceFieldGetter.getField(competitorField);
            if (compitetorFieldValue == null) {
                compitetorFieldValue = FIELD_EDITOR_GROUP;
            }
            builder.append(compitetorFieldValue).append(restAfterFormat);
        }
        return builder.toString();
    }

    public static boolean isMessagesIdToDescription() {
        return RuleManager.instance().getCurrentRules().getBooleanRule(FIELD_EDITOR_GROUP, APPEND_MESSAGE_ID);
    }

    public static boolean isMessagesTextToDescription() {
        return RuleManager.instance().getCurrentRules().getBooleanRule(FIELD_EDITOR_GROUP, APPEND_MESSAGE_TEXT);
    }

    public static interface SourceFieldGetter {
        public String getField(String var1);
    }
}

