/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.readers;

import com.bmc.ctmconvert.jp1.readers.UnitHeader;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class UnitHeaderExtractor {
    private static final String UNITNAME = "unitname";
    private static final String PERMISSION = "permission";
    private static final String USER_NAME = "userName";
    private static final String RESOURCE_GROUP = "resourceGroup";
    private String unitHeaderLine;
    private Pattern unitHeaderPattern;

    public UnitHeaderExtractor(String unitHeaderLine) {
        this.unitHeaderLine = unitHeaderLine;
        this.initPatterns();
    }

    private void initPatterns() {
        String endOfPattern = "((?=,)|;$)";
        String unitNamePattern = this.namedGroup(UNITNAME, ".*?") + endOfPattern;
        String permissionPattern = this.optionalGroup(this.namedGroup(PERMISSION, ".*?") + endOfPattern);
        String userNamePattern = this.optionalGroup(this.namedGroup(USER_NAME, ".*?") + endOfPattern);
        String resourceGroupPattern = this.optionalGroup(this.namedGroup(RESOURCE_GROUP, ".*?") + endOfPattern);
        this.unitHeaderPattern = Pattern.compile("unit=" + unitNamePattern + this.optionalGroup("," + permissionPattern + this.optionalGroup("," + userNamePattern + this.optionalGroup("," + resourceGroupPattern))));
    }

    private String namedGroup(String groupName, String pattern) {
        return "(?<" + groupName + ">" + pattern + ")";
    }

    private String optionalGroup(String pattern) {
        return "(" + pattern + ")?";
    }

    public UnitHeader extract() {
        Matcher matcher = this.unitHeaderPattern.matcher(this.unitHeaderLine);
        if (matcher.find()) {
            return new UnitHeader(this.getGroup(matcher, UNITNAME), this.getGroup(matcher, PERMISSION), this.getGroup(matcher, USER_NAME), this.getGroup(matcher, RESOURCE_GROUP));
        }
        return new UnitHeader();
    }

    private String getGroup(Matcher matcher, String groupName) {
        String DEFAULT = "";
        return Optional.ofNullable(matcher.group(groupName)).orElse("");
    }
}

