/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.readers;

import com.bmc.ctmconvert.jp1.readers.UnitHeader;
import com.bmc.ctmconvert.utils.Pair;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;

public class JP1Unit {
    private final List<Pair<String, String>> attributes = new ArrayList<Pair<String, String>>();

    public JP1Unit(UnitHeader header) {
        this.attributes.add((Pair<String, String>)new Pair((Object)"UNIT_NAME", (Object)header.unitName));
        this.attributes.add((Pair<String, String>)new Pair((Object)"permission", (Object)header.permission));
        this.attributes.add((Pair<String, String>)new Pair((Object)"userName", (Object)header.userName));
        this.attributes.add((Pair<String, String>)new Pair((Object)"resourceGroup", (Object)header.resourceGroup));
    }

    public String getName() {
        return this.getFirstAttribute("UNIT_NAME").orElse("");
    }

    public String toString() {
        StringBuilder b = new StringBuilder("JP1Unit [name=" + this.getFirstAttribute("UNIT_NAME").orElse("") + "]\n");
        for (Pair<String, String> pair : this.attributes) {
            b.append(pair).append("\n");
        }
        return b.toString();
    }

    public void addAllAttributes(List<Pair<String, String>> attribs) {
        this.attributes.addAll(attribs);
    }

    public ArrayList<Pair<String, String>> getAllAttributes() {
        return new ArrayList<Pair<String, String>>(this.attributes);
    }

    public boolean hasAttribute(String attributeName, String attributeValue) {
        return this.attributes.stream().anyMatch(pair -> ((String)pair.getKey()).equals(attributeName) && ((String)pair.getValue()).equals(attributeValue));
    }

    public Optional<String> getFirstAttribute(String attributeName) {
        return this.attributes.stream().filter(attribute -> ((String)attribute.getKey()).equals(attributeName)).findFirst().map(Pair::getValue);
    }
}

