/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.operations;

import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.operations.NoOp;
import com.bmc.ctmconvert.jp1.operations.ValueOperation;
import com.bmc.ctmconvert.jp1.operations.ValueOperationDecorator;
import com.bmc.ctmconvert.vc.FieldValidation;
import com.bmc.ctmconvert.vc.IFieldValidation;

public class ValidationDecorator
extends ValueOperationDecorator {
    private boolean isMPM;
    private String attributeName;
    private MessageHandler messageHandler;
    private String competitorAttributeName;
    private ValidationType type;

    public ValidationDecorator(WorkspaceEntity entity, String attributeName, String competitorAttributeName) {
        this(entity, attributeName, competitorAttributeName, ValidationType.VALIDATE_AND_FIX_VALUE, (ValueOperation)new NoOp());
    }

    public ValidationDecorator(WorkspaceEntity entity, String attributeName, String competitorAttributeName, ValidationType type) {
        this(entity, attributeName, competitorAttributeName, type, (ValueOperation)new NoOp());
    }

    public ValidationDecorator(WorkspaceEntity entity, String attributeName, String competitorAttributeName, ValueOperation operation) {
        this(attributeName, competitorAttributeName, ValidationType.VALIDATE_AND_FIX_VALUE, entity.getMessageHandler(), operation);
    }

    public ValidationDecorator(WorkspaceEntity entity, String attributeName, String competitorAttributeName, ValidationType type, ValueOperation operation) {
        this(attributeName, competitorAttributeName, type, entity.getMessageHandler(), operation);
    }

    public ValidationDecorator(String attributeName, String competitorAttributeName, ValidationType type, MessageHandler messageHandler, ValueOperation operation) {
        this(attributeName, competitorAttributeName, true, type, messageHandler, operation);
    }

    public ValidationDecorator(String attributeName, String competitorAttributeName, boolean isMPM, ValidationType type, MessageHandler messageHandler, ValueOperation operation) {
        super(operation);
        this.init(attributeName, competitorAttributeName, isMPM, type, messageHandler);
    }

    protected void init(String attributeName, String competitorAttributeName, boolean isMPM, ValidationType type, MessageHandler messageHandler) {
        this.attributeName = attributeName;
        this.competitorAttributeName = competitorAttributeName;
        this.isMPM = isMPM;
        this.type = type;
        this.messageHandler = messageHandler;
    }

    @Override
    protected String applyImplementation(String inputValue) {
        String validatedValue;
        IFieldValidation fieldValidation = FieldValidation.instance();
        switch (this.type.ordinal()) {
            case 1: {
                validatedValue = fieldValidation.validateAndReturnFixedValue(this.messageHandler, this.attributeName, inputValue, this.isMPM, this.competitorAttributeName);
                break;
            }
            case 0: {
                validatedValue = inputValue;
                fieldValidation.validate(this.attributeName, inputValue, this.isMPM, this.messageHandler);
                break;
            }
            default: {
                validatedValue = inputValue;
            }
        }
        return validatedValue;
    }

    public static enum ValidationType {
        VALIDATE_ONLY,
        VALIDATE_AND_FIX_VALUE;

    }
}

