/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.globs;

import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.jp1.convertors.PathQuery;
import java.util.List;
import java.util.Optional;
import java.util.function.Function;
import java.util.stream.Collectors;

public class Jp1HierarchyUtils {
    public static String getGroupPath(int id, DataObject dataObject, boolean isApplicationSetter) {
        int directGroupParentId = Jp1HierarchyUtils.getDirectGroupParent(id, dataObject).orElse(id);
        return Jp1HierarchyUtils.getPath(directGroupParentId, dataObject, isApplicationSetter);
    }

    public static String getPath(int id, DataObject dataObject, boolean isApplicationSetter) {
        PathQuery query = new PathQuery();
        List<Integer> pathList = query.getPath(arg_0 -> ((DataObject)dataObject).getParent(arg_0), id);
        List parentsName = pathList.stream().map(Jp1HierarchyUtils.unitIdToName(dataObject)).collect(Collectors.toList());
        String path = String.join((CharSequence)"/", parentsName);
        path = path.replaceFirst("^/", "");
        return path;
    }

    private static Function<Integer, String> unitIdToName(DataObject dataobject) {
        return parentId -> {
            if (parentId.equals(0)) {
                return "";
            }
            return (String)dataobject.getAttribute("UNIT_NAME", parentId).get(0);
        };
    }

    public static Optional<Integer> getDirectGroupParent(int id, DataObject dataObject) {
        Optional groupAncestor = dataObject.getFirstAncestor(id, "ty", "g");
        return groupAncestor;
    }

    public static String getUnitNameByType(int id, DataObject dataObject, String unitType) {
        List nameValues;
        String subApplicaiton = "";
        Optional groupAncestor = dataObject.getFirstAncestor(id, "ty", unitType);
        if (groupAncestor.isPresent() && !(nameValues = dataObject.getAttribute("UNIT_NAME", (Integer)groupAncestor.get())).isEmpty()) {
            subApplicaiton = (String)nameValues.get(0);
        }
        return subApplicaiton;
    }
}

