/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.dependencies;

import com.bmc.ctmconvert.jp1.dependencies.DependencyRules;
import com.bmc.ctmconvert.jp1.dependencies.JobsCondition;
import com.bmc.ctmconvert.rules.RulesDataSet;

public class Jp1DependencyRules
implements DependencyRules {
    private RulesDataSet conversionRules;

    public Jp1DependencyRules(RulesDataSet conversionRules) {
        this.conversionRules = conversionRules;
    }

    @Override
    public boolean isJobAToJobBCondition() {
        String jp1ConditionName = this.conversionRules.getStringRule("JP1_rules", new String[]{"CONDITION_NAME"});
        return "CID<Unique Number>@JOBA-TO-JOBB".equals(jp1ConditionName);
    }

    @Override
    public boolean needToCleanUp() {
        boolean delCond = false;
        if (this.isJobAToJobBCondition()) {
            delCond = this.conversionRules.getBooleanRule("JP1_rules", new String[]{"CLEAN_UP_CONDITIONS"});
        }
        return delCond;
    }

    private String buildConditionName(JobsCondition action) {
        String conditionName = this.isJobAToJobBCondition() ? this.buildConditionJobAToJobB(action) : this.buildConditionStatus(action);
        return conditionName;
    }

    private String buildConditionJobAToJobB(JobsCondition action) {
        return "CID" + action.getJobA_Id() + "@" + action.getJobA() + "-TO-" + action.getJobB();
    }

    private String buildConditionStatus(JobsCondition action) {
        return "CID" + action.getJobA_Id() + "@" + action.getJobA() + "-ENDED-" + this.getStatusValue(action.getIsOkStatus());
    }

    private String getStatusValue(boolean endStatus) {
        return endStatus ? "OK" : "NOTOK";
    }

    @Override
    public String getConditionNameAndStatus(JobsCondition action) {
        return this.buildConditionName(action);
    }
}

