/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.Jobnet;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.JobnetRule;
import com.bmc.ctmconvert.jp1.convertors.scheduling.Jp1Scheduler;
import java.util.List;
import java.util.Optional;

public class RootJobnetRulesGetter
implements Jp1Scheduler.RulesGetter {
    private final Jp1Scheduler jp1Scheduler;
    private DataObject dataObject;

    public RootJobnetRulesGetter(Jp1Scheduler jp1Scheduler, DataObject dataObject) {
        this.jp1Scheduler = jp1Scheduler;
        this.dataObject = dataObject;
    }

    @Override
    public List<JobnetRule> getRules(Integer jobnetId) {
        Jobnet rootJobNet = this.getRootJobnet(jobnetId);
        return rootJobNet.getRules();
    }

    public Jobnet getRootJobnet(Integer jobnetId) {
        Optional parent = this.dataObject.getParent(jobnetId.intValue());
        if (!parent.isPresent()) {
            return this.jp1Scheduler.getJobnet(jobnetId);
        }
        if (this.isGroupType((Integer)parent.get())) {
            return this.jp1Scheduler.getJobnet(jobnetId);
        }
        if (this.isJobnetType((Integer)parent.get())) {
            return this.getRootJobnet((Integer)parent.get());
        }
        Optional name = this.dataObject.findFirstAttribute("UNIT_NAME", jobnetId);
        throw new UnRootedJobnetException(name.orElse("not found"));
    }

    private boolean isJobnetType(Integer id) {
        String unitType = this.getUnitType(id);
        return unitType != null && unitType.equals("n");
    }

    private boolean isGroupType(Integer id) {
        String unitType = this.getUnitType(id);
        return unitType != null && unitType.equals("g");
    }

    private String getUnitType(Integer id) {
        List values = this.dataObject.getAttribute("ty", id);
        if (!values.isEmpty()) {
            return (String)values.get(0);
        }
        return null;
    }

    private static class UnRootedJobnetException
    extends RuntimeException {
        public UnRootedJobnetException(String jobnet) {
            super("In the input data jobnet: \"" + jobnet + "\" is not contained inside a Group.To convert the data, every jobnet should be included in a Group context.Ensure that the group context exists in the input data.");
        }
    }
}

