/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.Rbc.Rbc;
import com.bmc.ctmconvert.common.rbc.DailyRbc;
import com.bmc.ctmconvert.common.rbc.monthly.MonthlyRbc;
import com.bmc.ctmconvert.jp1.convertors.JP1Calendar;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.JobnetRule;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.RuleCreator;
import com.bmc.ctmconvert.jp1.convertors.scheduling.CalendarSetter;
import com.bmc.ctmconvert.jp1.convertors.scheduling.JP1RbcNamer;
import com.bmc.ctmconvert.jp1.convertors.scheduling.MonthlyRbcCreator;
import com.bmc.ctmconvert.jp1.convertors.scheduling.rbc_creators.WeeklyRbcCreator;
import java.time.LocalDate;
import java.util.Optional;
import java.util.function.Consumer;

public class RbcFactory {
    private Optional<JP1Calendar> calendar;

    public RbcFactory(Optional<JP1Calendar> calendar) {
        this.calendar = calendar;
    }

    public Optional<Rbc> getRbc(JobnetRule jobnetRule) {
        Optional<Object> retRbc = switch (jobnetRule.getType()) {
            case RuleCreator.CyclicType.DAILY -> this.createDailyRbc(jobnetRule);
            case RuleCreator.CyclicType.WEEKLY -> this.createWeeklyRbc(jobnetRule);
            case RuleCreator.CyclicType.MONTHLY -> this.createMonthlyRbc(jobnetRule);
            case RuleCreator.CyclicType.YEARlY -> this.createYearlyRbc(jobnetRule);
            default -> Optional.empty();
        };
        if (retRbc.isPresent()) {
            this.addRbcStartDate((Rbc)retRbc.get(), jobnetRule);
        }
        Consumer<Rbc> nameConsumer = JP1RbcNamer::nameRbc;
        retRbc.ifPresent(nameConsumer);
        return retRbc;
    }

    private Optional<Rbc> createDailyRbc(JobnetRule rule) {
        DailyRbc dailyRbc = new DailyRbc();
        this.handleCalendar(dailyRbc, rule);
        return Optional.of(dailyRbc);
    }

    private void handleCalendar(DailyRbc dailyRbc, JobnetRule rule) {
        if (this.calendar.isPresent()) {
            CalendarSetter calendarSetter = new CalendarSetter(this.calendar.get());
            calendarSetter.handleRbc(dailyRbc, rule);
        }
    }

    private void addRbcStartDate(Rbc rbc, JobnetRule rule) {
        Optional<LocalDate> startDate = rule.getStartDateAsLocal();
        startDate.ifPresent(arg_0 -> ((Rbc)rbc).setStartDate(arg_0));
    }

    private Optional<Rbc> createWeeklyRbc(JobnetRule rule) {
        WeeklyRbcCreator weeklycreaor = new WeeklyRbcCreator();
        Optional<Rbc> ret = weeklycreaor.createRbc(rule);
        return ret;
    }

    private Optional<Rbc> createMonthlyRbc(JobnetRule rule) {
        if (rule.getInterval() > 1) {
            return Optional.empty();
        }
        MonthlyRbcCreator creator = new MonthlyRbcCreator(this.calendar);
        MonthlyRbc monthly = creator.getMonthlyRBc(rule);
        return Optional.of(monthly);
    }

    private Optional<Rbc> createYearlyRbc(JobnetRule rule) {
        return Optional.empty();
    }

    public static interface CalendarHandler {
        public void handleRbc(DailyRbc var1, JobnetRule var2);
    }
}

