/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.common.calendars.CtmCalendar;
import com.bmc.ctmconvert.common.rbc.monthly.MonthDaysRbc;
import com.bmc.ctmconvert.common.rbc.monthly.MonthlyCalendarBasedRbc;
import com.bmc.ctmconvert.common.rbc.monthly.MonthlyRbc;
import com.bmc.ctmconvert.jp1.convertors.JP1Calendar;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.JobnetRule;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.RuleStartDate;
import java.util.Optional;

public class MonthlyRbcCreator {
    private Optional<JP1Calendar> calendar;

    public MonthlyRbcCreator(Optional<JP1Calendar> calendar) {
        this.calendar = calendar;
    }

    public MonthlyRbc getMonthlyRBc(JobnetRule rule) {
        MonthlyRbc ret = this.getMonthlyRbc(rule);
        RuleStartDate startDate = rule.getStartDate();
        this.addDays(ret, startDate);
        return ret;
    }

    private void addDays(MonthlyRbc monthlyRbc, RuleStartDate startDate) {
        if (startDate.isBeforeEndMonthDays()) {
            Optional<Integer> monthDay = startDate.getBeforedays();
            monthDay = monthDay.map(this::increment);
            Optional day = MonthlyRbc.DayFromEnd.FromInteger((Integer)monthDay.orElse(1));
            day.ifPresent(arg_0 -> ((MonthlyRbc)monthlyRbc).addDayFromEnd(arg_0));
        } else if (startDate.getMonthDay().isPresent()) {
            Optional<Integer> monthDay = startDate.getMonthDay();
            Optional day = MonthlyRbc.DayFromBegin.FromInteger((Integer)monthDay.orElse(null));
            day.ifPresent(arg_0 -> ((MonthlyRbc)monthlyRbc).addDay(arg_0));
        }
    }

    private int increment(Integer value) {
        return value + 1;
    }

    private MonthlyRbc getMonthlyRbc(JobnetRule rule) {
        MonthDaysRbc ret = new MonthDaysRbc();
        if (this.isCalendarNeeded(rule)) {
            CtmCalendar ctmcalendar = null;
            if (rule.isOpen()) {
                ctmcalendar = this.calendar.get().getOpenCalendar();
            } else if (rule.isClosed()) {
                ctmcalendar = this.calendar.get().getClosedCalendar();
            }
            if (ctmcalendar != null) {
                String calendarName = ctmcalendar.getName();
                ret = new MonthlyCalendarBasedRbc(calendarName);
            }
        }
        ret.addAllMonths();
        return ret;
    }

    private boolean isCalendarNeeded(JobnetRule rule) {
        return this.calendar.isPresent() && (rule.isOpen() || rule.isClosed());
    }
}

