/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.common.dataObject.OnMemoryStorer;
import com.bmc.ctmconvert.common.transformer.workspaces.WorkspaceEntity;
import com.bmc.ctmconvert.jp1.convertors.JP1Calendar;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.JobnetRule;
import com.bmc.ctmconvert.jp1.convertors.scheduling.CalendarGetter;
import com.bmc.ctmconvert.jp1.convertors.scheduling.FirstScheduledJobnetRulesGetter;
import com.bmc.ctmconvert.jp1.convertors.scheduling.Jp1Scheduler;
import com.bmc.ctmconvert.jp1.convertors.scheduling.RbcFactory;
import com.bmc.ctmconvert.jp1.convertors.scheduling.RulesConvertor;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;

public class JobScheduler
implements Consumer<Integer> {
    private final OnMemoryStorer dataObject;
    private final Jp1Scheduler.DataObjectEntityToCtmJobResolver dataObjectEntityToCtmJobResolver;
    private final Jp1Scheduler.GroupIdToCalendarResolver calendarResolver;

    public JobScheduler(OnMemoryStorer dataObject, Jp1Scheduler.DataObjectEntityToCtmJobResolver dataObjectEntityToCtmJobResolver, Jp1Scheduler.GroupIdToCalendarResolver calendarResolver) {
        this.dataObject = dataObject;
        this.dataObjectEntityToCtmJobResolver = dataObjectEntityToCtmJobResolver;
        this.calendarResolver = calendarResolver;
    }

    @Override
    public void accept(Integer jobId) {
        FirstScheduledJobnetRulesGetter rulesGetter = new FirstScheduledJobnetRulesGetter((DataObject)this.dataObject);
        List<JobnetRule> rules = rulesGetter.getRules(jobId);
        WorkspaceEntity job = this.dataObjectEntityToCtmJobResolver.getWorkspaceEntityFromDataObjectEntityId(jobId);
        Optional<JP1Calendar> calendar = new CalendarGetter().getCalendar(jobId, (DataObject)this.dataObject, this.calendarResolver);
        new RulesConvertor(new RbcFactory(calendar)).createRbcs(rules).forEach(arg_0 -> ((WorkspaceEntity)job).addScheduling(arg_0));
    }
}

