/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.Jobnet;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.JobnetRule;
import com.bmc.ctmconvert.jp1.convertors.scheduling.Jp1Scheduler;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.function.BiPredicate;
import java.util.function.Predicate;

public class FirstScheduledJobnetRulesGetter
implements Jp1Scheduler.RulesGetter {
    private final DataObject dataObject;

    public FirstScheduledJobnetRulesGetter(DataObject dataObject) {
        this.dataObject = dataObject;
    }

    @Override
    public List<JobnetRule> getRules(Integer entityId) {
        if (this.isJobnetWithRules(entityId)) {
            return this.getRulesOf(Optional.of(entityId));
        }
        return this.getRulesOf(this.getAnccestorJobnetWithRules(entityId));
    }

    private boolean isJobnetWithRules(Integer entityId) {
        Attributes entityAttributes = new Attributes(this.dataObject.getAttributes(entityId));
        return new JobnetWithRulesPredicate().test(entityAttributes);
    }

    private Optional<Integer> getAnccestorJobnetWithRules(Integer entityId) {
        return this.dataObject.getFirstAncestor(entityId.intValue(), (Predicate)new JobnetWithRulesPredicate());
    }

    private List<JobnetRule> getRulesOf(Optional<Integer> jobnetId) {
        List<JobnetRule> ret = new ArrayList<JobnetRule>();
        if (jobnetId.isPresent()) {
            ret = new Jobnet(new Attributes(this.dataObject.getAttributes(jobnetId.get()))).getRules();
        }
        return ret;
    }

    private static class JobnetWithRulesPredicate
    implements Predicate<Attributes> {
        private JobnetWithRulesPredicate() {
        }

        @Override
        public boolean test(Attributes attributes) {
            if (!attributes.hasAttribute("ty", "n")) {
                return false;
            }
            BiPredicate<String, String> sdIsDefined = (key, value) -> key.equals("sd") && !value.contains("ud");
            return attributes.hasAttribute(sdIsDefined);
        }
    }
}

