/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.scheduling;

import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.common.dataObject.DataObject;
import com.bmc.ctmconvert.jp1.convertors.JP1Calendar;
import com.bmc.ctmconvert.jp1.convertors.scheduling.Jp1Scheduler;
import java.util.Optional;
import java.util.function.Predicate;

public class CalendarGetter {
    public Optional<JP1Calendar> getCalendar(Integer jobId, DataObject dataObject, Jp1Scheduler.GroupIdToCalendarResolver calendarResolver) {
        Optional<Integer> groupId = this.getGroupWithCalendar(dataObject, jobId);
        return this.getGroupCalendar(groupId, calendarResolver);
    }

    private Optional<Integer> getGroupWithCalendar(DataObject dataObject, int jobId) {
        Predicate<Attributes> isGroupWithCalendar = attributes -> attributes.hasAttribute("ty", "g") && (attributes.hasAttribute("op") || attributes.hasAttribute("cl"));
        Optional groupId = dataObject.getFirstAncestor(jobId, isGroupWithCalendar);
        return groupId;
    }

    private Optional<JP1Calendar> getGroupCalendar(Optional<Integer> groupId, Jp1Scheduler.GroupIdToCalendarResolver calendarResolver) {
        Optional<JP1Calendar> ret = Optional.empty();
        if (groupId.isPresent()) {
            ret = calendarResolver.getGroupCalendar(groupId.get());
        }
        return ret;
    }
}

