/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.jp1Entities;

import com.bmc.ctmconvert.common.dataObject.Attributes;
import com.bmc.ctmconvert.common.message.MessageHandler;
import com.bmc.ctmconvert.common.message.NullMessageHandler;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.JobnetRule;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.RuleStartDate;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.RulesAttributesList;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.SingleRuleAttributes;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class RuleCreator {
    private static final String PERIOD_STRING = "PERIOD";
    private static final String INTERVAL_STRING = "INTERVAL";
    private static final String CY_PATTERN = "((?<RULENUMBER>\\d+)\\s*?,\\s*?)?\\((?<INTERVAL>\\d+)\\s*?,\\s*?(?<PERIOD>[dwmy])\\)";
    private Integer ruleNumber;
    private CyclicType ruleCyclicType = CyclicType.NONE;
    private int ruleInterval;
    private MessageHandler handler = new NullMessageHandler();
    boolean isValidDaily;

    public RuleCreator(MessageHandler handler) {
        this.handler = handler;
    }

    public RuleCreator() {
    }

    public List<JobnetRule> createRules(Attributes attributes) {
        ArrayList<JobnetRule> ret = new ArrayList<JobnetRule>();
        if (attributes == null) {
            return ret;
        }
        RulesAttributesList rulesAttributes = new RulesAttributesList(attributes);
        for (SingleRuleAttributes ruleAttributes : rulesAttributes.getList()) {
            this.initRulesMembers();
            Optional<JobnetRule> newRule = this.createRule(ruleAttributes);
            newRule.ifPresent(ret::add);
        }
        return ret;
    }

    private void initRulesMembers() {
        this.ruleCyclicType = CyclicType.NONE;
        this.ruleInterval = 0;
        this.ruleNumber = null;
    }

    private Optional<JobnetRule> createRule(SingleRuleAttributes ruleAttributes) {
        this.ruleNumber = ruleAttributes.getRuleNumber();
        Map<String, String> rulesAttributesMap = ruleAttributes.getAttributes();
        if (!rulesAttributesMap.containsKey("sd")) {
            return Optional.empty();
        }
        String sdValueString = rulesAttributesMap.get("sd");
        RuleStartDate startdate = new RuleStartDate(sdValueString);
        if (rulesAttributesMap.containsKey("cy")) {
            this.handleCy(rulesAttributesMap.get("cy"));
        }
        this.isValidDaily = this.ruleCyclicType == CyclicType.DAILY && this.ruleInterval == 1;
        this.handleRegistered(startdate);
        this.handleRelative(sdValueString, startdate);
        this.handleSpecificDate(sdValueString);
        this.handleWeeklyMessages(rulesAttributesMap, sdValueString, startdate);
        this.handleShShd(rulesAttributesMap, startdate);
        boolean isMonthly = this.ruleCyclicType == CyclicType.MONTHLY;
        boolean isWeekday = startdate.getWeekDay().isPresent();
        String cyValue = rulesAttributesMap.get("cy");
        if (isMonthly && isWeekday) {
            this.handler.handleMessage("WRN17018", new String[]{sdValueString, cyValue});
        }
        JobnetRule result = new JobnetRule(this.ruleNumber, this.ruleInterval, this.ruleCyclicType, startdate);
        return Optional.of(result);
    }

    private void handleRelative(String sdValueString, RuleStartDate startdate) {
        if (startdate.isRelative() && !this.isValidDaily) {
            this.handler.handleMessage("WRN17007", new String[]{sdValueString});
        }
    }

    private void handleRegistered(RuleStartDate startdate) {
        if (startdate.isRegistered() && !this.isValidDaily) {
            this.handler.handleMessage("WRN17008", new String[]{this.ruleNumber.toString()});
        }
    }

    private void handleWeeklyMessages(Map<String, String> rulesAttributesMap, String sdValueString, RuleStartDate startdate) {
        if (this.ruleCyclicType == CyclicType.WEEKLY) {
            Optional<LocalDate> localDate = startdate.getLocalDate();
            Optional<String> weekNumber = startdate.getweekNumber();
            if (localDate.isPresent() || weekNumber.isPresent() && !weekNumber.get().equals("1") || startdate.getWeekDay().isEmpty()) {
                String cyValue = rulesAttributesMap.get("cy");
                this.handler.handleMessage("WRN17010", new String[]{sdValueString, cyValue});
            } else if (startdate.getYear().isPresent()) {
                this.handler.handleMessage("WRN17017", new String[]{sdValueString});
            }
        }
    }

    private void handleSpecificDate(String sdValueString) {
        sdValueString = sdValueString.replaceAll("\\s*", "");
        if (!(this.ruleCyclicType != CyclicType.NONE && this.ruleCyclicType != CyclicType.UNKNOWN || sdValueString.matches("(\\d+,en|0,ud)"))) {
            this.handler.handleMessage("WRN17009", new String[]{sdValueString});
        }
    }

    private void handleShShd(Map<String, String> rulesAttributesMap, RuleStartDate startdate) {
        String shValue = "";
        String shdValue = "";
        boolean isShFound = false;
        boolean isShdFound = false;
        if (startdate.isOpen()) {
            return;
        }
        for (String attributeName : rulesAttributesMap.keySet()) {
            if (attributeName.equals("sh")) {
                shValue = rulesAttributesMap.get(attributeName);
                if (shValue.trim().matches("^(\\d{1,3}\\s*,)?\\s*no\\s*;?$")) {
                    return;
                }
                isShFound = true;
            } else if (attributeName.equals("shd")) {
                shdValue = rulesAttributesMap.get(attributeName);
                isShdFound = true;
            }
            if (!isShdFound || !isShFound) continue;
            this.handler.handleMessage("WRN17016", new String[]{shValue, shdValue});
            return;
        }
    }

    private void handleCy(String cyValueString) {
        this.ruleCyclicType = this.getCyclicType(Optional.of(cyValueString));
        Optional<Integer> ruleInterval = this.getRuleInterval(cyValueString);
        ruleInterval.ifPresent(integer -> {
            this.ruleInterval = integer;
        });
        if (this.ruleCyclicType == CyclicType.YEARlY) {
            this.handler.handleMessage("WRN17006", new String[]{cyValueString});
        }
    }

    private CyclicType getCyclicType(Optional<String> type) {
        String period;
        if (type.isEmpty()) {
            return CyclicType.NONE;
        }
        Pattern r = Pattern.compile(CY_PATTERN);
        Matcher m = r.matcher(type.get());
        if (!m.find()) {
            return CyclicType.UNKNOWN;
        }
        return switch (period = m.group(PERIOD_STRING)) {
            case "d" -> CyclicType.DAILY;
            case "w" -> CyclicType.WEEKLY;
            case "m" -> CyclicType.MONTHLY;
            case "y" -> CyclicType.YEARlY;
            default -> CyclicType.UNKNOWN;
        };
    }

    private Optional<Integer> getRuleInterval(String cyclicValue) {
        Pattern r = Pattern.compile(CY_PATTERN);
        Matcher m = r.matcher(cyclicValue);
        if (!m.matches()) {
            return Optional.empty();
        }
        String intervalStr = m.group(INTERVAL_STRING);
        int interval = Integer.parseInt(intervalStr);
        if (interval > 1) {
            this.handler.handleMessage("WRN17002", new String[]{cyclicValue});
        }
        return Optional.of(interval);
    }

    public static enum CyclicType {
        NONE,
        DAILY,
        WEEKLY,
        MONTHLY,
        YEARlY,
        UNKNOWN;

    }
}

