/*
 * Decompiled with CFR 0.152.
 */
package com.bmc.ctmconvert.jp1.convertors.jp1Entities;

import com.bmc.ctmconvert.common.rbc.RBC;
import com.bmc.ctmconvert.jp1.actions.StartTimeStAction;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.RuleCreator;
import com.bmc.ctmconvert.jp1.convertors.jp1Entities.RuleStartDate;
import java.time.LocalDate;
import java.util.Optional;

public class JobnetRule {
    private final Integer ruleNumber;
    private final int interval;
    private final RuleCreator.CyclicType type;
    private StartTimeStAction.TimeFrom startTime = StartTimeStAction.TimeFrom.empty;
    private final RuleStartDate startDate;

    public JobnetRule(Integer ruleNumber, int interval, RuleCreator.CyclicType type, RuleStartDate startdate) {
        this.ruleNumber = ruleNumber;
        this.interval = interval;
        this.type = type;
        this.startDate = startdate;
    }

    public Integer getRuleNumber() {
        return this.ruleNumber;
    }

    public int getInterval() {
        return this.interval;
    }

    public RuleCreator.CyclicType getType() {
        return this.type;
    }

    public boolean isOpen() {
        return this.startDate.isOpen();
    }

    public boolean isClosed() {
        return this.startDate.isClosed();
    }

    public StartTimeStAction.TimeFrom getStartTime() {
        return this.startTime;
    }

    public void setStartTime(StartTimeStAction.TimeFrom startTime) {
        this.startTime = startTime;
    }

    public String toString() {
        return "JobnetRule [ruleAttributes=" + this.ruleNumber + ", " + this.interval + ", " + String.valueOf((Object)this.type) + "]";
    }

    public Optional<LocalDate> getStartDateAsLocal() {
        return this.startDate.getLocalDate();
    }

    public Optional<RBC.WEEKDAYS> getWeekday() {
        return this.startDate.getWeekDay();
    }

    public RuleStartDate getStartDate() {
        return this.startDate;
    }
}

